/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.wincommon;

import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Random;

@Ser
public class Guid {
    @SerId(value=1)
    byte[] bytes;

    public static Guid parse(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[16];
        byteBuffer.get(byArray);
        return new Guid(byArray, true);
    }

    public static Guid parse(String string, boolean bl) {
        String string2 = string.replace("-", "").replace("{", "").replace("}", "").trim();
        byte[] byArray = Formatter.hexStringToByteArray(string2);
        if (byArray == null || byArray.length != 16) {
            throw new IllegalArgumentException("Cannot parse as a GUID: " + string);
        }
        if (!bl) {
            return new Guid(byArray);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(bl ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        int n2 = byteBuffer.getInt();
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        byte[] byArray2 = new byte[8];
        byteBuffer.get(byArray2);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(16);
        byteBuffer2.putInt(n2);
        byteBuffer2.putShort(s2);
        byteBuffer2.putShort(s3);
        byteBuffer2.put(byArray2);
        return new Guid(byteBuffer2.array());
    }

    public static Guid random() {
        Random random = new Random(System.currentTimeMillis());
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        return new Guid(byArray, true);
    }

    public Guid(byte[] byArray, int n2) {
        this.bytes = Arrays.copyOfRange(byArray, n2, n2 + 16);
    }

    public Guid(byte[] byArray) {
        this(byArray, false);
    }

    public Guid(byte[] byArray, boolean bl) {
        if (bl) {
            if (byArray.length != 16) {
                throw new IllegalArgumentException();
            }
            this.bytes = byArray;
        } else {
            if (byArray.length < 16) {
                throw new IllegalArgumentException();
            }
            this.bytes = Arrays.copyOf(byArray, 16);
        }
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + Arrays.hashCode(this.bytes);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Guid guid = (Guid)object;
        return Arrays.equals(this.bytes, guid.bytes);
    }

    public String toString() {
        return this.toString(true, true, true);
    }

    public String toString(boolean bl, boolean bl2, boolean bl3) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes);
        if (bl) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        String string = "";
        if (bl2) {
            string = "-";
        }
        String string2 = "";
        String string3 = "";
        if (bl3) {
            string2 = "{";
            string3 = "}";
        }
        int n2 = byteBuffer.getInt();
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        byte by3 = byteBuffer.get();
        byte by4 = byteBuffer.get();
        byte by5 = byteBuffer.get();
        byte by6 = byteBuffer.get();
        byte by7 = byteBuffer.get();
        byte by8 = byteBuffer.get();
        return Strings.ff("%s%08X%s%04X%s%04X%s%02X%02X%02X%02X%02X%02X%02X%02X%s", string2, n2, string, s2, string, s3, string, by, by2, by3, by4, by5, by6, by7, by8, string3);
    }
}

