/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.simatic;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerStaticOk;
import java.util.Calendar;
import java.util.TimeZone;

public class S7 {
    public static final int MASK_CAT = 7;
    public static final int FLAG_HAS_INIT_DATA = 8;
    public static final int FLAG_HAS_EXTENDED_INFO = 16;
    public static final int CAT_IN = 1;
    public static final int CAT_OUT = 2;
    public static final int CAT_IN_OUT = 3;
    public static final int CAT_STATIC = 4;
    public static final int CAT_TEMP = 5;
    public static final int CAT_RET = 6;

    @Ser
    public static class StringA {
        public static final int MIN_LEN = 0;
        public static final int MAX_LEN = 254;
        @SerId(value=1)
        private int maxlen;
        @SerId(value=2)
        private byte[] stringBytes;

        public StringA(int n2, byte[] byArray) {
            Assert.a(n2 >= 0 && n2 <= 254);
            Assert.a(byArray != null && byArray.length <= n2);
            this.maxlen = n2;
            this.stringBytes = byArray;
        }

        public int getCurrentLength() {
            return this.stringBytes.length;
        }

        public int getMaximumLength() {
            return this.maxlen;
        }

        public int getMemorySizeInBytes() {
            return 2 + this.maxlen;
        }

        public byte[] getStringBytes() {
            return this.stringBytes;
        }

        public String toString() {
            return Strings.decodeASCII(this.stringBytes);
        }
    }

    @Ser
    public static class DateAndTime {
        @SerStaticOk
        public static final DateAndTime DEFAULT = DateAndTime.create(-8070167957759590398L);
        @SerId(value=1)
        private long raw;
        @SerId(value=2)
        private String str;

        public static DateAndTime create(long l2) {
            return new DateAndTime(l2);
        }

        private DateAndTime(long l2) {
            this.raw = l2;
            int n2 = (int)(l2 >>> 56 & 0xFL);
            n2 = (n2 += 10 * (int)(l2 >>> 60 & 0xFL)) >= 90 ? (n2 += 1900) : (n2 += 2000);
            int n3 = (int)(l2 >>> 48 & 0xFL);
            n3 += 10 * (int)(l2 >>> 52 & 0xFL);
            int n4 = (int)(l2 >>> 40 & 0xFL);
            n4 += 10 * (int)(l2 >>> 44 & 0xFL);
            int n5 = (int)(l2 >>> 32 & 0xFL);
            n5 += 10 * (int)(l2 >>> 36 & 0xFL);
            int n6 = (int)(l2 >>> 24 & 0xFL);
            int n7 = (int)(l2 >>> 16 & 0xFL);
            int n8 = (int)(l2 >>> 8 & 0xFL);
            n8 += 10 * (int)(l2 >>> 12 & 0xFL);
            n8 *= 10;
            this.str = Strings.ff("DT#%d-%d-%d-%d:%d:%d.%d", n2, n3, n4, n5, n6 += 10 * (int)(l2 >>> 28 & 0xFL), n7 += 10 * (int)(l2 >>> 20 & 0xFL), n8 += (int)(l2 >>> 4 & 0xFL));
        }

        public long getRawValue() {
            return this.raw;
        }

        public String toString() {
            return this.str;
        }
    }

    @Ser
    public static class TimeOfDay {
        @SerStaticOk
        public static final TimeOfDay DEFAULT = TimeOfDay.create(0);
        @SerId(value=1)
        private int raw;
        @SerId(value=2)
        private String str;

        public static TimeOfDay create(int n2) {
            return new TimeOfDay(n2);
        }

        private TimeOfDay(int n2) {
            this.raw = n2;
            long l2 = n2 & 0xFFFFFFFF;
            int n3 = (int)(l2 % 1000L);
            int n4 = (int)((l2 /= 1000L) % 60L);
            int n5 = (int)((l2 /= 60L) % 60L);
            int n6 = (int)(l2 /= 60L);
            this.str = Strings.ff("TOD#%d:%d:%d.%d", n6, n5, n4, n3);
        }

        public int getRawValue() {
            return this.raw;
        }

        public String toString() {
            return this.str;
        }
    }

    @Ser
    public static class Date {
        @SerStaticOk
        public static final Date DEFAULT = Date.create(0);
        @SerId(value=1)
        private int raw;
        @SerId(value=2)
        private String str;

        public static Date create(int n2) {
            return new Date(n2);
        }

        private Date(int n2) {
            this.raw = n2 & 0xFFFF;
            int n3 = n2 * 86400 + 631152000;
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            calendar.setTime(new java.util.Date(1000L * (long)n3));
            int n4 = calendar.get(1);
            int n5 = 1 + calendar.get(2);
            int n6 = calendar.get(5);
            this.str = Strings.ff("D#%d-%d-%d", n4, n5, n6);
        }

        public short getRawValue() {
            return (short)this.raw;
        }

        public String toString() {
            return this.str;
        }
    }

    @Ser
    public static class Time {
        @SerStaticOk
        public static final Time DEFAULT = Time.create(0);
        @SerId(value=1)
        private int raw;
        @SerId(value=2)
        private String str;

        public static Time create(int n2) {
            return new Time(n2);
        }

        private Time(int n2) {
            this.raw = n2;
            boolean bl = false;
            if (n2 < 0) {
                n2 = -n2;
                bl = true;
            }
            long l2 = n2 & 0xFFFFFFFF;
            int n3 = (int)(l2 / 86400000L);
            int n4 = (int)((l2 -= (long)(86400000 * n3)) / 3600000L);
            int n5 = (int)((l2 -= (long)(3600000 * n4)) / 60000L);
            int n6 = (int)((l2 -= (long)(60000 * n5)) / 1000L);
            int n7 = (int)(l2 -= (long)(1000 * n6));
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                stringBuilder.append("-");
            }
            stringBuilder.append("T#");
            if (n3 > 0) {
                Strings.ff(stringBuilder, "%dD", n3);
            }
            if (n4 > 0) {
                Strings.ff(stringBuilder, "%dH", n4);
            }
            if (n5 > 0) {
                Strings.ff(stringBuilder, "%dM", n5);
            }
            if (n6 > 0) {
                Strings.ff(stringBuilder, "%dS", n6);
            }
            if (n7 > 0 || n3 == 0 && n4 == 0 && n6 == 0) {
                Strings.ff(stringBuilder, "%dMS", n7);
            }
            this.str = stringBuilder.toString();
        }

        public int getRawValue() {
            return this.raw;
        }

        public String toString() {
            return this.str;
        }
    }

    @Ser
    public static class S5Time {
        @SerStaticOk
        public static final S5Time DEFAULT = S5Time.create(0);
        @SerId(value=1)
        private int raw = n2 &= 0x3FFF;
        @SerId(value=2)
        private String str;

        public static S5Time create(int n2) {
            return new S5Time(n2);
        }

        private S5Time(int n2) {
            int n3 = ((n2 & 0xF00) >> 8) * 100 + ((n2 & 0xF0) >> 4) * 10 + (n2 & 0xF);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int[] nArray = new int[]{10, 100, 1000, 10000};
            int n7 = n2 >> 12 & 3;
            if ((n3 *= nArray[n7]) >= 3600000) {
                n6 = n3 / 3600000;
                n3 -= n6 * 3600000;
            }
            if (n3 >= 60000) {
                n5 = n3 / 60000;
                n3 -= n5 * 60000;
            }
            if (n3 >= 1000) {
                n4 = n3 / 1000;
                n3 -= n4 * 1000;
            }
            StringBuilder stringBuilder = new StringBuilder();
            Strings.ff(stringBuilder, "S5T#", new Object[0]);
            if (n6 > 0) {
                Strings.ff(stringBuilder, "%dH", n6);
            }
            if (n5 > 0) {
                Strings.ff(stringBuilder, "%dM", n5);
            }
            if (n4 > 0) {
                Strings.ff(stringBuilder, "%dS", n4);
            }
            if (n3 > 0 || n6 == 0 && n5 == 0 && n4 == 0) {
                Strings.ff(stringBuilder, "%dMS", n3);
            }
            this.str = stringBuilder.toString();
        }

        public short getRawValue() {
            return (short)this.raw;
        }

        public String toString() {
            return this.str;
        }
    }

    @Ser
    public static enum AreaType {
        UNKNOWN(0),
        PI_PQ(128),
        I(129),
        Q(130),
        M(131),
        DB(132),
        DI(133),
        L(134),
        V(135);

        final int id;

        private AreaType(int n3) {
            this.id = n3;
        }

        public int getId() {
            return this.id;
        }

        public static AreaType fromId(int n2) {
            for (AreaType areaType : AreaType.values()) {
                if (areaType.id != n2) continue;
                return areaType;
            }
            return UNKNOWN;
        }

        public boolean isAnyOf(AreaType ... areaTypeArray) {
            for (AreaType areaType : areaTypeArray) {
                Assert.a(areaType != null);
                if (areaType != this) continue;
                return true;
            }
            return false;
        }
    }

    @Ser
    public static enum SectionType {
        UNKNOWN(0),
        IN(1),
        OUT(2),
        IN_OUT(3),
        STAT(4),
        TEMP(5),
        RET(6);

        final int id;

        private SectionType(int n3) {
            this.id = n3;
        }

        public int getId() {
            return this.id;
        }

        public static SectionType fromId(int n2) {
            for (SectionType sectionType : SectionType.values()) {
                if (sectionType.id != n2) continue;
                return sectionType;
            }
            return UNKNOWN;
        }
    }

    @Ser
    public static enum DataType {
        UNKNOWN(0, 0),
        BOOL(1, 1, false),
        BYTE(2, 8, 0),
        CHAR(3, 8, Character.valueOf(' ')),
        WORD(4, 16, (short)0),
        INT(5, 16, (short)0),
        DWORD(6, 32, 0),
        DINT(7, 32, 0),
        REAL(8, 32, Float.valueOf(0.0f)),
        DATE(9, 16, Date.DEFAULT),
        TIME_OF_DAY(10, 32, TimeOfDay.DEFAULT),
        TIME(11, 32, Time.DEFAULT),
        S5TIME(12, 16, S5Time.DEFAULT),
        DATE_AND_TIME(14, 64, DateAndTime.DEFAULT),
        ARRAY(16, -1),
        STRUCT(17, -1),
        STRING(19, 16),
        POINTER(20, 48),
        MULTI_INST_FB(21, -1),
        ANY(22, 80),
        BLOCK_FB(23, 16),
        BLOCK_FC(24, 16),
        BLOCK_DB(25, 16),
        BLOCK_SDB(26, 16),
        MULTI_INST_SFB(27, -1),
        COUNTER(28, 16),
        TIMER(29, 16);

        final int id;
        final int bitsize;
        final Object defaultValue;

        private DataType(int n3, int n4, Object object) {
            this.id = n3;
            this.bitsize = n4;
            this.defaultValue = object;
        }

        private DataType(int n3, int n4) {
            this.id = n3;
            this.bitsize = n4;
            this.defaultValue = null;
        }

        public int getId() {
            return this.id;
        }

        public int getBitsize() {
            return this.bitsize;
        }

        public static DataType fromId(int n2) {
            for (DataType dataType : DataType.values()) {
                if (dataType.id != n2) continue;
                return dataType;
            }
            return UNKNOWN;
        }
    }

    @Ser
    public static enum BlockType {
        UNKNOWN(0),
        DI(5),
        OB(8),
        DB(10),
        SDB(11),
        FC(12),
        SFC(13),
        FB(14),
        SFB(15);

        final int id;

        private BlockType(int n3) {
            this.id = n3;
        }

        public int getId() {
            return this.id;
        }

        public static BlockType fromId(int n2) {
            for (BlockType blockType : BlockType.values()) {
                if (blockType.id != n2) continue;
                return blockType;
            }
            return UNKNOWN;
        }

        public boolean isAnyOf(BlockType ... blockTypeArray) {
            for (BlockType blockType : blockTypeArray) {
                Assert.a(blockType != null);
                if (blockType != this) continue;
                return true;
            }
            return false;
        }

        public boolean isNoneOf(BlockType ... blockTypeArray) {
            for (BlockType blockType : blockTypeArray) {
                Assert.a(blockType != null);
                if (blockType != this) continue;
                return false;
            }
            return true;
        }

        public boolean isLogicBlock() {
            switch (this) {
                case OB: 
                case FB: 
                case FC: 
                case SFB: 
                case SFC: {
                    return true;
                }
            }
            return false;
        }

        public boolean isDataBlock() {
            switch (this) {
                case DI: 
                case DB: 
                case SDB: {
                    return true;
                }
            }
            return false;
        }
    }

    @Ser
    public static enum LangType {
        UNKNOWN(0),
        STL(1),
        LAD(2),
        FBD(3),
        SCL(4),
        DB(5),
        GRAPH(6),
        CFC(7),
        SFC(8);

        final int id;

        private LangType(int n3) {
            this.id = n3;
        }

        public int getId() {
            return this.id;
        }

        public static LangType fromId(int n2) {
            for (LangType langType : LangType.values()) {
                if (langType.id != n2) continue;
                return langType;
            }
            return UNKNOWN;
        }
    }
}

