/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.java;

import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethodData;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexPrototype;
import com.pnfsoftware.jeb.core.units.code.java.IJavaType;
import com.pnfsoftware.jeb.core.units.code.java.IJavaTypeFactory;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.SortedMap;
import java.util.TreeMap;

public class JavaTypeUtil {
    private static final ILogger logger = GlobalLog.getLogger(JavaTypeUtil.class);

    public static boolean isLegalInternalClassname(String string) {
        return string.length() >= 2 && string.charAt(0) == 'L' && string.charAt(string.length() - 1) == ';' && string.indexOf(46) == -1;
    }

    public static void checkLegalInternalClassname(String string) {
        if (!JavaTypeUtil.isLegalInternalClassname(string)) {
            throw new RuntimeException("Invalid internal class name: " + string);
        }
    }

    public static String generateClassnameStandardRepresentation(String string) {
        JavaTypeUtil.checkLegalInternalClassname(string);
        return string.substring(1, string.length() - 1).replace('/', '.');
    }

    public static String generateClassnameWithoutPackage(String string) {
        JavaTypeUtil.checkLegalInternalClassname(string);
        String string2 = string.substring(1, string.length() - 1);
        int n2 = string2.lastIndexOf(47);
        if (n2 < 0) {
            return string;
        }
        return "L" + string2.substring(n2 + 1) + ";";
    }

    public static String generatePackageNameStandardRepresentation(String string) {
        JavaTypeUtil.checkLegalInternalClassname(string);
        String string2 = string.substring(1, string.length() - 1);
        int n2 = string2.lastIndexOf(47);
        if (n2 < 0) {
            return "";
        }
        return string2.substring(0, n2).replace('/', '.');
    }

    public static IJavaType[] parseShortyPrototype(String string, IJavaTypeFactory iJavaTypeFactory) {
        if (string.length() < 1) {
            throw new RuntimeException();
        }
        int n2 = string.length();
        IJavaType[] iJavaTypeArray = new IJavaType[n2];
        for (int i = 0; i < n2; ++i) {
            IJavaType iJavaType = iJavaTypeFactory.letterToType(string.charAt(i));
            if (i >= 1 && iJavaType.isVoid()) {
                throw new RuntimeException();
            }
            iJavaTypeArray[i] = iJavaType;
        }
        return iJavaTypeArray;
    }

    public static IJavaType[] parseFullPrototype(IDexPrototype iDexPrototype, IJavaTypeFactory iJavaTypeFactory) {
        String[] stringArray = iDexPrototype.getParameterSignatures(false);
        int n2 = 1 + stringArray.length;
        String[] stringArray2 = new String[n2];
        stringArray2[0] = iDexPrototype.getReturnTypeSignature(false);
        for (int i = 1; i <= stringArray.length; ++i) {
            stringArray2[i] = stringArray[i - 1];
        }
        IJavaType[] iJavaTypeArray = new IJavaType[n2];
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            int n3 = 0;
            char c2 = string.charAt(n3++);
            int n4 = 0;
            while (c2 == '[') {
                ++n4;
                c2 = string.charAt(n3++);
            }
            IJavaType iJavaType = iJavaTypeFactory.letterToType(c2);
            if (iJavaType == iJavaTypeFactory.getGenericObjectWildcard()) {
                String string2 = string.substring(n3 - 1);
                iJavaType = iJavaTypeFactory.createType(string2);
            }
            if (n4 >= 1) {
                iJavaType = iJavaTypeFactory.createArrayType(iJavaType, n4);
            }
            if (i >= 1 && iJavaType.isVoid()) {
                throw new RuntimeException();
            }
            iJavaTypeArray[i] = iJavaType;
        }
        return iJavaTypeArray;
    }

    public static SortedMap<Integer, IJavaType> parseMethodParameters(IDexUnit iDexUnit, IDexMethod iDexMethod, IJavaTypeFactory iJavaTypeFactory) {
        int n2;
        TreeMap<Integer, IJavaType> treeMap = new TreeMap<Integer, IJavaType>();
        IDexMethodData iDexMethodData = iDexMethod.getData();
        int n3 = iDexMethodData.getCodeItem().getRegisterCount();
        IJavaType[] iJavaTypeArray = JavaTypeUtil.parseFullPrototype(iDexUnit.getMethod(iDexMethod.getIndex()).getPrototype(), iJavaTypeFactory);
        int n4 = 0;
        for (n2 = iJavaTypeArray.length - 1; n2 >= 1; --n2) {
            if (iJavaTypeArray[n2].isSingleSlot()) {
                ++n4;
                continue;
            }
            if (iJavaTypeArray[n2].isDoubleSlot()) {
                n4 += 2;
                continue;
            }
            throw new RuntimeException("Unknown type: " + iJavaTypeArray[n2]);
        }
        if (!iDexMethodData.isStatic()) {
            ++n4;
        }
        if (n3 < n4) {
            logger.warn(Strings.ff("Invalid frame size: %d (minimum size expected: %d)", n3, n4), new Object[0]);
        }
        n2 = n3 - 1;
        for (int i = iJavaTypeArray.length - 1; i >= 1; --i) {
            if (n2 < 0) {
                throw new RuntimeException("method frame is too small");
            }
            if (iJavaTypeArray[i].isSingleSlot()) {
                treeMap.put(n2, iJavaTypeArray[i]);
            } else if (iJavaTypeArray[i].isDoubleSlot()) {
                if (--n2 < 0) {
                    throw new RuntimeException("method frame is too small");
                }
                treeMap.put(n2, iJavaTypeArray[i]);
            } else {
                throw new RuntimeException("unsupported type");
            }
            --n2;
        }
        if (!iDexMethodData.isStatic()) {
            if (n2 < 0) {
                throw new RuntimeException("method frame is too small");
            }
            String string = iDexUnit.getMethod(iDexMethodData.getMethodIndex()).getClassTypeSignature(false);
            treeMap.put(n2, iJavaTypeFactory.parseType(string));
        }
        treeMap.put(-1, iJavaTypeArray[0]);
        return treeMap;
    }
}

