/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.java;

import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.output.code.CppLikeDocumentPart;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.java.IDynamicContentManager;
import com.pnfsoftware.jeb.core.units.code.java.IJavaAnnotation;
import com.pnfsoftware.jeb.core.units.code.java.IJavaClass;
import com.pnfsoftware.jeb.core.units.code.java.IJavaElement;
import com.pnfsoftware.jeb.core.units.code.java.IJavaExpression;
import com.pnfsoftware.jeb.core.units.code.java.IJavaIdentifier;
import com.pnfsoftware.jeb.core.units.code.java.IJavaInstanceField;
import com.pnfsoftware.jeb.core.units.code.java.IJavaMethod;
import com.pnfsoftware.jeb.core.units.code.java.IJavaType;
import com.pnfsoftware.jeb.core.units.code.java.JavaDocument;
import com.pnfsoftware.jeb.core.units.code.java.JavaKeyword;
import com.pnfsoftware.jeb.util.collect.Maps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaOutputSink
extends CppLikeDocumentPart {
    private IDexDecompilerUnit dexdec;
    private JavaDocument doc;
    private IDynamicContentManager dynamicContentManager;
    private Deque<IJavaClass> containingClasses = new ArrayDeque<IJavaClass>();
    private Deque<IJavaElement> aststack = new ArrayDeque<IJavaElement>();
    private int current_method_index = -1;
    private List<String> generatedDecompilables = new ArrayList<String>();
    private Deque<IJavaMethod> containingMethods = new ArrayDeque<IJavaMethod>();
    private Map<Long, List<ICodeCoordinates>> identCoordMap = new HashMap<Long, List<ICodeCoordinates>>();
    private List<IJavaType> anonymousBaseTypes = new ArrayList<IJavaType>();
    private List<CaptureInfo> anonymousCaptureInfos = new ArrayList<CaptureInfo>();
    private Map<IJavaElement, List<IJavaClass>> generatedAnon = new HashMap<IJavaElement, List<IJavaClass>>();
    private List<Map<IJavaIdentifier, IJavaExpression>> replmaps = new ArrayList<Map<IJavaIdentifier, IJavaExpression>>();
    private boolean generatingReplacement;

    public JavaOutputSink(int n2) {
        super(n2);
    }

    public JavaOutputSink(int n2, JavaDocument javaDocument, IDexDecompilerUnit iDexDecompilerUnit) {
        super(n2);
        this.doc = javaDocument;
        this.dexdec = iDexDecompilerUnit;
    }

    public JavaDocument getDocument() {
        return this.doc;
    }

    public IDexDecompilerUnit getDecompilerUnit() {
        return this.dexdec;
    }

    public int getSortItemsForRendering() {
        return this.doc == null ? 1 : this.doc.optionSortItemsForRendering;
    }

    public boolean getUseDebugInfoNames() {
        return this.doc == null ? true : this.doc.optionUseDebugInfoNames;
    }

    public boolean getDisplayPrivateMethodsLast() {
        return this.doc == null ? false : this.doc.optionDisplayPrivateMethodsLast;
    }

    public boolean getInsertBlankLinesAfterCompounds() {
        return this.doc == null ? false : this.doc.optionInsertBlankLinesAfterCompounds;
    }

    public boolean getGenerateSyntheticFields() {
        return this.doc == null ? false : this.doc.optionGenerateSyntheticFields;
    }

    public boolean getGenerateSyntheticMethods() {
        return this.doc == null ? false : this.doc.optionGenerateSyntheticMethods;
    }

    public boolean getGenerateAnnotations() {
        return this.doc == null ? true : this.doc.optionGenerateAnnotations;
    }

    public int getDisplayMethodInternalsAsComment() {
        return this.doc == null ? 0 : this.doc.optionDisplayMethodInternalsAsComment;
    }

    public boolean getResolveMethodCallTargets() {
        return this.doc == null ? true : this.doc.optionResolveMethodCallTargets;
    }

    public boolean getResolveFieldAccessTargets() {
        return this.doc == null ? true : this.doc.optionResolveFieldAccessTargets;
    }

    public boolean getGenerateOverrideAnnotations() {
        return this.doc == null ? true : this.doc.optionGenerateOverrideAnnotations;
    }

    public boolean getGenerateLambdas() {
        return this.doc == null ? true : this.doc.optionGenerateLambdas;
    }

    public int getSplitCallArgThreshold() {
        return this.doc == null ? 0 : this.doc.optionSplitCallArgThreshold;
    }

    public boolean getDoNotGenerateThisIfPossible() {
        return this.doc == null ? false : this.doc.optionDoNotGenerateThisIfPossible;
    }

    public boolean getDisregardCollapse() {
        return this.doc == null ? false : this.doc.optionDisregardCollapse;
    }

    public void pushContainingClass(IJavaClass iJavaClass) {
        if (iJavaClass == null) {
            throw new RuntimeException();
        }
        this.containingClasses.push(iJavaClass);
    }

    public IJavaClass popContainingClass() {
        return this.containingClasses.pop();
    }

    public IJavaClass getCurrentContainingClass() {
        return this.containingClasses.peek();
    }

    public IJavaClass getTopLevelClass() {
        return this.containingClasses.peekLast();
    }

    public boolean isBeingGenerated(IJavaElement iJavaElement) {
        for (IJavaElement iJavaElement2 : this.aststack) {
            if (iJavaElement2 != iJavaElement) continue;
            return true;
        }
        return false;
    }

    public IJavaElement astPush(IJavaElement iJavaElement) {
        IJavaElement iJavaElement2 = this.aststack.isEmpty() ? null : this.aststack.peek();
        this.isBeingGenerated(iJavaElement);
        this.aststack.push(iJavaElement);
        return iJavaElement2;
    }

    public IJavaElement astPop() {
        return this.aststack.pop();
    }

    public IJavaElement astParent() {
        return this.aststack.isEmpty() ? null : this.aststack.peek();
    }

    public int astDepth() {
        return this.aststack.size();
    }

    public void pushContainingMethod(IJavaMethod iJavaMethod) {
        if (iJavaMethod == null) {
            throw new RuntimeException();
        }
        this.containingMethods.push(iJavaMethod);
    }

    public IJavaMethod popContainingMethod() {
        return this.containingMethods.pop();
    }

    public IJavaMethod getCurrentContainingMethod() {
        return this.containingMethods.peek();
    }

    public Collection<IJavaMethod> getContainingMethods() {
        return Collections.unmodifiableCollection(this.containingMethods);
    }

    public void setDynamicContentManager(IDynamicContentManager iDynamicContentManager) {
        this.dynamicContentManager = iDynamicContentManager;
    }

    public IDynamicContentManager getDynamicContentManager() {
        return this.dynamicContentManager;
    }

    public int setCurrentMethodIndex(int n2) {
        int n3 = this.current_method_index;
        this.current_method_index = n2;
        return n3;
    }

    public int getCurrentMethodIndex() {
        return this.current_method_index;
    }

    public void appendKeyword(JavaKeyword javaKeyword) {
        this.appendKeyword(javaKeyword.toString().toLowerCase());
    }

    public void appendKeyword(JavaKeyword javaKeyword, long l2) {
        this.appendKeyword(javaKeyword.toString().toLowerCase(), l2);
    }

    public void renderPreComment(ICodeCoordinates iCodeCoordinates) {
        this.renderComment(iCodeCoordinates, -1, true);
    }

    public void renderInlineComment(ICodeCoordinates iCodeCoordinates, boolean bl) {
        this.renderComment(iCodeCoordinates, 0, bl);
    }

    private void renderComment(ICodeCoordinates iCodeCoordinates, int n2, boolean bl) {
        this.setEolComment(null);
        IDynamicContentManager iDynamicContentManager = this.getDynamicContentManager();
        if (iDynamicContentManager != null) {
            String string;
            String string2 = string = n2 >= 0 ? iDynamicContentManager.getComment(iCodeCoordinates) : iDynamicContentManager.getPreComment(iCodeCoordinates);
            if (string != null) {
                this.appendMultiLineComment(string, false, bl);
            }
        }
    }

    public void loadCommentInline(ICodeCoordinates iCodeCoordinates) {
        String string;
        this.setEolComment(null);
        IDynamicContentManager iDynamicContentManager = this.getDynamicContentManager();
        if (iDynamicContentManager != null && (string = iDynamicContentManager.getComment(iCodeCoordinates)) != null) {
            this.onEolAddComment(string);
        }
    }

    public void appendAnnotationsList(List<IJavaAnnotation> list, char c2) {
        this.appendAnnotationsList(list, c2, null);
    }

    public void appendAnnotationsList(List<IJavaAnnotation> list, char c2, Set<String> set) {
        for (IJavaAnnotation iJavaAnnotation : list) {
            if (set != null && set.contains(iJavaAnnotation.getType().toString())) continue;
            iJavaAnnotation.generate(this, c2);
        }
    }

    public void recordIdentifierCoordinates(long l2, ICodeCoordinates iCodeCoordinates) {
        List<ICodeCoordinates> list = this.identCoordMap.get(l2);
        if (list == null) {
            list = new ArrayList<ICodeCoordinates>();
            this.identCoordMap.put(l2, list);
        }
        list.add(iCodeCoordinates);
    }

    public Map<Long, List<ICodeCoordinates>> getIdentifierCoordinates() {
        return this.identCoordMap;
    }

    public void pushAnonymousBaseType(IJavaType iJavaType) {
        this.anonymousBaseTypes.add(iJavaType);
    }

    public IJavaType popAnonymousBaseType() {
        return this.anonymousBaseTypes.remove(this.anonymousBaseTypes.size() - 1);
    }

    public IJavaType getCurrentAnonymousBaseType() {
        return this.anonymousBaseTypes.isEmpty() ? null : this.anonymousBaseTypes.get(this.anonymousBaseTypes.size() - 1);
    }

    public void pushAnonymousCaptureInfo(CaptureInfo captureInfo) {
        this.anonymousCaptureInfos.add(captureInfo);
    }

    public CaptureInfo popAnonymousCaptureInfo() {
        return this.anonymousCaptureInfos.remove(this.anonymousCaptureInfos.size() - 1);
    }

    public CaptureInfo getCurrentAnonymousCaptureInfo() {
        return this.anonymousCaptureInfos.isEmpty() ? null : this.anonymousCaptureInfos.get(this.anonymousCaptureInfos.size() - 1);
    }

    public void addGeneratedAnon(IJavaElement iJavaElement, IJavaClass iJavaClass) {
        Maps.putMulti(this.generatedAnon, iJavaElement, iJavaClass);
    }

    public List<IJavaClass> getGeneratedAnon(IJavaElement iJavaElement) {
        List<IJavaClass> list = this.generatedAnon.get(iJavaElement);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public void pushReplacements(Map<IJavaIdentifier, IJavaExpression> map) {
        this.replmaps.add(map);
    }

    public Map<IJavaIdentifier, IJavaExpression> popReplacements() {
        return this.replmaps.remove(this.replmaps.size() - 1);
    }

    public IJavaExpression getReplacementFor(IJavaIdentifier iJavaIdentifier) {
        for (int i = this.replmaps.size() - 1; i >= 0; --i) {
            IJavaExpression iJavaExpression = this.replmaps.get(i).get(iJavaIdentifier);
            if (iJavaExpression == null) continue;
            return iJavaExpression;
        }
        return null;
    }

    public void setGeneratingReplacement(boolean bl) {
        this.generatingReplacement = bl;
    }

    public boolean requestGeneratingReplacement() {
        if (this.generatingReplacement) {
            return false;
        }
        this.generatingReplacement = true;
        return true;
    }

    public void doneGeneratingReplacement() {
        this.generatingReplacement = false;
    }

    public void recordGeneratedDecompilable(String string) {
        if (string == null) {
            return;
        }
        this.generatedDecompilables.add(string);
    }

    public List<String> getDecompilables() {
        return Collections.unmodifiableList(this.generatedDecompilables);
    }

    @Override
    public void validate() {
        super.validate();
        if (!this.containingClasses.isEmpty()) {
            throw new JebRuntimeException("Class container stack should be empty!");
        }
        if (!this.containingMethods.isEmpty()) {
            throw new JebRuntimeException("Method container stack should be empty!");
        }
        if (!this.aststack.isEmpty()) {
            throw new JebRuntimeException("AST stack should be empty!");
        }
    }

    public static class CaptureInfo {
        public List<IJavaExpression> initializerArgs;
        public Map<IJavaInstanceField, IJavaExpression> synth = new HashMap<IJavaInstanceField, IJavaExpression>();
    }
}

