/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.java;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.util.HashMap;
import java.util.Map;

@Ser(oldId=65599)
public enum JavaOperatorType {
    ADD,
    SUB,
    MUL,
    DIV,
    REM,
    AND,
    OR,
    XOR,
    SHL,
    SHR,
    USHR,
    NEG,
    NOT,
    LOG_IDENT,
    LOG_NOT,
    LOG_OR,
    LOG_AND,
    INSTANCEOF,
    EQ,
    NE,
    LT,
    GE,
    GT,
    LE,
    CAST_TO_BYTE,
    CAST_TO_CHAR,
    CAST_TO_SHORT,
    CAST_TO_INT,
    CAST_TO_LONG,
    CAST_TO_FLOAT,
    CAST_TO_DOUBLE,
    CAST_TO_BOOLEAN,
    CAST_TO_OBJECT,
    CONCAT,
    COND_EXP,
    CAST_CONVERSION;

    private static final Map<JavaOperatorType, Integer> prec_table;
    private static final Map<JavaOperatorType, Associativity> asso_table;
    private static final Map<Integer, Associativity> asso_table_per_precedence;

    public int getPrecedence() {
        Integer n2 = prec_table.get((Object)this);
        return n2 == null ? 0 : n2;
    }

    public Associativity getAssociativity() {
        int n2 = this.getPrecedence();
        return asso_table_per_precedence.get(n2);
    }

    public JavaOperatorType getMirror() {
        switch (this) {
            case EQ: {
                return EQ;
            }
            case NE: {
                return NE;
            }
            case GE: {
                return LE;
            }
            case GT: {
                return LT;
            }
            case LE: {
                return GE;
            }
            case LT: {
                return GT;
            }
        }
        return null;
    }

    public boolean isAnyOf(JavaOperatorType ... javaOperatorTypeArray) {
        for (JavaOperatorType javaOperatorType : javaOperatorTypeArray) {
            if (javaOperatorType != this) continue;
            return true;
        }
        return false;
    }

    public boolean isUnary() {
        switch (this) {
            case NEG: 
            case NOT: 
            case LOG_IDENT: 
            case LOG_NOT: 
            case CAST_TO_BYTE: 
            case CAST_TO_CHAR: 
            case CAST_TO_SHORT: 
            case CAST_TO_INT: 
            case CAST_TO_LONG: 
            case CAST_TO_FLOAT: 
            case CAST_TO_DOUBLE: 
            case CAST_TO_BOOLEAN: 
            case CAST_TO_OBJECT: 
            case CAST_CONVERSION: {
                return true;
            }
        }
        return false;
    }

    public boolean isBinary() {
        switch (this) {
            case EQ: 
            case NE: 
            case GE: 
            case GT: 
            case LE: 
            case LT: 
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case REM: 
            case AND: 
            case OR: 
            case XOR: 
            case SHL: 
            case SHR: 
            case USHR: 
            case LOG_OR: 
            case LOG_AND: 
            case INSTANCEOF: 
            case CONCAT: {
                return true;
            }
        }
        return false;
    }

    public boolean isArithmetic() {
        switch (this) {
            case NEG: 
            case NOT: 
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case REM: 
            case AND: 
            case OR: 
            case XOR: 
            case SHL: 
            case SHR: 
            case USHR: {
                return true;
            }
        }
        return false;
    }

    public boolean isLogical() {
        switch (this) {
            case EQ: 
            case NE: 
            case GE: 
            case GT: 
            case LE: 
            case LT: 
            case LOG_IDENT: 
            case LOG_NOT: 
            case LOG_OR: 
            case LOG_AND: 
            case INSTANCEOF: {
                return true;
            }
        }
        return false;
    }

    public boolean isCast() {
        switch (this) {
            case CAST_TO_BYTE: 
            case CAST_TO_CHAR: 
            case CAST_TO_SHORT: 
            case CAST_TO_INT: 
            case CAST_TO_LONG: 
            case CAST_TO_FLOAT: 
            case CAST_TO_DOUBLE: 
            case CAST_TO_BOOLEAN: 
            case CAST_TO_OBJECT: 
            case CAST_CONVERSION: {
                return true;
            }
        }
        return false;
    }

    public boolean isCastToPrimitive() {
        switch (this) {
            case CAST_TO_BYTE: 
            case CAST_TO_CHAR: 
            case CAST_TO_SHORT: 
            case CAST_TO_INT: 
            case CAST_TO_LONG: 
            case CAST_TO_FLOAT: 
            case CAST_TO_DOUBLE: 
            case CAST_TO_BOOLEAN: {
                return true;
            }
        }
        return false;
    }

    static {
        prec_table = new HashMap<JavaOperatorType, Integer>();
        prec_table.put(LOG_IDENT, 1);
        prec_table.put(NEG, 2);
        prec_table.put(NOT, 2);
        prec_table.put(LOG_NOT, 2);
        prec_table.put(MUL, 3);
        prec_table.put(DIV, 3);
        prec_table.put(REM, 3);
        prec_table.put(ADD, 4);
        prec_table.put(SUB, 4);
        prec_table.put(CONCAT, 4);
        prec_table.put(SHL, 5);
        prec_table.put(SHR, 5);
        prec_table.put(USHR, 5);
        prec_table.put(LT, 6);
        prec_table.put(LE, 6);
        prec_table.put(GT, 6);
        prec_table.put(GE, 6);
        prec_table.put(INSTANCEOF, 6);
        prec_table.put(EQ, 7);
        prec_table.put(NE, 7);
        prec_table.put(AND, 8);
        prec_table.put(XOR, 9);
        prec_table.put(OR, 10);
        prec_table.put(LOG_AND, 11);
        prec_table.put(LOG_OR, 12);
        asso_table = new HashMap<JavaOperatorType, Associativity>();
        asso_table.put(NEG, Associativity.RIGHT);
        asso_table.put(NOT, Associativity.RIGHT);
        asso_table.put(LOG_NOT, Associativity.RIGHT);
        asso_table.put(MUL, Associativity.LEFT);
        asso_table.put(DIV, Associativity.LEFT);
        asso_table.put(REM, Associativity.LEFT);
        asso_table.put(ADD, Associativity.LEFT);
        asso_table.put(SUB, Associativity.LEFT);
        asso_table.put(CONCAT, Associativity.LEFT);
        asso_table.put(SHL, Associativity.LEFT);
        asso_table.put(SHR, Associativity.LEFT);
        asso_table.put(USHR, Associativity.LEFT);
        asso_table.put(LT, Associativity.LEFT);
        asso_table.put(LE, Associativity.LEFT);
        asso_table.put(GT, Associativity.LEFT);
        asso_table.put(GE, Associativity.LEFT);
        asso_table.put(INSTANCEOF, Associativity.LEFT);
        asso_table.put(EQ, Associativity.LEFT);
        asso_table.put(NE, Associativity.LEFT);
        asso_table.put(AND, Associativity.LEFT);
        asso_table.put(XOR, Associativity.LEFT);
        asso_table.put(OR, Associativity.LEFT);
        asso_table.put(LOG_AND, Associativity.LEFT);
        asso_table.put(LOG_OR, Associativity.LEFT);
        asso_table_per_precedence = new HashMap<Integer, Associativity>();
        asso_table_per_precedence.put(2, Associativity.RIGHT);
        asso_table_per_precedence.put(3, Associativity.LEFT);
        asso_table_per_precedence.put(4, Associativity.LEFT);
        asso_table_per_precedence.put(5, Associativity.LEFT);
        asso_table_per_precedence.put(6, Associativity.LEFT);
        asso_table_per_precedence.put(7, Associativity.LEFT);
        asso_table_per_precedence.put(8, Associativity.LEFT);
        asso_table_per_precedence.put(9, Associativity.LEFT);
        asso_table_per_precedence.put(10, Associativity.LEFT);
        asso_table_per_precedence.put(11, Associativity.LEFT);
        asso_table_per_precedence.put(12, Associativity.LEFT);
    }

    public static enum Associativity {
        LEFT,
        RIGHT;

    }
}

