/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.java;

import com.pnfsoftware.jeb.core.units.code.java.JavaOutputSink;

public enum JavaKeyword {
    ABSTRACT,
    ASSERT,
    BOOLEAN,
    BREAK,
    BYTE,
    CASE,
    CATCH,
    CHAR,
    CLASS,
    CONST,
    CONTINUE,
    DEFAULT,
    DO,
    DOUBLE,
    ELSE,
    ENUM,
    EXTENDS,
    FINAL,
    FINALLY,
    FLOAT,
    FOR,
    GOTO,
    IF,
    IMPLEMENTS,
    IMPORT,
    INSTANCEOF,
    INT,
    INTERFACE,
    LONG,
    NATIVE,
    NEW,
    PACKAGE,
    PRIVATE,
    PROTECTED,
    PUBLIC,
    RETURN,
    SHORT,
    STATIC,
    STRICTFP,
    SUPER,
    SWITCH,
    SYNCHRONIZED,
    THIS,
    THROW,
    THROWS,
    TRANSIENT,
    TRY,
    VOID,
    VOLATILE,
    WHILE,
    TRUE,
    FALSE,
    NULL;


    public static void generateClassAccessFlags(JavaOutputSink javaOutputSink, int n2, int n3) {
        JavaKeyword.generateAccessFlags(javaOutputSink, n2, n3, 0);
    }

    public static void generateFieldAccessFlags(JavaOutputSink javaOutputSink, int n2, int n3) {
        JavaKeyword.generateAccessFlags(javaOutputSink, n2, n3, 1);
    }

    public static void generateMethodAccessFlags(JavaOutputSink javaOutputSink, int n2, int n3) {
        JavaKeyword.generateAccessFlags(javaOutputSink, n2, n3, 2);
    }

    public static void generateAccessFlags(JavaOutputSink javaOutputSink, int n2, int n3, int n4) {
        int[] nArray = new int[]{0};
        switch (n4) {
            case 0: {
                n2 &= 0x761F;
                break;
            }
            case 1: {
                n2 &= 0x50DF;
                break;
            }
            case 2: {
                n2 &= 0x31DFF;
                break;
            }
            default: {
                throw new RuntimeException("Illegal entity type: " + n4);
            }
        }
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 1, PUBLIC);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 2, PRIVATE);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 4, PROTECTED);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 8, STATIC);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 16, FINAL);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 1024, ABSTRACT);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 512, INTERFACE);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 16384, ENUM);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 32, SYNCHRONIZED);
        if (n4 == 1) {
            JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 64, VOLATILE);
            JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 128, TRANSIENT);
        } else if (n4 == 2) {
            JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 64, null);
            JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 128, null);
        }
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 256, NATIVE);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 2048, STRICTFP);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 4096, null);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 8192, null);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 65536, null);
        JavaKeyword.appendAccessKeyword(javaOutputSink, nArray, n2, 131072, null);
        if (n3 == 1 || n3 == -1 && nArray[0] > 0) {
            javaOutputSink.append(" ");
        }
    }

    private static void appendAccessKeyword(JavaOutputSink javaOutputSink, int[] nArray, int n2, int n3, JavaKeyword javaKeyword) {
        if (javaKeyword != null && (n2 & n3) != 0) {
            if (nArray[0] > 0) {
                javaOutputSink.append(" ");
            }
            if (n3 == 512 && (n2 & 0x2000) != 0) {
                javaOutputSink.append("@");
            }
            javaOutputSink.appendKeyword(javaKeyword);
            nArray[0] = nArray[0] + 1;
        }
    }

    public static void appendAccessKeyword(JavaOutputSink javaOutputSink, JavaKeyword javaKeyword) {
        javaOutputSink.appendKeyword(javaKeyword);
    }
}

