/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.java;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.CoordinatesConversionPrecision;
import com.pnfsoftware.jeb.core.output.code.CodeDocument;
import com.pnfsoftware.jeb.core.output.code.CodeLine;
import com.pnfsoftware.jeb.core.output.code.coordinates.CodeCoordinatesUtil;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionGroup;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeSelection;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.java.IJavaElement;
import com.pnfsoftware.jeb.core.units.code.java.IJavaSourceUnit;
import com.pnfsoftware.jeb.core.units.code.java.JavaOutputSink;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class JavaDocument
extends CodeDocument {
    private static final ILogger logger = GlobalLog.getLogger(JavaDocument.class);
    public static final String propnameSortItemsForRendering = "SortItemsForRendering";
    public static final String propnameUseDebugInfoNames = "UseDebugInfoNames";
    public static final String propnameDisplayMethodInternalsAsComment = "DisplayMethodInternalsAsComment";
    public static final String propnameDisplayPrivateMethodsLast = "DisplayPrivateMethodsLast";
    public static final String propnameInsertBlankLinesAfterCompounds = "InsertBlankLinesAfterCompounds";
    public static final String propnameGenerateSyntheticFields = "GenerateSyntheticFields";
    public static final String propnameGenerateSyntheticMethods = "GenerateSyntheticMethods";
    public static final String propnameGenerateAnnotations = "GenerateAnnotations";
    public static final String propnameResolveMethodCallTargets = "ResolveMethodCallTargets";
    public static final String propnameResolveFieldAccessTargets = "ResolveFieldAccessTargets";
    public static final String propnameGenerateOverrideAnnotations = "GenerateOverrideAnnotations";
    public static final String propnameGenerateLambdas = "GenerateLambdas";
    public static final String propnameDisplayASTElementStackOnHover = "DisplayASTElementStackOnHover";
    public static final String propnameSplitCallArgThreshold = "SplitCallArgThreshold";
    public static final String propnameDoNotGenerateThisIfPossible = "DoNotGenerateThisIfPossible";
    public static final String propnameDisregardCollapse = "DisregardCollapse";
    private boolean disposed;
    private IJavaSourceUnit ast;
    private IPropertyManager pm;
    private IDexDecompilerUnit dexdec;
    private IEventListener unitListener;
    private IEventListener pmListener;
    private JavaOutputSink singlePart;
    int optionSortItemsForRendering;
    boolean optionUseDebugInfoNames;
    boolean optionDisplayPrivateMethodsLast;
    boolean optionInsertBlankLinesAfterCompounds;
    boolean optionGenerateSyntheticFields;
    boolean optionGenerateSyntheticMethods;
    boolean optionGenerateSyntheticTypes;
    boolean optionGenerateAnnotations;
    int optionDisplayMethodInternalsAsComment;
    boolean optionResolveMethodCallTargets;
    boolean optionResolveFieldAccessTargets;
    boolean optionGenerateOverrideAnnotations;
    boolean optionGenerateLambdas;
    int optionSplitCallArgThreshold;
    boolean optionDoNotGenerateThisIfPossible;
    boolean optionDisregardCollapse;

    public static void buildPDM(IPropertyDefinitionManager iPropertyDefinitionManager) {
        IPropertyDefinitionGroup iPropertyDefinitionGroup = iPropertyDefinitionManager.addGroup("text");
        iPropertyDefinitionGroup.addDefinition(propnameUseDebugInfoNames, PropertyTypeBoolean.create(true), "Use names located in dex debug information (if available)");
        iPropertyDefinitionGroup.addDefinition(propnameDoNotGenerateThisIfPossible, PropertyTypeBoolean.create(false), "When no naming conflict is detected, avoid generating the 'this' prefix when accessing objects' attributes or invoking objects' methods");
        iPropertyDefinitionGroup.addDefinition(propnameSortItemsForRendering, PropertyTypeSelection.Builder.create().addEntry(0, "None", "No sort (rendered as they appear in native code)").addDefaultEntry(1, "Alpha, Access", "Items sorted alphabetically and by access type").build(), "Sort class, field and method source items before rendering them");
        iPropertyDefinitionGroup.addDefinition(propnameDisplayMethodInternalsAsComment, PropertyTypeSelection.Builder.create().addDefaultEntry(0, "None", "Display no addition").addEntry(1, "Signature", "Display the original method signature").addEntry(2, "Signature, AST", "Display the original method signature and the flattened AST of the method").build(), "When rendering source, prepend method internals as a comment block before rendering the method");
        iPropertyDefinitionGroup.addDefinition(propnameDisplayPrivateMethodsLast, PropertyTypeBoolean.create(false), "Output private methods last (after public, default and protected methods)");
        iPropertyDefinitionGroup.addDefinition(propnameInsertBlankLinesAfterCompounds, PropertyTypeBoolean.create(true), "Insert blank lines between compounds");
        iPropertyDefinitionGroup.addDefinition(propnameGenerateSyntheticFields, PropertyTypeBoolean.create(false), "Explicitly generate synthetic fields");
        iPropertyDefinitionGroup.addDefinition(propnameGenerateSyntheticMethods, PropertyTypeBoolean.create(false), "Explicitly generate synthetic methods");
        iPropertyDefinitionGroup.addDefinition(propnameGenerateAnnotations, PropertyTypeBoolean.create(true), "Generate Java annotations");
        iPropertyDefinitionGroup.addDefinition(propnameResolveMethodCallTargets, PropertyTypeBoolean.create(true), "Resolve calls to virtual and static methods, possibly offering a list of candidates methods to client code");
        iPropertyDefinitionGroup.addDefinition(propnameResolveFieldAccessTargets, PropertyTypeBoolean.create(true), "Resolve accesses to object and class fields");
        iPropertyDefinitionGroup.addDefinition(propnameGenerateOverrideAnnotations, PropertyTypeBoolean.create(true), "Geneate additional @Override annotations for methods for which super implementations or definitions were found");
        iPropertyDefinitionGroup.addDefinition(propnameGenerateLambdas, PropertyTypeBoolean.create(true), "Favor the generation of lambda functions (Java 8+) if possible. Lambdas must have been reconstructed (engines option)");
        iPropertyDefinitionGroup.addDefinition(propnameDisplayASTElementStackOnHover, PropertyTypeBoolean.create(true), "Display the parent and ancestors of a decompiled Java AST node when the mouse cursor hovers over it (useful to debug or troubleshoot a script)");
        iPropertyDefinitionGroup.addDefinition(propnameSplitCallArgThreshold, PropertyTypeInteger.create(10), "Split a method invocation's arguments on single-lines, with parameter details, for methods with more than that number of parameters (does not apply to lambdas). Use 0 to disable splitting.");
        iPropertyDefinitionGroup.addDefinition(propnameDisregardCollapse, PropertyTypeBoolean.create(), "Disregard the 'collapse' attribute set on dex items, i.e. always generate fully-expanded class or method code.");
    }

    public JavaDocument(IJavaSourceUnit iJavaSourceUnit) {
        this.ast = iJavaSourceUnit;
        this.dexdec = (IDexDecompilerUnit)iJavaSourceUnit.getParent();
        this.setupOptions(false);
        this.unitListener = new IEventListener(){

            @Override
            public void onEvent(IEvent iEvent) {
                JebEvent jebEvent = (JebEvent)iEvent;
                if (jebEvent.getType() == J.UnitChange) {
                    JavaDocument.this.notifyListeners(jebEvent);
                }
            }
        };
        iJavaSourceUnit.addListener(this.unitListener);
        this.pm = this.dexdec.getPropertyManager();
        this.pmListener = new IEventListener(){

            @Override
            public void onEvent(IEvent iEvent) {
                if (iEvent instanceof JebEvent && iEvent.getType() == J.PropertyChange && iEvent.getData() instanceof PropertyChangeNotification) {
                    PropertyChangeNotification propertyChangeNotification = (PropertyChangeNotification)iEvent.getData();
                    (new Object[1])[0] = propertyChangeNotification;
                    JavaDocument.this.setupOptions(true);
                }
            }
        };
        this.pm.addListener(this.pmListener);
    }

    void setupOptions(boolean bl) {
        IPropertyManager iPropertyManager = this.dexdec.getPropertyManager();
        this.optionSortItemsForRendering = iPropertyManager.getInteger(propnameSortItemsForRendering);
        this.optionUseDebugInfoNames = iPropertyManager.getBoolean(propnameUseDebugInfoNames);
        this.optionDisplayPrivateMethodsLast = iPropertyManager.getBoolean(propnameDisplayPrivateMethodsLast);
        this.optionInsertBlankLinesAfterCompounds = iPropertyManager.getBoolean(propnameInsertBlankLinesAfterCompounds);
        this.optionGenerateSyntheticFields = iPropertyManager.getBoolean(propnameGenerateSyntheticFields);
        this.optionGenerateSyntheticMethods = iPropertyManager.getBoolean(propnameGenerateSyntheticMethods);
        this.optionGenerateAnnotations = iPropertyManager.getBoolean(propnameGenerateAnnotations);
        this.optionDisplayMethodInternalsAsComment = iPropertyManager.getInteger(propnameDisplayMethodInternalsAsComment);
        this.optionResolveMethodCallTargets = iPropertyManager.getBoolean(propnameResolveMethodCallTargets);
        this.optionResolveFieldAccessTargets = iPropertyManager.getBoolean(propnameResolveFieldAccessTargets);
        this.optionGenerateOverrideAnnotations = iPropertyManager.getBoolean(propnameGenerateOverrideAnnotations);
        this.optionGenerateLambdas = iPropertyManager.getBoolean(propnameGenerateLambdas);
        this.optionSplitCallArgThreshold = iPropertyManager.getInteger(propnameSplitCallArgThreshold);
        this.optionDoNotGenerateThisIfPossible = iPropertyManager.getBoolean(propnameDoNotGenerateThisIfPossible);
        this.optionDisregardCollapse = iPropertyManager.getBoolean(propnameDisregardCollapse);
        if (bl) {
            this.notifyListeners(new JebEvent(J.UnitChange));
        }
    }

    public IJavaSourceUnit getOwnerUnit() {
        return this.ast;
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            super.dispose();
            this.ast.removeListener(this.unitListener);
            this.pm.removeListener(this.pmListener);
            this.disposed = true;
        }
    }

    @Override
    public IUnit getUnit() {
        return this.ast;
    }

    @Override
    public long getAnchorCount() {
        return 1L;
    }

    @Override
    public JavaOutputSink getDocumentPart(long l2, int n2, int n3) {
        JavaOutputSink javaOutputSink = new JavaOutputSink(0, this, this.dexdec);
        javaOutputSink.registerAnchor("single_anchor");
        IJavaElement iJavaElement = this.ast.getASTElement();
        javaOutputSink.setDynamicContentManager(this.dexdec.getDynamicContentManager());
        iJavaElement.generate(javaOutputSink);
        try {
            javaOutputSink.validate();
        }
        catch (Exception exception) {}
        this.singlePart = javaOutputSink;
        Map<Long, List<ICodeCoordinates>> map = javaOutputSink.getIdentifierCoordinates();
        for (long l3 : map.keySet()) {
            for (ICodeCoordinates iCodeCoordinates : map.get(l3)) {
                this.ast.recordIdentifierPositions(l3, iCodeCoordinates);
            }
        }
        return javaOutputSink;
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        ICodeCoordinates iCodeCoordinates = this.coordinatesToCodeCoordinates(iCoordinates);
        if (iCodeCoordinates == null) {
            return null;
        }
        IDexUnit iDexUnit = (IDexUnit)((IDexDecompilerUnit)this.ast.getParent()).getParent();
        return iDexUnit.getAddressFromCodeCoordinates(iCodeCoordinates);
    }

    public ICodeCoordinates coordinatesToCodeCoordinates(ICoordinates iCoordinates) {
        InstructionCoordinates instructionCoordinates;
        ICodeCoordinates iCodeCoordinates;
        InstructionCoordinates instructionCoordinates2;
        if (iCoordinates == null) {
            return null;
        }
        int n2 = iCoordinates.getLineDelta();
        if (this.singlePart == null || n2 < 0 || n2 >= this.singlePart.getLines().size()) {
            return null;
        }
        List<CodeLine> list = this.singlePart.getLines();
        CodeLine codeLine = list.get(n2);
        ICodeCoordinates iCodeCoordinates2 = codeLine.getCoordinates(iCoordinates.getColumnOffset());
        ICodeCoordinates iCodeCoordinates3 = codeLine.getLineCoordinates();
        if (iCodeCoordinates2 == null && iCodeCoordinates3 == null) {
            int n3;
            int n4 = Math.min(n3 + 10, list.size());
            for (n3 = n2 + 1; n3 < n4 && (iCodeCoordinates3 = (codeLine = list.get(n3)).getLineCoordinates()) == null; ++n3) {
            }
            if (iCodeCoordinates3 == null) {
                return null;
            }
        }
        if (iCodeCoordinates2 instanceof InstructionCoordinates && (instructionCoordinates2 = (InstructionCoordinates)iCodeCoordinates2).getMethodId() < 0) {
            iCodeCoordinates2 = null;
        }
        if ((iCodeCoordinates = iCodeCoordinates2) == null) {
            iCodeCoordinates = iCodeCoordinates3;
        }
        if (iCodeCoordinates == null) {
            return null;
        }
        if (iCodeCoordinates3 instanceof InstructionCoordinates && iCodeCoordinates2 instanceof InstructionCoordinates) {
            InstructionCoordinates instructionCoordinates3 = (InstructionCoordinates)iCodeCoordinates3;
            InstructionCoordinates instructionCoordinates4 = (InstructionCoordinates)iCodeCoordinates2;
            if (instructionCoordinates3.getOffset() >= 0 && instructionCoordinates4.getOffset() < 0) {
                iCodeCoordinates = iCodeCoordinates3;
            }
        }
        if (iCodeCoordinates instanceof InstructionCoordinates && (instructionCoordinates = (InstructionCoordinates)iCodeCoordinates).getOffset() < 0) {
            iCodeCoordinates = new MethodCoordinates(instructionCoordinates.getMethodId());
        }
        return iCodeCoordinates;
    }

    @Override
    public ICoordinates addressToCoordinates(String string, CoordinatesConversionPrecision coordinatesConversionPrecision) {
        IDexUnit iDexUnit = (IDexUnit)((IDexDecompilerUnit)this.ast.getParent()).getParent();
        ICodeCoordinates iCodeCoordinates = iDexUnit.getCodeCoordinatesFromAddress(string);
        if (iCodeCoordinates == null) {
            return null;
        }
        ListIterator<CodeLine> listIterator = Lists.reverseIterator(this.singlePart.getLines());
        while (listIterator.hasPrevious()) {
            ICodeCoordinates iCodeCoordinates2 = listIterator.previous().getLineCoordinates();
            if (!iCodeCoordinates.equals(iCodeCoordinates2)) continue;
            return new Coordinates(0L, listIterator.nextIndex(), 0);
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (CodeLine codeLine : this.singlePart.getLines()) {
            ICodeCoordinates iCodeCoordinates3 = codeLine.getLineCoordinates();
            if (iCodeCoordinates.equals(iCodeCoordinates3)) {
                return new Coordinates(0L, n5, 0);
            }
            int n6 = CodeCoordinatesUtil.distance(iCodeCoordinates, iCodeCoordinates3);
            if (n6 < n2) {
                n2 = n6;
                n3 = n5;
                n4 = 0;
            }
            Map<Integer, ICodeCoordinates> map = codeLine.getCoordinates();
            for (Integer n7 : map.keySet()) {
                iCodeCoordinates3 = map.get(n7);
                if (iCodeCoordinates.equals(iCodeCoordinates3)) {
                    return new Coordinates(0L, n5, n7);
                }
                n6 = CodeCoordinatesUtil.distance(iCodeCoordinates, iCodeCoordinates3);
                if (n6 >= n2) continue;
                n2 = n6;
                n3 = n5;
                n4 = n7;
            }
            ++n5;
        }
        if (n2 < Integer.MAX_VALUE) {
            (new Object[1])[0] = n2;
            return new Coordinates(0L, n3, n4);
        }
        return null;
    }
}

