/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.java;

import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.units.code.IVisitResults;
import com.pnfsoftware.jeb.core.units.code.java.IJVisitor;
import com.pnfsoftware.jeb.core.units.code.java.IJavaAssignment;
import com.pnfsoftware.jeb.core.units.code.java.IJavaBlock;
import com.pnfsoftware.jeb.core.units.code.java.IJavaBreak;
import com.pnfsoftware.jeb.core.units.code.java.IJavaCatchBlock;
import com.pnfsoftware.jeb.core.units.code.java.IJavaClass;
import com.pnfsoftware.jeb.core.units.code.java.IJavaCompound;
import com.pnfsoftware.jeb.core.units.code.java.IJavaConstant;
import com.pnfsoftware.jeb.core.units.code.java.IJavaConstantFactory;
import com.pnfsoftware.jeb.core.units.code.java.IJavaContinue;
import com.pnfsoftware.jeb.core.units.code.java.IJavaDefinition;
import com.pnfsoftware.jeb.core.units.code.java.IJavaDoWhile;
import com.pnfsoftware.jeb.core.units.code.java.IJavaElement;
import com.pnfsoftware.jeb.core.units.code.java.IJavaExpression;
import com.pnfsoftware.jeb.core.units.code.java.IJavaField;
import com.pnfsoftware.jeb.core.units.code.java.IJavaGoto;
import com.pnfsoftware.jeb.core.units.code.java.IJavaIdentifier;
import com.pnfsoftware.jeb.core.units.code.java.IJavaIf;
import com.pnfsoftware.jeb.core.units.code.java.IJavaLabel;
import com.pnfsoftware.jeb.core.units.code.java.IJavaMethod;
import com.pnfsoftware.jeb.core.units.code.java.IJavaMonitor;
import com.pnfsoftware.jeb.core.units.code.java.IJavaOperation;
import com.pnfsoftware.jeb.core.units.code.java.IJavaPredicate;
import com.pnfsoftware.jeb.core.units.code.java.IJavaReturn;
import com.pnfsoftware.jeb.core.units.code.java.IJavaStatement;
import com.pnfsoftware.jeb.core.units.code.java.IJavaThrow;
import com.pnfsoftware.jeb.core.units.code.java.IJavaTry;
import com.pnfsoftware.jeb.core.units.code.java.IJavaType;
import com.pnfsoftware.jeb.core.units.code.java.IJavaWhile;
import com.pnfsoftware.jeb.core.units.code.java.JavaOperatorType;
import com.pnfsoftware.jeb.core.units.code.java.JavaOutputSink;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class JUtil {
    public static String generate(IJavaElement iJavaElement) {
        JavaOutputSink javaOutputSink = new JavaOutputSink(0);
        iJavaElement.generate(javaOutputSink);
        return TextPartUtil.buildRawTextFromPart(javaOutputSink);
    }

    public static IJavaElement findParent(IJavaElement iJavaElement, IJavaElement iJavaElement2) {
        List<IJavaElement> list = iJavaElement.getSubElements();
        for (IJavaElement iJavaElement3 : list) {
            if (iJavaElement3 != iJavaElement2) continue;
            return iJavaElement;
        }
        for (IJavaElement iJavaElement3 : list) {
            IJavaElement iJavaElement4 = JUtil.findParent(iJavaElement3, iJavaElement2);
            if (iJavaElement4 == null) continue;
            return iJavaElement4;
        }
        return null;
    }

    public static boolean isClassMethodField(IJavaElement iJavaElement) {
        return iJavaElement instanceof IJavaMethod || iJavaElement instanceof IJavaClass || iJavaElement instanceof IJavaField;
    }

    public static boolean isIntegerConstant(IJavaElement iJavaElement, int n2) {
        if (iJavaElement instanceof IJavaConstant && ((IJavaConstant)iJavaElement).getType().isInt()) {
            return ((IJavaConstant)iJavaElement).getInt() == n2;
        }
        return false;
    }

    public static boolean isStringConstant(IJavaElement iJavaElement) {
        return iJavaElement instanceof IJavaConstant && ((IJavaConstant)iJavaElement).isString();
    }

    public static String getStringConstant(IJavaElement iJavaElement) {
        return iJavaElement instanceof IJavaConstant && ((IJavaConstant)iJavaElement).isString() ? ((IJavaConstant)iJavaElement).getString() : null;
    }

    public static IJavaLabel checkIfGoto(IJavaStatement iJavaStatement) {
        if (!(iJavaStatement instanceof IJavaIf)) {
            return null;
        }
        IJavaIf iJavaIf = (IJavaIf)iJavaStatement;
        if (iJavaIf.size() != 1) {
            return null;
        }
        IJavaBlock iJavaBlock = iJavaIf.getBranchBody(0);
        if (iJavaBlock.size() != 1 || !(iJavaBlock.get(0) instanceof IJavaGoto)) {
            return null;
        }
        return ((IJavaGoto)iJavaBlock.get(0)).getLabel();
    }

    public static boolean isGotoTo(IJavaStatement iJavaStatement, IJavaLabel iJavaLabel) {
        return iJavaStatement instanceof IJavaGoto && ((IJavaGoto)iJavaStatement).getLabel() == iJavaLabel;
    }

    public static boolean isIf(IJavaStatement iJavaStatement) {
        IJavaIf iJavaIf;
        return iJavaStatement instanceof IJavaIf && (iJavaIf = (IJavaIf)iJavaStatement).size() == 1;
    }

    public static boolean isIfElse(IJavaStatement iJavaStatement) {
        IJavaIf iJavaIf;
        return iJavaStatement instanceof IJavaIf && (iJavaIf = (IJavaIf)iJavaStatement).size() == 2 && iJavaIf.hasDefaultBlock();
    }

    public static boolean isIfNoElse(IJavaStatement iJavaStatement) {
        if (iJavaStatement instanceof IJavaIf) {
            IJavaIf iJavaIf = (IJavaIf)iJavaStatement;
            return !iJavaIf.hasDefaultBlock();
        }
        return false;
    }

    public static IJavaLabel isIfGoto(IJavaStatement iJavaStatement) {
        IJavaBlock iJavaBlock;
        IJavaIf iJavaIf;
        if (iJavaStatement instanceof IJavaIf && (iJavaIf = (IJavaIf)iJavaStatement).size() == 1 && (iJavaBlock = iJavaIf.getBranchBody(0)).size() == 1 && iJavaBlock.get(0) instanceof IJavaGoto) {
            return ((IJavaGoto)iJavaBlock.get(0)).getLabel();
        }
        return null;
    }

    public static IJavaStatement getFirstRealStatement(IJavaBlock iJavaBlock, int n2) {
        if (n2 >= iJavaBlock.size()) {
            return null;
        }
        IJavaStatement iJavaStatement = iJavaBlock.get(n2);
        if (!(iJavaStatement instanceof IJavaCompound)) {
            return iJavaStatement;
        }
        if (iJavaStatement instanceof IJavaDoWhile) {
            IJavaStatement iJavaStatement2 = JUtil.getFirstRealStatement(((IJavaDoWhile)iJavaStatement).getBody(), 0);
            return iJavaStatement2 == null ? iJavaStatement : iJavaStatement2;
        }
        if (iJavaStatement instanceof IJavaWhile) {
            if (!((IJavaWhile)iJavaStatement).getPredicate().isLitteralTrue()) {
                return iJavaStatement;
            }
            IJavaStatement iJavaStatement3 = JUtil.getFirstRealStatement(((IJavaWhile)iJavaStatement).getBody(), 0);
            return iJavaStatement3 == null ? iJavaStatement : iJavaStatement3;
        }
        if (iJavaStatement instanceof IJavaIf) {
            if (!((IJavaIf)iJavaStatement).getBranchPredicate(0).isLitteralTrue()) {
                return iJavaStatement;
            }
            IJavaStatement iJavaStatement4 = JUtil.getFirstRealStatement(((IJavaIf)iJavaStatement).getBranchBody(0), 0);
            return iJavaStatement4 == null ? iJavaStatement : iJavaStatement4;
        }
        if (iJavaStatement instanceof IJavaTry) {
            IJavaStatement iJavaStatement5 = JUtil.getFirstRealStatement(((IJavaTry)iJavaStatement).getTryBody(), 0);
            return iJavaStatement5 == null ? iJavaStatement : iJavaStatement5;
        }
        return iJavaStatement;
    }

    public static IJavaCatchBlock isTryCatchall(IJavaBlock iJavaBlock, int n2) {
        if (n2 < iJavaBlock.size() && iJavaBlock.get(n2) instanceof IJavaTry) {
            IJavaTry iJavaTry = (IJavaTry)iJavaBlock.get(n2);
            return JUtil.isTryCatchall(iJavaTry);
        }
        return null;
    }

    public static IJavaCatchBlock isTryCatchall(IJavaTry iJavaTry) {
        if (!iJavaTry.hasFinallyBlock() && iJavaTry.getCatchCount() == 1 && "Ljava/lang/Throwable;".equals(iJavaTry.getCatchType(0).getName())) {
            return iJavaTry.getCatchBlock(0);
        }
        return null;
    }

    public static IJavaIdentifier getVarLike(IJavaExpression iJavaExpression) {
        if (iJavaExpression instanceof IJavaIdentifier) {
            return (IJavaIdentifier)iJavaExpression;
        }
        if (iJavaExpression instanceof IJavaOperation && ((IJavaOperation)iJavaExpression).getOperator().isCast()) {
            IJavaExpression iJavaExpression2 = ((IJavaOperation)iJavaExpression).getRight();
            return JUtil.getVarLike(iJavaExpression2);
        }
        return null;
    }

    public static boolean isImmOrVarLike(IJavaExpression iJavaExpression) {
        if (iJavaExpression instanceof IJavaConstant || iJavaExpression instanceof IJavaIdentifier) {
            return true;
        }
        if (iJavaExpression instanceof IJavaOperation && ((IJavaOperation)iJavaExpression).getOperator().isCast()) {
            IJavaExpression iJavaExpression2 = ((IJavaOperation)iJavaExpression).getRight();
            return JUtil.isImmOrVarLike(iJavaExpression2);
        }
        return false;
    }

    public static List<IJavaIdentifier> getIdentifiers(IJavaElement iJavaElement) {
        final ArrayList<IJavaIdentifier> arrayList = new ArrayList<IJavaIdentifier>();
        iJavaElement.visitDepthPost(new IJVisitor(){

            @Override
            public void process(IJavaElement iJavaElement, IJavaElement iJavaElement2, IVisitResults<IJavaElement> iVisitResults) {
                if (iJavaElement instanceof IJavaIdentifier) {
                    arrayList.add((IJavaIdentifier)iJavaElement);
                }
            }
        });
        return arrayList;
    }

    public static boolean isIdentOrDefinition(IJavaElement iJavaElement, IJavaIdentifier iJavaIdentifier) {
        if (iJavaElement == iJavaIdentifier) {
            return true;
        }
        return iJavaElement instanceof IJavaDefinition && ((IJavaDefinition)iJavaElement).getIdentifier() == iJavaIdentifier;
    }

    public static boolean isDeclarationOrDefinition(IJavaStatement iJavaStatement) {
        if (iJavaStatement instanceof IJavaDefinition) {
            return true;
        }
        return iJavaStatement instanceof IJavaAssignment && ((IJavaAssignment)iJavaStatement).getLeft() instanceof IJavaDefinition;
    }

    public static IJavaExpression isThrowLike(IJavaStatement iJavaStatement, List<IJavaStatement> list) {
        if (iJavaStatement instanceof IJavaThrow) {
            return ((IJavaThrow)iJavaStatement).getExpression();
        }
        if (iJavaStatement instanceof IJavaGoto) {
            IJavaLabel iJavaLabel = ((IJavaGoto)iJavaStatement).getLabel();
            int n2 = 0;
            for (IJavaStatement iJavaStatement2 : list) {
                if (iJavaStatement2 == iJavaLabel) {
                    IJavaStatement iJavaStatement3;
                    if (n2 + 1 >= list.size() || !((iJavaStatement3 = list.get(n2 + 1)) instanceof IJavaThrow)) break;
                    return ((IJavaThrow)iJavaStatement3).getExpression();
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isThrow(IJavaStatement iJavaStatement, IJavaExpression iJavaExpression) {
        if (iJavaStatement instanceof IJavaThrow) {
            return ((IJavaThrow)iJavaStatement).getExpression() == iJavaExpression;
        }
        return false;
    }

    public static IJavaExpression getMonitorEnter(IJavaStatement iJavaStatement) {
        if (iJavaStatement instanceof IJavaMonitor && ((IJavaMonitor)iJavaStatement).isEnter()) {
            return ((IJavaMonitor)iJavaStatement).getLock();
        }
        return null;
    }

    public static IJavaExpression getMonitorExit(IJavaStatement iJavaStatement) {
        if (iJavaStatement instanceof IJavaMonitor && ((IJavaMonitor)iJavaStatement).isExit()) {
            return ((IJavaMonitor)iJavaStatement).getLock();
        }
        return null;
    }

    public static boolean isMonitorExit(IJavaElement iJavaElement) {
        return iJavaElement instanceof IJavaMonitor && ((IJavaMonitor)iJavaElement).isExit();
    }

    public static boolean isMonitorExit(IJavaElement iJavaElement, IJavaExpression iJavaExpression) {
        return iJavaElement instanceof IJavaMonitor && ((IJavaMonitor)iJavaElement).isExit() && (iJavaExpression == null || ((IJavaMonitor)iJavaElement).getLock() == iJavaExpression);
    }

    public static List<IJavaStatement> getGotos(IJavaLabel iJavaLabel, List<IJavaStatement> list) {
        ArrayList<IJavaStatement> arrayList = new ArrayList<IJavaStatement>();
        for (IJavaStatement iJavaStatement : list) {
            if (!(iJavaStatement instanceof IJavaGoto) || ((IJavaGoto)iJavaStatement).getLabel() != iJavaLabel) continue;
            arrayList.add(iJavaStatement);
        }
        return arrayList;
    }

    public static IJavaLabel getGotoLabel(IJavaStatement iJavaStatement) {
        if (iJavaStatement instanceof IJavaGoto) {
            return ((IJavaGoto)iJavaStatement).getLabel();
        }
        return null;
    }

    public static IJavaIdentifier getIdentifier(IJavaExpression iJavaExpression) {
        if (iJavaExpression instanceof IJavaIdentifier) {
            return (IJavaIdentifier)iJavaExpression;
        }
        if (iJavaExpression instanceof IJavaDefinition) {
            return ((IJavaDefinition)iJavaExpression).getIdentifier();
        }
        return null;
    }

    public static int removeStatementsDeep(IJavaBlock iJavaBlock, Predicate<IJavaStatement> predicate) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < iJavaBlock.size()) {
            IJavaStatement iJavaStatement = iJavaBlock.get(n3);
            if (predicate.test(iJavaStatement)) {
                iJavaBlock.remove(n3);
                ++n2;
                continue;
            }
            if (iJavaStatement instanceof IJavaCompound) {
                for (IJavaBlock iJavaBlock2 : ((IJavaCompound)iJavaStatement).getBlocks()) {
                    n2 += JUtil.removeStatementsDeep(iJavaBlock2, predicate);
                }
            }
            ++n3;
        }
        return n2;
    }

    public static boolean isOrContainsLabel(IJavaStatement iJavaStatement) {
        if (iJavaStatement instanceof IJavaLabel) {
            return true;
        }
        if (iJavaStatement instanceof IJavaCompound) {
            for (IJavaBlock iJavaBlock : ((IJavaCompound)iJavaStatement).getBlocks()) {
                for (IJavaStatement iJavaStatement2 : iJavaBlock) {
                    if (!JUtil.isOrContainsLabel(iJavaStatement2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean canThrow(IJavaStatement iJavaStatement) {
        return !iJavaStatement.visitDepthPost(new IJVisitor(){

            @Override
            public void process(IJavaElement iJavaElement, IJavaElement iJavaElement2, IVisitResults<IJavaElement> iVisitResults) {
                if (iJavaElement.canCauseException()) {
                    iVisitResults.interrupt(false);
                }
            }
        });
    }

    public static IJavaExpression getSimplePredicate(IJavaPredicate iJavaPredicate) {
        if (iJavaPredicate.getLeft() == null && iJavaPredicate.getOperator().is(JavaOperatorType.LOG_IDENT)) {
            return iJavaPredicate.getRight();
        }
        return null;
    }

    public static IJavaConstant getNegatedConstant(IJavaConstant iJavaConstant, IJavaConstantFactory iJavaConstantFactory) {
        IJavaType iJavaType = iJavaConstant.getType();
        if (iJavaType == null) {
            return null;
        }
        IJavaConstant iJavaConstant2 = null;
        if (iJavaType.isBoolean()) {
            iJavaConstant2 = iJavaConstantFactory.createBoolean(!iJavaConstant.getBoolean());
        } else if (iJavaType.isByte()) {
            iJavaConstant2 = iJavaConstantFactory.createByte(-iJavaConstant.getByte());
        } else if (iJavaType.isChar()) {
            iJavaConstant2 = iJavaConstantFactory.createChar(-iJavaConstant.getChar());
        } else if (iJavaType.isShort()) {
            iJavaConstant2 = iJavaConstantFactory.createShort(-iJavaConstant.getShort());
        } else if (iJavaType.isInt()) {
            iJavaConstant2 = iJavaConstantFactory.createInt(-iJavaConstant.getInt());
        } else if (iJavaType.isLong()) {
            iJavaConstant2 = iJavaConstantFactory.createLong(-iJavaConstant.getLong());
        } else if (iJavaType.isFloat()) {
            iJavaConstant2 = iJavaConstantFactory.createFloat(-iJavaConstant.getFloat());
        } else if (iJavaType.isDouble()) {
            iJavaConstant2 = iJavaConstantFactory.createDouble(-iJavaConstant.getDouble());
        }
        if (iJavaConstant2 == iJavaConstant) {
            return null;
        }
        return iJavaConstant2;
    }

    public static boolean isNonCompoundFlowBreaker(IJavaStatement iJavaStatement) {
        return iJavaStatement instanceof IJavaReturn || iJavaStatement instanceof IJavaThrow || iJavaStatement instanceof IJavaGoto || iJavaStatement instanceof IJavaBreak || iJavaStatement instanceof IJavaContinue;
    }

    public static void moveStatements(IJavaBlock iJavaBlock, int n2, int n3, IJavaBlock iJavaBlock2, int n4) {
        if (iJavaBlock == iJavaBlock2) {
            throw new IllegalArgumentException();
        }
        int n5 = n4;
        for (int i = n3 - n2; i > 0; --i) {
            IJavaStatement iJavaStatement = iJavaBlock.remove(n2);
            iJavaBlock2.insert(n5, iJavaStatement);
            ++n5;
        }
    }

    public static boolean isSimpleBreak(IJavaStatement iJavaStatement) {
        return iJavaStatement instanceof IJavaBreak && ((IJavaBreak)iJavaStatement).getLabel() == null;
    }

    public static boolean isSimpleContinue(IJavaStatement iJavaStatement) {
        return iJavaStatement instanceof IJavaContinue && ((IJavaContinue)iJavaStatement).getLabel() == null;
    }

    public static boolean isFlowBreaker(IJavaStatement iJavaStatement) {
        return iJavaStatement instanceof IJavaContinue || iJavaStatement instanceof IJavaBreak || iJavaStatement instanceof IJavaGoto || iJavaStatement instanceof IJavaReturn || iJavaStatement instanceof IJavaThrow;
    }

    public static boolean isIfContinue(IJavaStatement iJavaStatement) {
        if (!JUtil.isIf(iJavaStatement)) {
            return false;
        }
        IJavaBlock iJavaBlock = ((IJavaIf)iJavaStatement).getBranchBody(0);
        if (iJavaBlock.size() != 1) {
            return false;
        }
        IJavaStatement iJavaStatement2 = iJavaBlock.get(0);
        return JUtil.isSimpleContinue(iJavaStatement2);
    }
}

