/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.java;

import com.pnfsoftware.jeb.core.units.code.android.ir.DFormattingContext;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDExpression;
import com.pnfsoftware.jeb.core.units.code.java.IJavaTypeFactory;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;

@Ser
public interface IJavaType {
    public static final String JAVA_LANG_OBJECT = "Ljava/lang/Object;";
    public static final String JAVA_LANG_STRING = "Ljava/lang/String;";
    public static final String JAVA_LANG_CLASS = "Ljava/lang/Class;";
    public static final String JAVA_LANG_ENUM = "Ljava/lang/Enum;";
    public static final String JAVA_LANG_EXCEPTION = "Ljava/lang/Exception;";
    public static final String JAVA_LANG_THROWABLE = "Ljava/lang/Throwable;";
    public static final String JAVA_LANG_INVOKE_METHODTYPE = "Ljava/lang/invoke/MethodType;";
    public static final String JAVA_LANG_INVOKE_METHODHANDLE = "Ljava/lang/invoke/MethodHandle;";
    public static final String JAVA_LANG_INVOKE_CALLSITE = "Ljava/lang/invoke/CallSite;";

    public IJavaTypeFactory getFactory();

    public boolean isVoid();

    public boolean isPrimitive();

    public boolean isBoolean();

    public boolean isByte();

    public boolean isChar();

    public boolean isShort();

    public boolean isInt();

    public boolean isLong();

    public boolean isFloat();

    public boolean isDouble();

    public boolean isSingleSlotWildcard();

    public boolean isDoubleSlotWildcard();

    public boolean isSmallIntegerWildcard();

    public boolean isGenericObjectWildcard();

    @Deprecated
    default public boolean isGenericObject() {
        return this.isGenericObjectWildcard();
    }

    public boolean isObjectWildcardExtends();

    public boolean isObjectWildcardSuper();

    public boolean isObject();

    public boolean isClassOrInterface();

    public boolean isArray();

    public int getDimensions();

    public IJavaType getArrayElementType();

    public IJavaType getArrayTypeDimensionBelow();

    public String getName();

    public String getSignature();

    public boolean isJavaLangObject();

    public boolean isJavaLangClass();

    public boolean isJavaLangString();

    @Deprecated
    default public boolean isStringType() {
        return this.isJavaLangString();
    }

    public boolean isFloatingPointType();

    public int getEncodingBitsize();

    public boolean isSingleSlot();

    @Deprecated
    default public boolean isSingleRegister() {
        return this.isSingleSlot();
    }

    public boolean isDoubleSlot();

    @Deprecated
    default public boolean isDoubleRegister() {
        return this.isDoubleSlot();
    }

    public boolean isLegal();

    public boolean isUndefined();

    public boolean isDefined();

    public boolean isDetermined();

    public boolean isWildcard();

    public IJavaType asWildcardSup();

    public IJavaType asWildcardExt();

    public int getSlotCount();

    public boolean isSmallInt();

    public boolean isSpecificInteger();

    public boolean isGenericInteger();

    public boolean compareSimple(IJavaType var1);

    public boolean canSetType(IJavaType var1, boolean var2);

    public IJavaType compareAndGetMostPrecise(IJavaType var1);

    public boolean isValidForRendering();

    public void format(DFormattingContext var1);

    public void formatArray(DFormattingContext var1, IDExpression var2);
}

