/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.java;

import com.pnfsoftware.jeb.core.units.code.android.JvmFieldSig;
import com.pnfsoftware.jeb.core.units.code.android.JvmMethodSig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class DeferredRequestsCollector {
    Set<String> deferredClassDecompilations = new TreeSet<String>();
    Set<String> deferredFieldDecompilations = new TreeSet<String>();
    Set<String> deferredMethodDecompilations = new TreeSet<String>();

    public void clear() {
        this.pullRequestedClassDecompilations();
        this.pullRequestedFieldDecompilations();
        this.pullRequestedMethodDecompilations();
    }

    public boolean isEmpty() {
        return this.deferredClassDecompilations.isEmpty() && this.deferredFieldDecompilations.isEmpty() && this.deferredMethodDecompilations.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void request(String string) {
        if (string == null) {
            return;
        }
        if (string.contains("->")) {
            if (string.contains("(")) {
                JvmMethodSig.parse(string);
                this.deferredMethodDecompilations.add(string);
                return;
            } else {
                if (!string.contains(":")) throw new IllegalArgumentException();
                JvmFieldSig.parse(string);
                this.deferredFieldDecompilations.add(string);
            }
            return;
        } else {
            this.deferredClassDecompilations.add(string);
        }
    }

    public List<String> pullRequestedClassDecompilations() {
        ArrayList<String> arrayList = new ArrayList<String>(this.deferredClassDecompilations);
        this.deferredClassDecompilations.clear();
        return arrayList;
    }

    public List<String> pullRequestedFieldDecompilations() {
        ArrayList<String> arrayList = new ArrayList<String>(this.deferredFieldDecompilations);
        this.deferredFieldDecompilations.clear();
        return arrayList;
    }

    public List<String> pullRequestedMethodDecompilations() {
        ArrayList<String> arrayList = new ArrayList<String>(this.deferredMethodDecompilations);
        this.deferredMethodDecompilations.clear();
        return arrayList;
    }

    public String toString() {
        return this.deferredClassDecompilations + ", " + this.deferredMethodDecompilations + ", " + this.deferredFieldDecompilations;
    }
}

