/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.java;

import com.pnfsoftware.jeb.core.AbstractPlugin;
import com.pnfsoftware.jeb.core.EditablePluginInformation;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.java.DeferredRequestsCollector;
import com.pnfsoftware.jeb.core.units.code.java.IJOptimizer;
import com.pnfsoftware.jeb.core.units.code.java.IJavaClass;
import com.pnfsoftware.jeb.core.units.code.java.IJavaConstantFactory;
import com.pnfsoftware.jeb.core.units.code.java.IJavaDecompilableElement;
import com.pnfsoftware.jeb.core.units.code.java.IJavaGlobalContext;
import com.pnfsoftware.jeb.core.units.code.java.IJavaMethod;
import com.pnfsoftware.jeb.core.units.code.java.IJavaOperatorFactory;
import com.pnfsoftware.jeb.core.units.code.java.IJavaTypeFactory;
import com.pnfsoftware.jeb.core.units.code.java.JOptimizerType;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public abstract class AbstractJOptimizer
extends AbstractPlugin
implements IJOptimizer {
    public static final ILogger logger = GlobalLog.getLogger(AbstractJOptimizer.class);
    public IJavaClass c;
    public IJavaMethod m;
    public IJavaGlobalContext jctx;
    public IJavaTypeFactory tf;
    public IJavaOperatorFactory of;
    public IJavaConstantFactory cf;
    public IDexUnit dex;
    public IDexDecompilerUnit decomp;
    public DeferredRequestsCollector drcollector;
    private EditablePluginInformation info = new EditablePluginInformation();
    private JOptimizerType type;
    private double priority = 0.0;
    private boolean enabled = true;

    public AbstractJOptimizer() {
        this(null);
    }

    public AbstractJOptimizer(JOptimizerType jOptimizerType) {
        this(jOptimizerType, null);
    }

    public AbstractJOptimizer(JOptimizerType jOptimizerType, String string) {
        this.setType(jOptimizerType);
        this.setName(string);
    }

    @Override
    public EditablePluginInformation getPluginInformation() {
        return this.info;
    }

    protected void setName(String string) {
        int n2;
        if (string == null && (n2 = (string = this.getClass().getSimpleName()).indexOf(36)) >= 0) {
            string = string.substring(0, n2);
        }
        this.info.setName(string);
    }

    @Override
    public String getName() {
        return this.info.getName();
    }

    protected void setType(JOptimizerType jOptimizerType) {
        if (jOptimizerType == null) {
            jOptimizerType = JOptimizerType.NORMAL;
        }
        this.type = jOptimizerType;
    }

    @Override
    public JOptimizerType getType() {
        return this.type;
    }

    protected void setPriority(double d) {
        this.priority = d;
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final int perform(IJavaDecompilableElement iJavaDecompilableElement) {
        if (iJavaDecompilableElement instanceof IJavaMethod) {
            this.m = (IJavaMethod)iJavaDecompilableElement;
        } else if (iJavaDecompilableElement instanceof IJavaClass) {
            this.c = (IJavaClass)iJavaDecompilableElement;
        } else {
            throw new IllegalArgumentException("The provided AST element is neither a class nor a method");
        }
        try {
            this.jctx = iJavaDecompilableElement.getGlobalContext();
            if (this.jctx == null) {
                throw new IllegalArgumentException("The provided AST element does not have an attached Java global context");
            }
            this.tf = this.jctx.getTypeFactory();
            this.of = this.jctx.getOperatorFactory();
            this.cf = this.jctx.getConstantFactory();
            this.decomp = this.jctx.getDecompiler();
            this.dex = this.decomp == null ? null : this.decomp.getCodeUnit();
            int n2 = this.perform();
            return n2;
        }
        finally {
            this.m = null;
            this.c = null;
            this.jctx = null;
            this.tf = null;
            this.of = null;
            this.cf = null;
            this.decomp = null;
            this.dex = null;
        }
    }

    public abstract int perform();
}

