/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.debug.impl;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerVariable;
import com.pnfsoftware.jeb.core.units.code.debug.ITypedValue;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.kn;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.NE;
import com.pnfsoftware.jebglobal.Re;
import com.pnfsoftware.jebglobal.Zh;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class DebuggerUtil {
    private static final ILogger logger = GlobalLog.getLogger(DebuggerUtil.class);

    public static byte[] readMemoryStringSafe(IDebuggerUnit iDebuggerUnit, long l2, int n2) {
        return DebuggerUtil.readMemorySafe(iDebuggerUnit, l2, n2);
    }

    public static byte[] readMemorySafe(IDebuggerUnit iDebuggerUnit, long l2, int n2) {
        byte[] byArray = new byte[n2];
        try {
            int n3 = DebuggerUtil.readMemory(iDebuggerUnit, l2, n2, byArray);
            if (n3 < 0) {
                logger.debug("Unable to read memory at %Xh (%d)", l2, n3);
                return null;
            }
            return n3 < n2 ? Arrays.copyOf(byArray, n3) : byArray;
        }
        catch (Exception exception) {
            logger.catchingSilent(exception);
            return null;
        }
    }

    private static int readMemory(IDebuggerUnit iDebuggerUnit, long l2, int n2, byte[] byArray) {
        return iDebuggerUnit.readMemory(l2, n2, byArray, 0);
    }

    public static ICodeUnit getPotentialDebuggee(IDebuggerUnit iDebuggerUnit, long l2) {
        List<? extends ICodeUnit> list = iDebuggerUnit.getPotentialDebuggees();
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        for (ICodeUnit iCodeUnit : iDebuggerUnit.getPotentialDebuggees()) {
            if (!(iCodeUnit instanceof INativeCodeUnit)) continue;
            INativeCodeUnit iNativeCodeUnit = (INativeCodeUnit)iCodeUnit;
            long l3 = iNativeCodeUnit.getVirtualImageBase() + iNativeCodeUnit.getPhysicalImageDelta();
            long l4 = l3 + iNativeCodeUnit.getImageSize();
            if (l3 > l2 || l2 >= l4) continue;
            return iCodeUnit;
        }
        return null;
    }

    public static boolean isNativeCodeDebugger(IDebuggerUnit iDebuggerUnit) {
        for (ICodeUnit iCodeUnit : iDebuggerUnit.getPotentialDebuggees()) {
            if (!(iCodeUnit instanceof INativeCodeUnit)) continue;
            return true;
        }
        return false;
    }

    public static boolean valueEquals(IDebuggerVariable iDebuggerVariable, IDebuggerVariable iDebuggerVariable2) {
        if (iDebuggerVariable == iDebuggerVariable2 || iDebuggerVariable.equals(iDebuggerVariable2)) {
            return true;
        }
        try {
            if (iDebuggerVariable instanceof kn && iDebuggerVariable2 instanceof kn) {
                NE nE = ((kn)iDebuggerVariable).ce();
                NE nE2 = ((kn)iDebuggerVariable2).ce();
                if (nE == null || nE2 == null) {
                    return false;
                }
                return nE.mm == nE2.mm && DebuggerUtil.isCompatibleJDWPTag(nE.ce, nE2.ce);
            }
        }
        catch (Re | IOException exception) {
            return false;
        }
        ITypedValue iTypedValue = iDebuggerVariable.getTypedValue();
        ITypedValue iTypedValue2 = iDebuggerVariable2.getTypedValue();
        if (iTypedValue != null && iTypedValue.getTypeName() != null && iTypedValue2 != null && iTypedValue2.getTypeName() != null && iTypedValue.getTypeName().equals(iTypedValue2.getTypeName())) {
            return iDebuggerVariable.getTypedValue().getValue().equals(iDebuggerVariable2.getTypedValue().getValue());
        }
        return false;
    }

    private static boolean isCompatibleJDWPTag(byte by, byte by2) {
        if (by == by2) {
            return true;
        }
        return by == 76 && Zh.ok(by2) || by2 == 76 && Zh.ok(by);
    }
}

