/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.debug.impl;

import com.pnfsoftware.jeb.core.units.code.debug.DebuggerConnectorClass;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerMachineInformation;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerProcessInformation;
import com.pnfsoftware.jeb.util.format.Strings;

public class DebuggerSetupInformation {
    private DebuggerConnectorClass connectorClass;
    private IDebuggerMachineInformation machine;
    private IDebuggerProcessInformation process;
    private String hostname;
    private int port;
    private boolean suspendThreads;
    private boolean useChidrenDebuggers;
    private Long actualImageBase;

    public static DebuggerSetupInformation create(IDebuggerMachineInformation iDebuggerMachineInformation, IDebuggerProcessInformation iDebuggerProcessInformation) {
        DebuggerSetupInformation debuggerSetupInformation = new DebuggerSetupInformation();
        debuggerSetupInformation.connectorClass = DebuggerConnectorClass.PROCESS;
        debuggerSetupInformation.machine = iDebuggerMachineInformation;
        debuggerSetupInformation.process = iDebuggerProcessInformation;
        return debuggerSetupInformation;
    }

    public static DebuggerSetupInformation create(String string, int n2) {
        DebuggerSetupInformation debuggerSetupInformation = new DebuggerSetupInformation();
        debuggerSetupInformation.connectorClass = DebuggerConnectorClass.PORT;
        debuggerSetupInformation.hostname = string;
        debuggerSetupInformation.port = n2;
        return debuggerSetupInformation;
    }

    private DebuggerSetupInformation() {
    }

    public DebuggerConnectorClass getConnectorClass() {
        return this.connectorClass;
    }

    public IDebuggerMachineInformation getMachine() {
        return this.machine;
    }

    public IDebuggerProcessInformation getProcess() {
        return this.process;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean doSuspendThreads() {
        return this.suspendThreads;
    }

    public void setSuspendThreads(boolean bl) {
        this.suspendThreads = bl;
    }

    public boolean shouldUseChildrenDebuggers() {
        return this.useChidrenDebuggers;
    }

    public void setUseChildrenDebuggers(boolean bl) {
        this.useChidrenDebuggers = bl;
    }

    public Long getActualImageBase() {
        return this.actualImageBase;
    }

    public void setActualImageBase(Long l2) {
        this.actualImageBase = l2;
    }

    public String toString() {
        Object object = Strings.ff("%s=", new Object[]{this.connectorClass});
        switch (this.connectorClass) {
            case PROCESS: {
                object = (String)object + Strings.ff("%s:%s", this.machine, this.process);
                break;
            }
            case PORT: {
                object = (String)object + Strings.ff("%s:%s", this.hostname, this.port);
                break;
            }
            default: {
                object = (String)object + "?";
            }
        }
        object = (String)object + Strings.ff("(susp=%b,usechld=%b)", this.suspendThreads, this.useChidrenDebuggers);
        return object;
    }
}

