/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.debug.impl;

import com.pnfsoftware.jeb.core.units.code.debug.ITypedValue;
import com.pnfsoftware.jeb.core.units.code.debug.impl.AbstractValueNumber;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueBoolean;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueCharacter;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueRaw;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueString;
import com.pnfsoftware.jeb.util.format.Formatter;

public abstract class AbstractValuePrimitive
implements ITypedValue {
    @Override
    public String format() {
        return this.toString();
    }

    public static ITypedValue parseValue(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        switch (string) {
            case "boolean": {
                return new ValueBoolean(Boolean.parseBoolean(string2));
            }
            case "char": {
                if (string2.length() == 3 && string2.charAt(0) == '\'' && string2.charAt(2) == '\'') {
                    return new ValueCharacter(string2.charAt(1));
                }
                if (string2.length() != 1) {
                    return null;
                }
                return new ValueCharacter(string2.charAt(0));
            }
            case "raw": {
                byte[] byArray = Formatter.hexStringToByteArray(string2);
                if (byArray == null) {
                    return null;
                }
                return new ValueRaw(byArray);
            }
            case "string": {
                return new ValueString(string2);
            }
            case "byte": 
            case "short": 
            case "int": 
            case "long": 
            case "double": 
            case "float": {
                try {
                    return AbstractValueNumber.parseNumber(string, string2);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        }
        return null;
    }
}

