/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.debug.impl;

import com.pnfsoftware.jeb.core.units.code.debug.impl.AbstractValuePrimitive;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueByte;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueDouble;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueFloat;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueInteger;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueLong;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueShort;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;

public abstract class AbstractValueNumber
extends AbstractValuePrimitive {
    @Override
    public abstract Number getValue();

    public String toString() {
        Number number = this.getValue();
        long l2 = number.longValue();
        if (l2 >= -9L && l2 <= 9L) {
            return Long.toString(l2);
        }
        return Strings.ff("%d (0x%X)", l2, l2);
    }

    public static AbstractValueNumber parseNumber(String string, String string2) {
        switch (string) {
            case "byte": {
                return new ValueByte((byte)Conversion.stringToInt(string2));
            }
            case "short": {
                return new ValueShort((short)Conversion.stringToInt(string2));
            }
            case "int": {
                return new ValueInteger(Conversion.stringToInt(string2));
            }
            case "long": {
                return new ValueLong(Conversion.stringToLong(string2));
            }
            case "float": {
                return new ValueFloat(Float.parseFloat(string2));
            }
            case "double": {
                return new ValueDouble(Double.parseDouble(string2));
            }
        }
        return null;
    }
}

