/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.type.TypelibDefinitionException;
import com.pnfsoftware.jeb.corei.parsers.asm.type.tlgen.TLGen;
import com.pnfsoftware.jeb.corei.parsers.asm.type.tlgen.ri;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.bbd;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class TypelibGen {
    private static final ILogger logger;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            String string = "JEB Type Library Generator (c) Nicolas Falliere, PNF Software\nProvide a configuration file as argument\n";
            logger.warn(string, new Object[0]);
            return;
        }
        File file = new File(stringArray[0]);
        logger.info("Configuration: %s", file);
        try {
            for (ri ri2 : ri.ce(file)) {
                bbd bbd2 = bbd.ce(ri2.ok.getPrimaryProcessorType(), ri2.ok.getPrimarySubsystemType(), ri2.ok.getCompilerType());
                TLGen tLGen = new TLGen(bbd2, ri2.mm, ri2.fz);
                tLGen.ce(ri2.ok, true, ri2.Rs);
                logger.info("- Generated: %s", ri2.Rs);
            }
            logger.info("Copy the generated files to your JEB's typelibs/ folder", new Object[0]);
        }
        catch (TypelibDefinitionException typelibDefinitionException) {
            logger.error("ERROR! %s", typelibDefinitionException.getMessage());
            System.exit(-1);
        }
        catch (Exception exception) {
            logger.catching(exception);
        }
    }

    static {
        GlobalLog.addDestinationStream(System.out);
        try {
            String string = System.getProperty("java.io.tmpdir");
            File file = new File(string, "jeb-typelib-generator-output.log");
            GlobalLog.addDestinationStream(new PrintStream(file));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        logger = GlobalLog.getLogger(TypelibGen.class, 30);
    }
}

