/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.IAliasType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IArrayType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.IEnumerationType;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrimitiveType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IReferenceType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureTypeField;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeLibrary;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.PrimitiveCategory;
import com.pnfsoftware.jeb.core.units.code.asm.type.PrototypeAttribute;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLayoutInfo;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryService;
import com.pnfsoftware.jeb.core.units.codeobject.CompilerType;
import com.pnfsoftware.jeb.util.base.ISimpleFilter;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jebglobal.bax;
import com.pnfsoftware.jebglobal.bbc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class TypeUtil {
    public static final String CPP_PACKAGE_SEPARATOR = "::";
    public static final Pattern CPP_TEMPLATE_REGEXP = Pattern.compile(".*<.*>.*");
    public static final Set<String> keywords = new HashSet<String>(Arrays.asList("auto", "register"));
    public static final int TYPESOURCE_INUSE = 1;
    public static final int TYPESOURCE_TYPELIBS = 2;
    public static final int TYPESOURCE_ALL = 3;
    private static final WeakIdentityHashMap<IPrimitiveType, INativeType> shortermap = new WeakIdentityHashMap();

    public static boolean isKeyword(String string) {
        return keywords.contains(string);
    }

    public static boolean isReservedLiteral(String string) {
        return TypeUtil.isKeyword(string) || string.equals("null") || string.equals("true") || string.equals("false");
    }

    private static boolean isValidName(String string, boolean bl) {
        if (string.length() == 0 || TypeUtil.isReservedLiteral(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isJavaIdentifierPart(c2) || bl && c2 == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPackageName(String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean isValidTypeName(String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean containsCppSeparator(String string) {
        return string != null && string.contains(CPP_PACKAGE_SEPARATOR);
    }

    public static boolean isValidFullyQualifiedName(String string, List<String> list, String[] stringArray) {
        String[] stringArray2 = string.split(CPP_PACKAGE_SEPARATOR, -1);
        if (stringArray2.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray2.length - 1; ++i) {
            if (TypeUtil.isValidPackageName(stringArray2[i])) continue;
            return false;
        }
        if (!TypeUtil.isValidTypeName(stringArray2[stringArray2.length - 1])) {
            return false;
        }
        if (list != null) {
            list.clear();
            for (String string2 : stringArray2) {
                list.add(string2);
            }
        }
        if (stringArray != null) {
            stringArray[0] = list.get(list.size() - 1);
        }
        return true;
    }

    public static List<String> splitCppName(String string) {
        return TypeUtil.splitCpp(string, ':', 2);
    }

    public static List<String> splitCppParameters(String string) {
        if (string.charAt(0) == '(' && string.charAt(string.length() - 1) == ')') {
            return TypeUtil.splitCpp(string.substring(1, string.length() - 1), ',', 1);
        }
        return TypeUtil.splitCpp(string, ',', 1);
    }

    private static List<String> splitCpp(String string, char c2, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < string.length()) {
            char c3 = string.charAt(n5);
            if (c3 == c2 && n3 == 0 && n4 == 0) {
                boolean bl = true;
                if (n2 > 1) {
                    for (int i = 1; i < n2; ++i) {
                        if (n5 + i < string.length() && string.charAt(n5 + i) == c2) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    arrayList.add(stringBuilder.toString().trim());
                    stringBuilder = new StringBuilder();
                    n5 += n2;
                    continue;
                }
            }
            switch (c3) {
                case '<': {
                    ++n3;
                    break;
                }
                case '>': {
                    --n3;
                    break;
                }
                case '(': {
                    ++n4;
                    break;
                }
                case ')': {
                    --n4;
                }
            }
            stringBuilder.append(c3);
            ++n5;
        }
        if (stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString().trim());
        }
        return arrayList;
    }

    public static String processSignature(String string, int[] nArray) {
        int n2;
        int n3;
        int n4 = -1;
        if (string.endsWith("]")) {
            for (n3 = string.length() - 2; n3 >= 0 && string.charAt(n3) != '['; --n3) {
            }
            if (n3 >= 0) {
                try {
                    n4 = Integer.parseInt(string.substring(n3 + 1, string.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (n4 <= 0) {
                return null;
            }
            string = string.substring(0, n3);
        }
        n3 = 0;
        for (n2 = string.length() - 1; n2 >= 0 && string.charAt(n2) == '*'; --n2) {
            ++n3;
        }
        string = string.substring(0, n2 + 1).trim();
        if (nArray != null) {
            nArray[0] = n3;
            nArray[1] = n4;
        }
        return string;
    }

    public static String normalizeSignature(boolean bl, String string, List<String> list, int[] nArray) {
        String string2;
        if (!bl) {
            string = TypeUtil.preNormalizeSignature(string);
        }
        if ((string2 = TypeUtil.processSignature(string, nArray)) == null) {
            return null;
        }
        if (!TypeUtil.isValidFullyQualifiedName(string2, list, null)) {
            return null;
        }
        return string;
    }

    public static String preNormalizeSignature(String string) {
        string = string.trim();
        if ((string = string.replace(".", CPP_PACKAGE_SEPARATOR).replace("/", CPP_PACKAGE_SEPARATOR)).startsWith(CPP_PACKAGE_SEPARATOR)) {
            string = string.substring(CPP_PACKAGE_SEPARATOR.length());
        }
        string = string.replaceAll("\\s+", " ");
        return string;
    }

    public static String buildFullyQualifiedTypeNameFromElements(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (String string : list) {
            if (n2 >= 1) {
                stringBuilder.append(CPP_PACKAGE_SEPARATOR);
            }
            stringBuilder.append(string);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static INativeType buildQuick(ITypeManager iTypeManager, String string) {
        if (string.indexOf(40) >= 0 && string.endsWith("")) {
            return TypeUtil.buildQuickPrototype(iTypeManager, string);
        }
        return TypeUtil.buildQuickType(iTypeManager, string);
    }

    public static INativeType buildQuickType(ITypeManager iTypeManager, String string) {
        int[] nArray;
        String string2 = TypeUtil.processSignature(string = TypeUtil.preNormalizeSignature(string), nArray = new int[2]);
        if (string2 == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!TypeUtil.isValidFullyQualifiedName(string2, arrayList, null)) {
            return null;
        }
        INativeType iNativeType = iTypeManager.getType(string2);
        if (iNativeType == null) {
            return null;
        }
        int n2 = nArray[0];
        INativeType iNativeType2 = n2 == 0 ? iNativeType : iTypeManager.createReference(iNativeType, n2);
        if (nArray[1] >= 0) {
            iNativeType2 = iTypeManager.createArray(iNativeType2, nArray[1]);
        }
        return iNativeType2;
    }

    public static INativeType buildArrayType(ITypeManager iTypeManager, String string, int ... nArray) {
        INativeType iNativeType = iTypeManager.getType(string);
        if (iNativeType == null) {
            return null;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n2 = nArray[i];
            if (n2 <= 0) {
                return null;
            }
            iNativeType = iTypeManager.createArray(iNativeType, n2);
        }
        return iNativeType;
    }

    public static boolean isPrimitive(INativeType iNativeType) {
        return iNativeType instanceof IPrimitiveType;
    }

    public static boolean isReference(INativeType iNativeType) {
        return iNativeType instanceof IReferenceType;
    }

    public static boolean isPrototype(INativeType iNativeType) {
        return iNativeType instanceof IPrototypeItem;
    }

    public static boolean isSimple(INativeType iNativeType) {
        return TypeUtil.isPrimitive(iNativeType) || TypeUtil.isReference(iNativeType) || TypeUtil.isPrototype(iNativeType);
    }

    public static boolean isAlias(INativeType iNativeType) {
        return iNativeType instanceof IAliasType;
    }

    public static INativeType getNonAlias(INativeType iNativeType) {
        if (iNativeType instanceof IAliasType) {
            INativeType iNativeType2 = ((IAliasType)iNativeType).getAliasedType();
            return TypeUtil.getNonAlias(iNativeType2);
        }
        return iNativeType;
    }

    public static <T extends INativeType> T getNonAlias(INativeType iNativeType, Class<T> clazz) {
        if (iNativeType instanceof IAliasType) {
            INativeType iNativeType2 = ((IAliasType)iNativeType).getAliasedType();
            return TypeUtil.getNonAlias(iNativeType2, clazz);
        }
        return (T)iNativeType;
    }

    public static boolean checkAliasedType(INativeType iNativeType, INativeType iNativeType2) {
        if (iNativeType == iNativeType2) {
            return true;
        }
        if (iNativeType instanceof IAliasType) {
            INativeType iNativeType3 = ((IAliasType)iNativeType).getAliasedType();
            return TypeUtil.checkAliasedType(iNativeType3, iNativeType2);
        }
        return false;
    }

    public static boolean isBitfieldCompatible(INativeType iNativeType) {
        return TypeUtil.getEquivalentBitfieldTypeSize(iNativeType) != 0;
    }

    public static boolean areBitfielTypesEquivalent(INativeType iNativeType, INativeType iNativeType2) {
        int n2 = TypeUtil.getEquivalentBitfieldTypeSize(iNativeType);
        return n2 != 0 && n2 == TypeUtil.getEquivalentBitfieldTypeSize(iNativeType2);
    }

    private static int getEquivalentBitfieldTypeSize(INativeType iNativeType) {
        if ((iNativeType = TypeUtil.getNonAlias(iNativeType)) instanceof IEnumerationType) {
            iNativeType = iNativeType.getTypeManager().getType("int");
        }
        if (iNativeType instanceof IPrimitiveType && (((IPrimitiveType)iNativeType).getCategory() == PrimitiveCategory.INTEGER || ((IPrimitiveType)iNativeType).getCategory() == PrimitiveCategory.UNSIGNED)) {
            return iNativeType.getSize();
        }
        return 0;
    }

    public static boolean isPointer(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IReferenceType;
    }

    public static boolean isPointerToPointer(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        if (iNativeType2 instanceof IReferenceType) {
            INativeType iNativeType3 = ((IReferenceType)iNativeType2).getPointedType();
            return iNativeType3 instanceof IReferenceType;
        }
        return false;
    }

    public static boolean isCompositeType(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IArrayType || iNativeType2 instanceof IStructureType;
    }

    public static boolean isFunctionPointer(INativeType iNativeType) {
        return TypeUtil.isFunctionPointer(iNativeType, null);
    }

    public static boolean isFunctionPointer(INativeType iNativeType, IPrototypeItem[] iPrototypeItemArray) {
        INativeType iNativeType2;
        INativeType iNativeType3 = TypeUtil.getNonAlias(iNativeType);
        if (iNativeType3 instanceof IReferenceType && (iNativeType2 = ((IReferenceType)iNativeType3).getPointedType()) instanceof IPrototypeItem) {
            if (iPrototypeItemArray != null) {
                iPrototypeItemArray[0] = (IPrototypeItem)iNativeType2;
            }
            return true;
        }
        return false;
    }

    public static boolean isVoid(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isVoid((IPrimitiveType)iNativeType2);
    }

    public static boolean isVoidPointer(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        if (iNativeType2 instanceof IReferenceType) {
            return TypeUtil.isVoid(((IReferenceType)iNativeType2).getPointedType());
        }
        return false;
    }

    public static boolean isCharacter(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isCharacter((IPrimitiveType)iNativeType2);
    }

    public static boolean isInteger(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isInteger((IPrimitiveType)iNativeType2);
    }

    public static boolean isSignedInteger(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isSignedInteger((IPrimitiveType)iNativeType2);
    }

    public static boolean isUnsignedInteger(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isUnsignedInteger((IPrimitiveType)iNativeType2);
    }

    public static boolean isFloat(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isFloat((IPrimitiveType)iNativeType2);
    }

    public static List<INativeType> collectTypes(IPrototypeItem iPrototypeItem) {
        ArrayList<INativeType> arrayList = Lists.createArrayList();
        INativeType iNativeType = iPrototypeItem.getReturnType();
        Lists.addNonNulls(arrayList, iNativeType);
        for (INativeType iNativeType2 : iPrototypeItem.getParameterTypes()) {
            Lists.addNonNulls(arrayList, iNativeType2);
        }
        return arrayList;
    }

    public static List<INativeType> findType(Collection<? extends INativeType> collection, String string, boolean bl) {
        ArrayList<INativeType> arrayList = new ArrayList<INativeType>();
        for (INativeType iNativeType : collection) {
            String string2 = iNativeType.getSignature(true);
            String string3 = iNativeType.getSignature(false);
            if (!string2.contains(string) && !string3.contains(string)) continue;
            arrayList.add(iNativeType);
            if (!bl) continue;
            break;
        }
        return arrayList;
    }

    public static boolean structureInStructure(IStructureType iStructureType, INativeType iNativeType) {
        if (iNativeType instanceof IArrayType) {
            return TypeUtil.structureInStructure(iStructureType, ((IArrayType)iNativeType).getElementType());
        }
        if (iNativeType instanceof IAliasType) {
            return TypeUtil.structureInStructure(iStructureType, ((IAliasType)iNativeType).getAliasedType());
        }
        if (iNativeType instanceof IStructureType) {
            if (iStructureType == iNativeType) {
                return true;
            }
            for (IStructureTypeField iStructureTypeField : ((IStructureType)iNativeType).getFields()) {
                if (!TypeUtil.structureInStructure(iStructureType, iStructureTypeField.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public static INativeType getFirstSimpleType(INativeType iNativeType) {
        while (iNativeType != null) {
            if ((iNativeType = TypeUtil.getNonAlias(iNativeType)) instanceof IArrayType) {
                iNativeType = ((IArrayType)iNativeType).getElementType();
                continue;
            }
            if (iNativeType instanceof IStructureType) {
                if (((IStructureType)iNativeType).getFields().size() == 0) break;
                iNativeType = ((IStructureType)iNativeType).getField(0).getType();
                continue;
            }
            if (!(iNativeType instanceof IPrimitiveType) && !(iNativeType instanceof IEnumerationType) && !(iNativeType instanceof IReferenceType)) break;
            if (iNativeType instanceof IPrimitiveType) {
                if (((IPrimitiveType)iNativeType).getCategory() == PrimitiveCategory.COMPLEX) {
                    int n2 = iNativeType.getSize();
                    iNativeType = iNativeType.getTypeManager().getPrimitives().getExactFloatBySize(n2 / 2);
                }
                return iNativeType;
            }
            return iNativeType;
        }
        return null;
    }

    public static INativeType getBaseType(INativeType iNativeType) {
        INativeType iNativeType2 = null;
        if (iNativeType instanceof IArrayType) {
            iNativeType2 = ((IArrayType)iNativeType).getElementType();
        } else if (iNativeType instanceof IReferenceType) {
            iNativeType2 = ((IReferenceType)iNativeType).getMainType();
        } else if (iNativeType instanceof IPrimitiveType || iNativeType instanceof IPrototypeItem || iNativeType instanceof bbc) {
            return iNativeType;
        }
        if (iNativeType2 == iNativeType) {
            return null;
        }
        return TypeUtil.getBaseType(iNativeType2);
    }

    public static IStructureTypeField getStructureField(INativeType iNativeType, String string) {
        if (!((iNativeType = TypeUtil.getNonAlias(iNativeType)) instanceof IStructureType)) {
            return null;
        }
        return ((IStructureType)iNativeType).getFieldByName(string);
    }

    public static IStructureTypeField getStructureField(INativeType iNativeType, int n2) {
        if (!((iNativeType = TypeUtil.getNonAlias(iNativeType)) instanceof IStructureType)) {
            return null;
        }
        return ((IStructureType)iNativeType).getFieldAt(n2);
    }

    public static IPrototypeItem buildQuickPrototype(ITypeManager iTypeManager, String string) {
        String string2;
        INativeType iNativeType;
        String[] stringArray;
        String string3 = string.trim();
        if (string3.endsWith(";")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (string3.isEmpty() || string3.charAt(string3.length() - 1) != ')') {
            return null;
        }
        int n2 = string3.indexOf(40);
        if (n2 < 0) {
            return null;
        }
        String string4 = string3.substring(0, n2);
        String string5 = string3.substring(n2 + 1, string3.length() - 1).trim();
        int n3 = 0;
        ICallingConvention iCallingConvention = null;
        if (string4.startsWith("<")) {
            n3 = string4.indexOf(62);
            if (n3 < 0) {
                return null;
            }
            stringArray = string4.substring(1, n3);
            iCallingConvention = iTypeManager.getCallingConventionManager().getConvention((String)stringArray);
            ++n3;
        }
        if ((iNativeType = TypeUtil.buildQuickType(iTypeManager, string2 = Strings.join(" ", Arrays.asList(stringArray = string4.substring(n3).trim().split("\\s+", -1))))) == null) {
            return null;
        }
        ArrayList<INativeType> arrayList = new ArrayList<INativeType>();
        boolean bl = false;
        if (!string5.isEmpty()) {
            String[] stringArray2;
            for (String string6 : stringArray2 = string5.split(",", -1)) {
                if (bl) {
                    return null;
                }
                stringArray = string6.trim().split("\\s+");
                String string7 = Strings.join(" ", stringArray, 0, stringArray.length);
                if (string7.equals("...")) {
                    bl = true;
                    continue;
                }
                INativeType iNativeType2 = TypeUtil.buildQuickType(iTypeManager, string7);
                if (iNativeType2 == null) {
                    return null;
                }
                arrayList.add(iNativeType2);
            }
        }
        return iTypeManager.createPrototype(iCallingConvention, iNativeType, arrayList, bl ? Arrays.asList(PrototypeAttribute.VarArg) : null);
    }

    public static List<INativeType> retrieveAvailableTypes(INativeCodeUnit<?> iNativeCodeUnit, int n2) {
        return TypeUtil.retrieveAvailableTypes(iNativeCodeUnit, n2, null);
    }

    public static List<INativeType> retrieveAvailableTypes(INativeCodeUnit<?> iNativeCodeUnit, int n2, ISimpleFilter<INativeType> iSimpleFilter) {
        Object object;
        ArrayList<INativeType> arrayList = new ArrayList<INativeType>();
        if ((n2 & 1) != 0) {
            object = iNativeCodeUnit.getTypeManager().getTypes(iSimpleFilter).iterator();
            while (object.hasNext()) {
                INativeType iNativeType = (INativeType)object.next();
                arrayList.add(iNativeType);
            }
        }
        if ((n2 & 2) != 0 && (object = iNativeCodeUnit.getTypeLibraryService()) != null) {
            for (ITypeLibrary iTypeLibrary : ((TypeLibraryService)object).getLoadedTypeLibraries()) {
                for (INativeType iNativeType : iTypeLibrary.getTypes(iSimpleFilter)) {
                    arrayList.add(iNativeType);
                }
            }
        }
        return arrayList;
    }

    public static String generateRoutineSignature(String string, IPrototypeItem iPrototypeItem) {
        return ((bax)iPrototypeItem).ce(true, string);
    }

    public static boolean same(INativeType iNativeType, INativeType iNativeType2) {
        if (iNativeType == null) {
            return iNativeType2 == null;
        }
        if (iNativeType2 == null) {
            return false;
        }
        return TypeUtil.getNonAlias(iNativeType).equals(TypeUtil.getNonAlias(iNativeType2));
    }

    public static TypeLayoutInfo getLayoutInfo(INativeType iNativeType) {
        int n2 = iNativeType.getTypeManager().getSlotSize();
        int n3 = (iNativeType.getSize() + n2 - 1) / n2;
        if (TypeUtil.isPointer(iNativeType)) {
            return TypeLayoutInfo.p(n3);
        }
        if (TypeUtil.isInteger(iNativeType)) {
            return TypeLayoutInfo.i(n3);
        }
        if (TypeUtil.isFloat(iNativeType)) {
            return TypeLayoutInfo.f(n3);
        }
        return TypeLayoutInfo.c(n3);
    }

    public static INativeType findShorterForm(INativeType iNativeType) {
        if (iNativeType == null) {
            return null;
        }
        if (!(iNativeType instanceof IPrimitiveType)) {
            return iNativeType;
        }
        IPrimitiveType iPrimitiveType = (IPrimitiveType)iNativeType;
        INativeType iNativeType2 = shortermap.get(iPrimitiveType);
        if (iNativeType2 != null) {
            return iNativeType2;
        }
        ITypeManager iTypeManager = iPrimitiveType.getTypeManager();
        String string = null;
        if (iTypeManager.getCompilerType() == CompilerType.MSVC) {
            if (iPrimitiveType.getCategory() == PrimitiveCategory.INTEGER) {
                switch (iPrimitiveType.getSize()) {
                    case 1: {
                        string = "INT8";
                        break;
                    }
                    case 2: {
                        string = "INT16";
                        break;
                    }
                    case 4: {
                        string = "INT32";
                        break;
                    }
                    case 8: {
                        string = "INT64";
                        break;
                    }
                }
            } else if (iPrimitiveType.getCategory() == PrimitiveCategory.UNSIGNED) {
                switch (iPrimitiveType.getSize()) {
                    case 1: {
                        string = "UINT8";
                        break;
                    }
                    case 2: {
                        string = "UINT16";
                        break;
                    }
                    case 4: {
                        string = "UINT32";
                        break;
                    }
                    case 8: {
                        string = "UINT64";
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (iTypeManager.getCompilerType() == CompilerType.GCC) {
            if (iPrimitiveType.getCategory() == PrimitiveCategory.INTEGER) {
                switch (iPrimitiveType.getSize()) {
                    case 1: {
                        string = "int8_t";
                        break;
                    }
                    case 2: {
                        string = "int16_t";
                        break;
                    }
                    case 4: {
                        string = "int32_t";
                        break;
                    }
                    case 8: {
                        string = "int64_t";
                        break;
                    }
                }
            } else if (iPrimitiveType.getCategory() == PrimitiveCategory.UNSIGNED) {
                switch (iPrimitiveType.getSize()) {
                    case 1: {
                        string = "uint8_t";
                        break;
                    }
                    case 2: {
                        string = "uint16_t";
                        break;
                    }
                    case 4: {
                        string = "uint32_t";
                        break;
                    }
                    case 8: {
                        string = "uint64_t";
                    }
                }
            }
        }
        if (string != null && string.length() < iPrimitiveType.getName().length()) {
            iNativeType2 = iTypeManager.getType(string);
        }
        if (iNativeType2 == null) {
            iNativeType2 = iPrimitiveType;
        }
        shortermap.put(iPrimitiveType, iNativeType2);
        return iNativeType2;
    }
}

