/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionName;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeStringParseException;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.bai;
import com.pnfsoftware.jebglobal.bax;
import com.pnfsoftware.jebglobal.bbd;
import com.pnfsoftware.jebglobal.bbf;
import com.pnfsoftware.jebglobal.bbm;
import com.pnfsoftware.jebglobal.bbo;
import com.pnfsoftware.jebglobal.bbs;
import com.pnfsoftware.jebglobal.bbu;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class TypeStringParser {
    private static final ILogger logger = GlobalLog.getLogger(TypeStringParser.class);
    private static final TypeStringParser verifier = new TypeStringParser();
    public static final int TYPE = 0;
    public static final int PROTO = 1;
    public static final int SIG = 2;
    public static final int DECL = 3;
    private bbd typeman;

    private TypeStringParser() {
    }

    public TypeStringParser(ITypeManager iTypeManager) {
        if (iTypeManager == null) {
            throw new IllegalArgumentException("Provide a type manager");
        }
        this.typeman = (bbd)iTypeManager;
    }

    public INativeType parseType(String string) throws TypeStringParseException {
        bai bai2;
        try {
            string = TypeStringParser.massageForType(string);
            bai2 = this.parseForType(string);
        }
        catch (Exception exception) {
            throw new TypeStringParseException(exception);
        }
        if (bai2 == null) {
            throw new TypeStringParseException();
        }
        return bai2;
    }

    public Decl parseDeclaration(String string) throws TypeStringParseException {
        return this.parseDeclaration(string, false);
    }

    public Decl parseDeclaration(String string, boolean bl) throws TypeStringParseException {
        bbm bbm2;
        try {
            string = TypeStringParser.massageForDeclaration(string);
            bbm2 = this.parseSingleDeclaration(string);
        }
        catch (Exception exception) {
            throw new TypeStringParseException(exception);
        }
        if (bbm2 == null) {
            throw new TypeStringParseException();
        }
        return new Decl(bbm2.ce(), bbm2.mm());
    }

    @Deprecated
    public IPrototypeItem parsePrototype(String string) throws TypeStringParseException {
        IPrototypeItem iPrototypeItem = null;
        String[] stringArray = new String[1];
        try {
            string = TypeStringParser.massageProtoString(string, stringArray);
            if (string != null) {
                iPrototypeItem = (IPrototypeItem)((Object)this.parseForType(string));
            }
        }
        catch (Exception exception) {
            throw new TypeStringParseException("Error parsing prototype: " + string, exception);
        }
        if (iPrototypeItem == null) {
            throw new TypeStringParseException("Error parsing prototype: " + string);
        }
        String string2 = stringArray[0];
        if (!Strings.isBlank(string2)) {
            CallingConventionName callingConventionName = CallingConventionName.find(string2);
            if (callingConventionName == null) {
                throw new TypeStringParseException("Unknown calling convention: " + string2);
            }
            string2 = callingConventionName.toString();
            ICallingConvention iCallingConvention = this.typeman.Rs().getConvention(string2);
            if (iCallingConvention == null) {
                throw new TypeStringParseException("Unsupported calling convention: " + string2);
            }
            ((bax)iPrototypeItem).ce(iCallingConvention);
        }
        return iPrototypeItem;
    }

    private static String massageProtoString(String string, String[] stringArray) {
        String string2 = Strings.trimWhitespaces(string);
        if (string2.endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.isEmpty() || string2.charAt(string2.length() - 1) != ')') {
            return null;
        }
        int n2 = string2.indexOf(40);
        if (n2 < 0) {
            return null;
        }
        int n3 = string2.lastIndexOf(41);
        if (n3 < 0) {
            return null;
        }
        String string3 = string2.substring(n2 + 1, n3).trim();
        String string4 = string2.substring(0, n2);
        String string5 = "";
        int n4 = 0;
        if (string4.startsWith("<")) {
            n4 = string4.indexOf(62);
            if (n4 < 0) {
                return null;
            }
            string5 = string4.substring(1, n4);
            if (stringArray != null) {
                stringArray[0] = string5;
                string5 = "";
            }
            ++n4;
        }
        String string6 = string4.substring(n4);
        return string6 + " " + string5 + " f(" + string3 + ");";
    }

    public IPrototypeItem parseSignature(String string) throws TypeStringParseException {
        return this.parseSignature(string, false);
    }

    public IPrototypeItem parseSignature(String string, boolean bl) throws TypeStringParseException {
        bbm bbm2;
        string = TypeStringParser.massageSingleDeclaration(string, bl);
        try {
            bbm2 = this.parseSingleDeclaration(string);
        }
        catch (Exception exception) {
            throw new TypeStringParseException("Error parsing signature: " + string, exception);
        }
        if (bbm2 == null) {
            throw new TypeStringParseException("Error parsing signature: " + string);
        }
        if (!(bbm2.ce() instanceof bax)) {
            throw new TypeStringParseException();
        }
        return (bax)bbm2.ce();
    }

    private bai parseForType(String string) {
        return this.parseSingleDeclaration(string).ce();
    }

    private bbm parseSingleDeclaration(String string) {
        return Lists.get(this.parseInternal(string, false), 0);
    }

    public List<INativeType> parseTypesRaw(String string) throws TypeStringParseException {
        try {
            return this.parseInternal(string, true).stream().map(bbm2 -> bbm2.ce()).collect(Collectors.toList());
        }
        catch (Exception exception) {
            throw new TypeStringParseException("Error parsing types", exception);
        }
    }

    private List<bbm> parseInternal(String string, boolean bl) {
        bbs bbs2 = new bbs((CharStream)CharStreams.fromString((String)string));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)bbs2);
        bbu bbu2 = new bbu((TokenStream)commonTokenStream);
        bbu2.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        bbu.jC jC2 = bbu2.Ap();
        if (this.typeman == null) {
            return null;
        }
        boolean bl2 = bl;
        bbf bbf2 = new bbf(1, bl2);
        bbo bbo2 = new bbo(jC2, bbf2, this.typeman);
        return bbo2.Rs();
    }

    public static void verify(int n2, String string, boolean bl) throws TypeStringParseException {
        Object object = Strings.trimWhitespaces(string);
        if (bl && (object = TypeStringParser.removeCppTemplates((String)object)) == null) {
            throw new TypeStringParseException("Illegal template in signature: " + (String)object);
        }
        if (n2 == 0) {
            object = TypeStringParser.massageForType((String)object);
        }
        if (!((String)object).endsWith(";")) {
            object = (String)object + ";";
        }
        try {
            verifier.parseSingleDeclaration((String)object);
        }
        catch (Exception exception) {
            throw new TypeStringParseException("Error parsing signature: " + (String)object, exception);
        }
    }

    public static void verifyType(String string, boolean bl) throws TypeStringParseException {
        TypeStringParser.verify(0, string, bl);
    }

    public static void verifyDeclaration(String string, boolean bl) throws TypeStringParseException {
        TypeStringParser.verify(3, string, bl);
    }

    public static void verifySignature(String string, boolean bl) throws TypeStringParseException {
        TypeStringParser.verify(2, string, bl);
    }

    public static String massageForType(String object) {
        if (((String)(object = Strings.trimWhitespaces((String)object))).endsWith(";")) {
            return object;
        }
        if (((String)object).endsWith(")")) {
            object = (String)object + ";";
            return object;
        }
        if (Strings.contains((String)object, "(", ")", ",")) {
            return object;
        }
        int n2 = ((String)object).indexOf(91);
        if (n2 >= 0) {
            object = ((String)object).substring(0, n2) + " _" + ((String)object).substring(n2) + ";";
            return object;
        }
        object = (String)object + " _;";
        return object;
    }

    public static String massageForDeclaration(String object) {
        if (!((String)(object = Strings.trimWhitespaces((String)object))).endsWith(";")) {
            object = (String)object + ";";
        }
        return object;
    }

    public static String massageSingleDeclaration(String string, boolean bl) throws TypeStringParseException {
        Object object = Strings.trimWhitespaces(string);
        if (!((String)object).endsWith(";")) {
            object = (String)object + ";";
        }
        if (bl && (object = TypeStringParser.removeCppTemplates((String)object)) == null) {
            throw new TypeStringParseException("Illegal template in signature: " + (String)object);
        }
        return object;
    }

    public static String removeCppTemplates(String object) {
        int n2;
        int n3 = 0;
        ArrayList<Couple<Integer, Integer>> arrayList = new ArrayList<Couple<Integer, Integer>>();
        int n4 = 0;
        for (n2 = 0; n2 < ((String)object).length(); ++n2) {
            char c2 = ((String)object).charAt(n2);
            if (c2 == '<') {
                if (n3 == 0) {
                    n4 = n2;
                }
                ++n3;
                continue;
            }
            if (c2 != '>') continue;
            if (--n3 < 0) {
                return null;
            }
            if (n3 != 0) continue;
            arrayList.add(new Couple<Integer, Integer>(n4, n2 + 1));
        }
        if (n3 != 0) {
            return null;
        }
        for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
            Couple couple = (Couple)arrayList.get(n2);
            object = ((String)object).substring(0, (Integer)couple.getFirst()) + ((String)object).substring((Integer)couple.getSecond(), ((String)object).length());
        }
        return object;
    }

    public static class Decl {
        INativeType type;
        String name;

        Decl(INativeType iNativeType, String string) {
            if (iNativeType == null || string == null) {
                throw new IllegalArgumentException();
            }
            this.type = iNativeType;
            this.name = string;
        }

        public INativeType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean isGenericName() {
            return this.name.equals("__ANONYMOUS__");
        }

        public String toString() {
            return this.type.getSignature() + " " + this.getName() + ";";
        }
    }
}

