/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeLibrary;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryEntry;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryMetadata;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.Deserializer;
import com.pnfsoftware.jeb.util.serialization.SerializationManager;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jebglobal.csd;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SerDisabled
public class TypeLibraryService {
    private static final ILogger logger = GlobalLog.getLogger(TypeLibraryService.class);
    public static final int GROUPID_TYPELIB_UNKNOWN = 0;
    public static final int GROUPID_TYPELIB_POSIX = 1;
    public static final int GROUPID_TYPELIB_LINUX = 2;
    public static final int GROUPID_TYPELIB_LINUX_ANDROID = 3;
    public static final int GROUPID_TYPELIB_WINDOWS = 9;
    public static final int GROUPID_TYPELIB_WIN32 = 10;
    public static final int GROUPID_TYPELIB_WINDDK = 20;
    public static final int GROUPID_TYPELIB_EFI = 30;
    public static final int GROUPID_TYPELIB_TEST = 100;
    public static final int GROUPID_TYPELIB_TEST1 = 101;
    public static final int GROUPID_TYPELIB_TEST2 = 102;
    public static final int GROUPID_TYPELIB_TEST3 = 103;
    public static final int GROUPID_TYPELIB_TEST4 = 104;
    public static final String TYPELIB_FILE_EXTENSION = ".typelib";
    private List<File> folders = new ArrayList<File>();
    private List<TypeLibraryEntry> entries = new ArrayList<TypeLibraryEntry>();
    private Map<Integer, TypeLibraryEntry> idEntryMap = new HashMap<Integer, TypeLibraryEntry>();

    public TypeLibraryService() {
    }

    public TypeLibraryService(File file) {
        this.addFolder(file, true);
    }

    public synchronized void addFolder(File file, boolean bl) {
        this.folders.add(file);
        if (bl) {
            this.rescan();
        }
    }

    public synchronized void rescan() {
        this.rescan(true);
    }

    /*
     * Could not resolve type clashes
     */
    public synchronized void rescan(boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Comparable<TypeLibraryEntry> comparable : this.entries) {
            ((TypeLibraryEntry)comparable).status = 0;
        }
        for (Comparable<TypeLibraryEntry> comparable : this.folders) {
            if (comparable == null || !((File)comparable).exists() || !((File)comparable).isDirectory()) {
                logger.warn("Type library folder is invalid: %s", comparable);
                continue;
            }
            for (File file : ((File)comparable).listFiles()) {
                TypeLibraryMetadata typeLibraryMetadata;
                Object object;
                Object object2;
                if (!file.isFile() || !file.getName().endsWith(TYPELIB_FILE_EXTENSION)) continue;
                try {
                    object2 = new FileInputStream(file);
                    try {
                        csd csd2 = csd.ce();
                        Object object3 = new SerializationManager(csd2);
                        object = ((SerializationManager)object3).getDeserializer((InputStream)object2);
                        typeLibraryMetadata = (TypeLibraryMetadata)((Deserializer)object).deserialize();
                    }
                    finally {
                        ((FileInputStream)object2).close();
                    }
                }
                catch (Exception exception) {
                    logger.error("File %s is not a valid type library", file);
                    JebCoreService.notifyExceptionToClient(exception, 5, Maps.toMap("details", file.getName()), null);
                    continue;
                }
                object2 = null;
                for (Object object3 : this.entries) {
                    if (!((TypeLibraryEntry)object3).file.equals(file)) continue;
                    object2 = object3;
                    break;
                }
                if (object2 != null && ((TypeLibraryEntry)object2).typelib != null) {
                    ((TypeLibraryEntry)object2).status = 1;
                    continue;
                }
                boolean bl2 = true;
                int n2 = typeLibraryMetadata.getUuid();
                if (n2 == 0 && (object = typeLibraryMetadata.getName()) != null) {
                    n2 = Hash.calculateCRC32(Strings.encodeUTF8((String)object));
                }
                if (n2 == 0) {
                    logger.warn("Typelib entry has neither a uuid nor a name from which a uuid will be derived. It will not be loaded. Entry: %s", typeLibraryMetadata);
                    arrayList.add(file);
                    bl2 = false;
                } else {
                    object = this.idEntryMap.get(n2);
                    if (object != null) {
                        int n3;
                        int n4 = ((TypeLibraryEntry)object).getMetadataHeader().getVersion();
                        if (n4 > (n3 = typeLibraryMetadata.getVersion())) {
                            arrayList.add(file);
                            bl2 = false;
                        } else if (n4 < n3) {
                            arrayList.add(((TypeLibraryEntry)object).file);
                            this.entries.remove(object);
                        } else {
                            logger.warn("Two typelib entries have the same UUID and version number: uuid=%d (files: %s and %s)", n2, file, ((TypeLibraryEntry)object).file);
                        }
                    }
                }
                if (!bl2) continue;
                object2 = new TypeLibraryEntry(file, typeLibraryMetadata);
                ((TypeLibraryEntry)object2).status = 1;
                this.entries.add((TypeLibraryEntry)object2);
                this.idEntryMap.put(n2, (TypeLibraryEntry)object2);
            }
        }
        if (bl) {
            for (Comparable<TypeLibraryEntry> comparable : arrayList) {
                ((File)comparable).delete();
            }
        }
        int n5 = 0;
        while (n5 < this.entries.size()) {
            Comparable<TypeLibraryEntry> comparable;
            comparable = this.entries.get(n5);
            if (((TypeLibraryEntry)comparable).status == 0) {
                if (((TypeLibraryEntry)comparable).typelib != null) {
                    ((TypeLibraryEntry)comparable).status = -1;
                } else {
                    this.entries.remove(n5);
                    continue;
                }
            }
            ++n5;
        }
    }

    public synchronized List<TypeLibraryEntry> getAvailables() {
        return new ArrayList<TypeLibraryEntry>(this.entries);
    }

    public synchronized List<ITypeLibrary> getLoadedTypeLibraries() {
        ArrayList<ITypeLibrary> arrayList = new ArrayList<ITypeLibrary>();
        for (TypeLibraryEntry typeLibraryEntry : this.entries) {
            if (typeLibraryEntry.typelib == null) continue;
            arrayList.add(typeLibraryEntry.typelib);
        }
        return arrayList;
    }

    public synchronized List<TypeLibraryEntry> getLoadedTypeLibraryEntries() {
        ArrayList<TypeLibraryEntry> arrayList = new ArrayList<TypeLibraryEntry>();
        for (TypeLibraryEntry typeLibraryEntry : this.entries) {
            if (typeLibraryEntry.typelib == null) continue;
            arrayList.add(typeLibraryEntry);
        }
        return arrayList;
    }

    public synchronized List<TypeLibraryEntry> getNotLoadedTypeLibraryEntries() {
        ArrayList<TypeLibraryEntry> arrayList = new ArrayList<TypeLibraryEntry>();
        for (TypeLibraryEntry typeLibraryEntry : this.entries) {
            if (typeLibraryEntry.typelib != null) continue;
            arrayList.add(typeLibraryEntry);
        }
        return arrayList;
    }

    public synchronized boolean load(TypeLibraryEntry typeLibraryEntry) {
        if (typeLibraryEntry.typelib != null) {
            return true;
        }
        return this.loadInternal(typeLibraryEntry);
    }

    public synchronized boolean loadSingle(ProcessorType processorType, int n2) {
        return this.load(processorType, n2, 1);
    }

    public synchronized boolean load(ProcessorType processorType, int n2) {
        return this.load(processorType, n2, Integer.MAX_VALUE);
    }

    public synchronized boolean load(ProcessorType processorType, int n2, int n3) {
        if (n3 < 0) {
            n3 = Integer.MAX_VALUE;
        }
        ArrayList<ITypeLibrary> arrayList = new ArrayList<ITypeLibrary>();
        for (ITypeLibrary object2 : this.getLoadedTypeLibraries()) {
            if (!object2.getProcessorTypes().contains(processorType) || object2.getGroupId() != n2) continue;
            arrayList.add(object2);
        }
        int n4 = arrayList.size();
        if (n4 >= n3) {
            return n4 > 0;
        }
        n3 -= n4;
        ArrayList<TypeLibraryEntry> arrayList2 = new ArrayList<TypeLibraryEntry>();
        for (TypeLibraryEntry typeLibraryEntry : this.getAvailables()) {
            TypeLibraryMetadata typeLibraryMetadata = typeLibraryEntry.getMetadataHeader();
            if (typeLibraryEntry.typelib != null || typeLibraryEntry.status != 1 || !typeLibraryMetadata.getProcessorTypes().contains(processorType) || typeLibraryMetadata.getGroupId() != n2) continue;
            arrayList2.add(typeLibraryEntry);
        }
        Collections.sort(arrayList2, new Comparator<TypeLibraryEntry>(){

            @Override
            public int compare(TypeLibraryEntry typeLibraryEntry, TypeLibraryEntry typeLibraryEntry2) {
                return Double.compare(typeLibraryEntry.getMetadataHeader().getPriorityOrder(), typeLibraryEntry2.getMetadataHeader().getPriorityOrder());
            }
        });
        for (TypeLibraryEntry typeLibraryEntry : arrayList2) {
            typeLibraryEntry.hdr.getName();
            Object[] cfr_ignored_0 = new Object[0];
            if (n3 <= 0) break;
            if (!this.loadInternal(typeLibraryEntry)) continue;
            --n3;
            ++n4;
        }
        return n4 > 0;
    }

    private synchronized boolean loadInternal(TypeLibraryEntry typeLibraryEntry) {
        boolean bl;
        File file = typeLibraryEntry.getFile();
        logger.debug("Loading typelib: %s", file);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            ITypeLibrary iTypeLibrary;
            csd csd2 = csd.ce();
            SerializationManager serializationManager = new SerializationManager(csd2);
            Deserializer deserializer = serializationManager.getDeserializer(fileInputStream);
            deserializer.deserialize();
            typeLibraryEntry.typelib = iTypeLibrary = (ITypeLibrary)deserializer.deserialize();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                logger.error("File %s is not a valid type library", file);
                return false;
            }
        }
        fileInputStream.close();
        return bl;
    }

    public synchronized boolean loadExternal(ITypeLibrary iTypeLibrary) {
        for (TypeLibraryEntry typeLibraryEntry : this.entries) {
            if (typeLibraryEntry.typelib != iTypeLibrary) continue;
            typeLibraryEntry.status = 1;
            return true;
        }
        TypeLibraryEntry typeLibraryEntry = new TypeLibraryEntry(null, null);
        typeLibraryEntry.typelib = iTypeLibrary;
        typeLibraryEntry.status = 1;
        this.entries.add(typeLibraryEntry);
        return true;
    }

    public synchronized boolean unload(ITypeLibrary iTypeLibrary) {
        for (TypeLibraryEntry typeLibraryEntry : this.entries) {
            if (typeLibraryEntry.typelib != iTypeLibrary) continue;
            return this.unload(typeLibraryEntry);
        }
        return false;
    }

    public synchronized boolean unload(TypeLibraryEntry typeLibraryEntry) {
        if (typeLibraryEntry.typelib == null) {
            return false;
        }
        typeLibraryEntry.typelib = null;
        return true;
    }

    public synchronized int unloadAll() {
        int n2 = 0;
        for (TypeLibraryEntry typeLibraryEntry : this.entries) {
            if (!this.unload(typeLibraryEntry)) continue;
            ++n2;
        }
        return n2;
    }

    public synchronized INativeMethodItem findRoutineByName(String string, ProcessorType processorType) {
        return this.findRoutineByName(string, processorType, 0);
    }

    public synchronized INativeMethodItem findRoutineByName(String string, ProcessorType processorType, int n2) {
        for (ITypeLibrary iTypeLibrary : this.getLoadedTypeLibraries()) {
            if (processorType != null && !iTypeLibrary.getProcessorTypes().contains(processorType) || n2 != 0 && n2 != iTypeLibrary.getGroupId()) continue;
            for (INativeMethodItem iNativeMethodItem : iTypeLibrary.getRoutines()) {
                if (!Strings.isContainedIn(string, iNativeMethodItem.getName(true), iNativeMethodItem.getName(false))) continue;
                return iNativeMethodItem;
            }
        }
        return null;
    }

    public synchronized INativeType findTypeBySignature(String string, ProcessorType processorType) {
        return this.findTypeBySignature(string, processorType, 0);
    }

    public synchronized INativeType findTypeBySignature(String string, ProcessorType processorType, int n2) {
        for (ITypeLibrary iTypeLibrary : this.getLoadedTypeLibraries()) {
            if (processorType != null && !iTypeLibrary.getProcessorTypes().contains(processorType) || n2 != 0 && n2 != iTypeLibrary.getGroupId()) continue;
            for (INativeType iNativeType : iTypeLibrary.getTypes()) {
                if (!Strings.isContainedIn(string, iNativeType.getSignature(true), iNativeType.getSignature(false))) continue;
                return iNativeType;
            }
        }
        return null;
    }

    public static String groupIdToName(int n2) {
        switch (n2) {
            case 1: {
                return "POSIX";
            }
            case 2: {
                return "Linux";
            }
            case 9: {
                return "Windows";
            }
            case 10: {
                return "Win32";
            }
            case 20: {
                return "WinDDK";
            }
            case 3: {
                return "Android";
            }
            case 30: {
                return "EFI";
            }
        }
        return Integer.toString(n2);
    }

    public synchronized Set<Object> findConstantsByName(String string, ProcessorType processorType, int n2) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (ITypeLibrary iTypeLibrary : this.getLoadedTypeLibraries()) {
            if (processorType != null && !iTypeLibrary.getProcessorTypes().contains(processorType) || n2 != 0 && n2 != iTypeLibrary.getGroupId()) continue;
            hashSet.addAll(iTypeLibrary.getConstantManager().getValuesByName(string));
        }
        return hashSet;
    }

    public synchronized Long findFirstIntegerConstantByName(String string) {
        for (ITypeLibrary iTypeLibrary : this.getLoadedTypeLibraries()) {
            for (Object object : iTypeLibrary.getConstantManager().getValuesByName(string)) {
                if (object instanceof Long) {
                    return (Long)object;
                }
                if (!(object instanceof Integer)) continue;
                return (long)((Integer)object).intValue() & 0xFFFFFFFFL;
            }
        }
        return null;
    }
}

