/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeLibrary;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryMetadata;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.io.File;

@SerDisabled
public class TypeLibraryEntry
implements Comparable<TypeLibraryEntry> {
    File file;
    TypeLibraryMetadata hdr;
    ITypeLibrary typelib;
    int status;

    TypeLibraryEntry(File file, TypeLibraryMetadata typeLibraryMetadata) {
        this.file = file;
        this.hdr = typeLibraryMetadata;
    }

    public File getFile() {
        return this.file;
    }

    public TypeLibraryMetadata getMetadataHeader() {
        return this.hdr;
    }

    public ITypeLibrary getTypelib() {
        return this.typelib;
    }

    public boolean isLoaded() {
        return this.typelib != null;
    }

    public String toString() {
        return Strings.ff("Loaded:%b|Header=%s|File:%s", this.getTypelib() != null, this.getMetadataHeader(), this.getFile());
    }

    @Override
    public int compareTo(TypeLibraryEntry typeLibraryEntry) {
        int n2;
        if (this.hdr == null || typeLibraryEntry == null || typeLibraryEntry.hdr == null) {
            return 0;
        }
        ProcessorType processorType = this.hdr.getPrimaryProcessorType();
        ProcessorType processorType2 = typeLibraryEntry.hdr.getPrimaryProcessorType();
        if (processorType == null) {
            return 1;
        }
        if (processorType2 == null) {
            return -1;
        }
        int n3 = Integer.compare(processorType.id(), processorType2.id());
        if (n3 != 0) {
            return n3;
        }
        SubsystemType subsystemType = this.hdr.getPrimarySubsystemType();
        SubsystemType subsystemType2 = typeLibraryEntry.hdr.getPrimarySubsystemType();
        if (subsystemType == null) {
            return 1;
        }
        if (subsystemType2 == null) {
            return -1;
        }
        n3 = Integer.compare(subsystemType.id(), subsystemType2.id());
        if (n3 != 0) {
            return n3;
        }
        int n4 = this.hdr.getGroupId();
        n3 = Integer.compare(n4, n2 = typeLibraryEntry.hdr.getGroupId());
        if (n3 != 0) {
            return n3;
        }
        return 0;
    }
}

