/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.type.TypeCategory;
import com.pnfsoftware.jeb.util.format.Strings;

public class TypeLayoutInfo {
    public static final TypeLayoutInfo i1 = new TypeLayoutInfo(1, TypeCategory.INTEGRAL);
    public static final TypeLayoutInfo i2 = new TypeLayoutInfo(2, TypeCategory.INTEGRAL);
    public static final TypeLayoutInfo f1 = new TypeLayoutInfo(1, TypeCategory.FLOAT);
    public static final TypeLayoutInfo f2 = new TypeLayoutInfo(2, TypeCategory.FLOAT);
    public static final TypeLayoutInfo ptr = new TypeLayoutInfo(1, TypeCategory.POINTER);
    private int slotcount;
    private TypeCategory category;

    private TypeLayoutInfo(int n2, TypeCategory typeCategory) {
        if (n2 <= 0) {
            n2 = 1;
        }
        this.slotcount = n2;
        this.category = typeCategory;
    }

    public int getSlotcount() {
        return this.slotcount;
    }

    public TypeCategory getCategory() {
        return this.category;
    }

    public static TypeLayoutInfo i(int n2) {
        if (n2 == 1) {
            return i1;
        }
        if (n2 == 2) {
            return i2;
        }
        return new TypeLayoutInfo(n2, TypeCategory.INTEGRAL);
    }

    public static TypeLayoutInfo f(int n2) {
        if (n2 == 1) {
            return f1;
        }
        if (n2 == 2) {
            return f2;
        }
        return new TypeLayoutInfo(n2, TypeCategory.FLOAT);
    }

    public static TypeLayoutInfo p(int n2) {
        if (n2 == 1) {
            return ptr;
        }
        return new TypeLayoutInfo(n2, TypeCategory.POINTER);
    }

    public static TypeLayoutInfo v(int n2) {
        return new TypeLayoutInfo(n2, TypeCategory.VECTOR);
    }

    public static TypeLayoutInfo c(int n2) {
        return new TypeLayoutInfo(n2, TypeCategory.COMPOSITE);
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.category == null ? 0 : this.category.hashCode());
        n2 = 31 * n2 + this.slotcount;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TypeLayoutInfo typeLayoutInfo = (TypeLayoutInfo)object;
        if (this.category != typeLayoutInfo.category) {
            return false;
        }
        return this.slotcount == typeLayoutInfo.slotcount;
    }

    public String toString() {
        return Strings.ff("%d:%s", new Object[]{this.slotcount, this.category});
    }

    public boolean isInteger() {
        return this.category == TypeCategory.INTEGRAL;
    }

    public boolean isFloat() {
        return this.category == TypeCategory.FLOAT;
    }

    public boolean isPointer() {
        return this.category == TypeCategory.POINTER;
    }

    public boolean isVector() {
        return this.category == TypeCategory.VECTOR;
    }

    public boolean isComposite() {
        return this.category == TypeCategory.COMPOSITE;
    }
}

