/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Ser
public class StorageEntry {
    @SerId(value=1)
    private Type type;
    @SerId(value=2)
    private long value;
    @SerId(value=3)
    private long value2;
    @SerId(value=4)
    private long value3;
    @SerId(value=5)
    private long value4;
    @SerId(value=6)
    private List<StorageEntry> items;
    @SerId(value=7)
    private TransformationRule transformation;

    public static StorageEntry createStackSlot(long l2) {
        return StorageEntry.createStackEntry(l2, 1);
    }

    public static StorageEntry createStackEntry(long l2, int n2) {
        return new StorageEntry(Type.STACK, l2, n2, 0L, 0L, null);
    }

    public static StorageEntry createRegister(long l2) {
        if (l2 < 0L) {
            throw new RuntimeException("Illegal register index for slot: " + l2);
        }
        return new StorageEntry(Type.REGISTER, l2, -1L, 0L, 0L, null);
    }

    public static StorageEntry createRegisterPair(long l2, long l3) {
        return StorageEntry.createRegisterPair(l2, l3, false);
    }

    public static StorageEntry createRegisterPairEndianDep(long l2, long l3) {
        return StorageEntry.createRegisterPair(l2, l3, true);
    }

    private static StorageEntry createRegisterPair(long l2, long l3, boolean bl) {
        return new StorageEntry(Type.REGISTER_PAIR, l2, l3, 0L, 0L, bl ? TransformationRule.ENDIAN_DEPENDENT : TransformationRule.NONE);
    }

    public static StorageEntry createRegisterQuad(long l2, long l3, long l4, long l5) {
        return StorageEntry.createRegisterQuad(l2, l3, l4, l5, false);
    }

    public static StorageEntry createRegisterQuadEndianDep(long l2, long l3, long l4, long l5) {
        return StorageEntry.createRegisterQuad(l2, l3, l4, l5, true);
    }

    private static StorageEntry createRegisterQuad(long l2, long l3, long l4, long l5, boolean bl) {
        return new StorageEntry(Type.REGISTER_QUAD, l2, l3, l4, l5, bl ? TransformationRule.ENDIAN_DEPENDENT : TransformationRule.NONE);
    }

    public static StorageEntry createMixed(StorageEntry ... storageEntryArray) {
        return StorageEntry.createMixed(Arrays.asList(storageEntryArray));
    }

    public static StorageEntry createMixed(Collection<StorageEntry> collection) {
        if (collection == null || collection.size() < 2) {
            throw new IllegalArgumentException();
        }
        int n2 = collection.size() - 1;
        int n3 = 0;
        for (StorageEntry storageEntry : collection) {
            if (storageEntry.getType() != Type.REGISTER && (n3 != n2 || storageEntry.getType() != Type.STACK)) {
                throw new IllegalArgumentException();
            }
            ++n3;
        }
        StorageEntry storageEntry = new StorageEntry(Type.MIXED, 0L, 0L, 0L, 0L, null);
        storageEntry.items = new ArrayList<StorageEntry>(collection);
        return storageEntry;
    }

    private StorageEntry(Type type, long l2, long l3, long l4, long l5, TransformationRule transformationRule) {
        if (type == null) {
            throw new NullPointerException("Missing slot type");
        }
        this.type = type;
        this.value = l2;
        this.value2 = l3;
        this.value3 = l4;
        this.value4 = l5;
        this.transformation = transformationRule;
    }

    public StorageEntry withCount(int n2) {
        int n3 = this.getValueAsStackIndex();
        return new StorageEntry(Type.STACK, n3, n2, 0L, 0L, this.transformation);
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.items == null ? 0 : this.items.hashCode());
        n2 = 31 * n2 + (this.transformation == null ? 0 : this.transformation.hashCode());
        n2 = 31 * n2 + (this.type == null ? 0 : this.type.hashCode());
        n2 = 31 * n2 + (int)(this.value ^ this.value >>> 32);
        n2 = 31 * n2 + (int)(this.value2 ^ this.value2 >>> 32);
        n2 = 31 * n2 + (int)(this.value3 ^ this.value3 >>> 32);
        n2 = 31 * n2 + (int)(this.value4 ^ this.value4 >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StorageEntry storageEntry = (StorageEntry)object;
        if (this.items == null ? storageEntry.items != null : !this.items.equals(storageEntry.items)) {
            return false;
        }
        if (this.transformation != storageEntry.transformation) {
            return false;
        }
        if (this.type != storageEntry.type) {
            return false;
        }
        if (this.value != storageEntry.value) {
            return false;
        }
        if (this.value2 != storageEntry.value2) {
            return false;
        }
        if (this.value3 != storageEntry.value3) {
            return false;
        }
        return this.value4 == storageEntry.value4;
    }

    public Type getType() {
        return this.type;
    }

    public int getValueAsStackIndex() {
        Assert.a(this.type == Type.STACK);
        return (int)this.value;
    }

    public Collection<Long> getRegisters() {
        HashSet<Long> hashSet = new HashSet<Long>();
        this.collectRegisters(hashSet);
        return hashSet;
    }

    public void collectRegisters(Set<Long> set) {
        switch (this.type) {
            case REGISTER: {
                set.add(this.getValue());
                break;
            }
            case REGISTER_PAIR: {
                set.add(this.getValue());
                set.add(this.getValue2());
                break;
            }
            case REGISTER_QUAD: {
                set.add(this.getValue());
                set.add(this.getValue2());
                set.add(this.getValue3());
                set.add(this.getValue4());
                break;
            }
            case MIXED: {
                for (StorageEntry storageEntry : this.items) {
                    storageEntry.collectRegisters(set);
                }
                break;
            }
        }
    }

    public long getValue() {
        return this.value;
    }

    public long getValue(Endianness endianness) {
        if (this.transformation == TransformationRule.ENDIAN_DEPENDENT) {
            return endianness == Endianness.LITTLE_ENDIAN ? this.value : this.value2;
        }
        return this.value;
    }

    public long getValue2() {
        return this.value2;
    }

    public long getValue2(Endianness endianness) {
        if (this.transformation == TransformationRule.ENDIAN_DEPENDENT) {
            return endianness == Endianness.LITTLE_ENDIAN ? this.value2 : this.value;
        }
        return this.value2;
    }

    public long getValue3() {
        return this.value3;
    }

    public long getValue4() {
        return this.value4;
    }

    public List<StorageEntry> getMixedItems() {
        Assert.a(this.type == Type.MIXED);
        return Collections.unmodifiableList(this.items);
    }

    public StorageEntry getMixedItem(int n2) {
        Assert.a(this.type == Type.MIXED);
        return this.items.get(n2);
    }

    public int nextSlotIndex(int n2, int n3) {
        int n4;
        switch (this.type) {
            case REGISTER: {
                n4 = n2 + 1;
                break;
            }
            case REGISTER_PAIR: {
                n4 = n2 + 2;
                break;
            }
            case REGISTER_QUAD: {
                n4 = n2 + 4;
                break;
            }
            default: {
                n4 = n2 + n3;
            }
        }
        return n4;
    }

    public boolean isStackBased() {
        if (this.getType() == Type.STACK) {
            return true;
        }
        if (this.getType() == Type.MIXED) {
            for (StorageEntry storageEntry : this.items) {
                if (!storageEntry.isStackBased()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRegisterBased() {
        if (this.getType() == Type.REGISTER) {
            return true;
        }
        if (this.getType() == Type.REGISTER_PAIR) {
            return true;
        }
        if (this.getType() == Type.REGISTER_QUAD) {
            return true;
        }
        if (this.getType() == Type.MIXED) {
            for (StorageEntry storageEntry : this.items) {
                if (!storageEntry.isRegisterBased()) continue;
                return true;
            }
        }
        return false;
    }

    public StorageEntry nextStackEntry(int n2) {
        return this.nextStackEntry(n2, 1);
    }

    public StorageEntry nextStackEntry(int n2, int n3) {
        if (this.type != Type.STACK) {
            if (this.type == Type.MIXED) {
                StorageEntry storageEntry = this.items.get(this.items.size() - 1);
                return storageEntry.nextStackEntry(n2, n3);
            }
            throw new IllegalArgumentException();
        }
        int n4 = this.getValueAsStackIndex();
        int n5 = this.getSlotCount();
        int n6 = n4 + n5;
        if (n3 >= 2) {
            n6 = (n6 + n3 - 1) / n3 * n3;
        }
        return StorageEntry.createStackEntry(n6, n2);
    }

    public int getSlotCount() {
        switch (this.type) {
            case STACK: {
                return this.value2 > 0L ? (int)this.value2 : 1;
            }
            case REGISTER: {
                return 1;
            }
            case REGISTER_PAIR: {
                return 2;
            }
            case REGISTER_QUAD: {
                return 4;
            }
            case MIXED: {
                int n2 = 0;
                for (StorageEntry storageEntry : this.items) {
                    n2 += storageEntry.getSlotCount();
                }
                return n2;
            }
        }
        return 0;
    }

    public String toString() {
        switch (this.getType()) {
            case STACK: {
                return Strings.ff("stk=slot:%d,+%d", this.getValue(), this.getValue2());
            }
            case REGISTER: {
                return Strings.ff("reg=%Xh", this.getValue());
            }
            case REGISTER_PAIR: {
                return Strings.ff("pair=%Xh:%Xh", this.getValue(), this.getValue2());
            }
            case REGISTER_QUAD: {
                return Strings.ff("quad=%Xh:%Xh:%Xh:%Xh", this.getValue(), this.getValue2(), this.getValue3(), this.getValue4());
            }
            case MIXED: {
                return Strings.ff("composite:%s", Strings.join(",", this.items));
            }
        }
        return Strings.ff("other", new Object[0]);
    }

    public String formatLong(IRegisterBank iRegisterBank) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.getType()) {
            case STACK: {
                Strings.ff(stringBuilder, "stack @%d", this.getValue());
                break;
            }
            case REGISTER: {
                Strings.ff(stringBuilder, "%s", iRegisterBank.getDescriptionEntryById(this.getValue()).getName());
                break;
            }
            case REGISTER_PAIR: {
                Strings.ff(stringBuilder, "%s:%s", iRegisterBank.getDescriptionEntryById(this.getValue()).getName(), iRegisterBank.getDescriptionEntryById(this.getValue2()).getName());
                break;
            }
            case REGISTER_QUAD: {
                Strings.ff(stringBuilder, "%s:%s:%s:%s", iRegisterBank.getDescriptionEntryById(this.getValue()).getName(), iRegisterBank.getDescriptionEntryById(this.getValue2()).getName(), iRegisterBank.getDescriptionEntryById(this.getValue3()).getName(), iRegisterBank.getDescriptionEntryById(this.getValue4()).getName());
            }
        }
        if (this.transformation != null && this.transformation != TransformationRule.NONE) {
            Strings.ff(stringBuilder, " (%s)", new Object[]{this.transformation});
        }
        return stringBuilder.toString();
    }

    public String formatParseable(IRegisterBank iRegisterBank) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.getType()) {
            case STACK: {
                Strings.ff(stringBuilder, "stack@%d", this.getValue());
                break;
            }
            case REGISTER: {
                Strings.ff(stringBuilder, "%s", iRegisterBank.getDescriptionEntryById(this.getValue()).getName());
                break;
            }
            case REGISTER_PAIR: {
                Strings.ff(stringBuilder, "%s+%s", iRegisterBank.getDescriptionEntryById(this.getValue()).getName(), iRegisterBank.getDescriptionEntryById(this.getValue2()).getName());
                break;
            }
            case REGISTER_QUAD: {
                Strings.ff(stringBuilder, "%s+%s+%s+%s", iRegisterBank.getDescriptionEntryById(this.getValue()).getName(), iRegisterBank.getDescriptionEntryById(this.getValue2()).getName(), iRegisterBank.getDescriptionEntryById(this.getValue3()).getName(), iRegisterBank.getDescriptionEntryById(this.getValue4()).getName());
            }
        }
        if (this.transformation != null && this.transformation != TransformationRule.NONE) {
            if (this.transformation == TransformationRule.ENDIAN_DEPENDENT) {
                stringBuilder.append("%END%");
            } else {
                stringBuilder.append("%").append((Object)this.transformation).append("%");
            }
        }
        return stringBuilder.toString();
    }

    @Ser
    public static enum TransformationRule {
        NONE,
        ENDIAN_DEPENDENT;

    }

    @Ser
    public static enum Type {
        STACK,
        REGISTER,
        REGISTER_PAIR,
        REGISTER_QUAD,
        MIXED;

    }
}

