/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.type.IPrimitiveSizes;
import com.pnfsoftware.jeb.core.units.codeobject.CompilerType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerStaticOk;

@Ser
public class PrimitiveSizes
implements IPrimitiveSizes {
    @SerStaticOk
    public static final PrimitiveSizes GCC_ARM = new PrimitiveSizes(1, 2, 4, 4, 8, 4, 8, 8);
    @SerStaticOk
    public static final PrimitiveSizes GCC_ARM64 = new PrimitiveSizes(1, 2, 4, 8, 8, 4, 8, 16);
    @SerStaticOk
    public static final PrimitiveSizes GCC_X86 = new PrimitiveSizes(1, 2, 4, 4, 8, 4, 8, 12);
    @SerStaticOk
    public static final PrimitiveSizes GCC_X86_64 = new PrimitiveSizes(1, 2, 4, 8, 8, 4, 8, 16);
    @SerStaticOk
    public static final PrimitiveSizes GCC_MIPS = new PrimitiveSizes(1, 2, 4, 4, 8, 4, 8, 8);
    @SerStaticOk
    public static final PrimitiveSizes MSVC_GENERIC;
    @SerStaticOk
    public static final PrimitiveSizes MSVC_ARM;
    @SerStaticOk
    public static final PrimitiveSizes MSVC_ARM64;
    @SerStaticOk
    public static final PrimitiveSizes MSVC_X86;
    @SerStaticOk
    public static final PrimitiveSizes MSVC_X86_64;
    @SerStaticOk
    public static final PrimitiveSizes COMMON_PRIMITIVE_SIZES;
    @SerStaticOk
    public static final PrimitiveSizes COMMON_PRIMITIVE_SIZES64;
    @SerId(value=1)
    int charSize;
    @SerId(value=2)
    int shortSize;
    @SerId(value=3)
    int intSize;
    @SerId(value=4)
    int longSize;
    @SerId(value=5)
    int longLongSize;
    @SerId(value=6)
    int floatSize;
    @SerId(value=7)
    int doubleSize;
    @SerId(value=8)
    int longDoubleSize;

    public static PrimitiveSizes getCommon(ProcessorType processorType, CompilerType compilerType) {
        if (processorType == null) {
            processorType = ProcessorType.UNKNOWN;
        }
        if (compilerType == null) {
            compilerType = CompilerType.UNKNOWN;
        }
        if (compilerType == CompilerType.GCC) {
            if (processorType == ProcessorType.ARM) {
                return GCC_ARM;
            }
            if (processorType == ProcessorType.ARM64) {
                return GCC_ARM64;
            }
            if (processorType == ProcessorType.X86) {
                return GCC_X86;
            }
            if (processorType == ProcessorType.X86_64) {
                return GCC_X86_64;
            }
        } else if (compilerType == CompilerType.MSVC) {
            if (processorType == ProcessorType.ARM) {
                return MSVC_ARM;
            }
            if (processorType == ProcessorType.ARM64) {
                return MSVC_ARM64;
            }
            if (processorType == ProcessorType.X86) {
                return MSVC_X86;
            }
            if (processorType == ProcessorType.X86_64) {
                return MSVC_X86_64;
            }
        }
        return processorType.is64Bit() ? COMMON_PRIMITIVE_SIZES64 : COMMON_PRIMITIVE_SIZES;
    }

    public PrimitiveSizes(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.charSize = n2;
        this.shortSize = n3;
        this.intSize = n4;
        this.longSize = n5;
        this.longLongSize = n6;
        this.floatSize = n7;
        this.doubleSize = n8;
        this.longDoubleSize = n9;
    }

    public PrimitiveSizes(IPrimitiveSizes iPrimitiveSizes) {
        this(iPrimitiveSizes.getCharSize(), iPrimitiveSizes.getShortSize(), iPrimitiveSizes.getIntSize(), iPrimitiveSizes.getLongSize(), iPrimitiveSizes.getLongLongSize(), iPrimitiveSizes.getFloatSize(), iPrimitiveSizes.getDoubleSize(), iPrimitiveSizes.getLongDoubleSize());
    }

    @Override
    public int getCharSize() {
        return this.charSize;
    }

    @Override
    public int getShortSize() {
        return this.shortSize;
    }

    @Override
    public int getIntSize() {
        return this.intSize;
    }

    @Override
    public int getLongSize() {
        return this.longSize;
    }

    @Override
    public int getLongLongSize() {
        return this.longLongSize;
    }

    @Override
    public int getFloatSize() {
        return this.floatSize;
    }

    @Override
    public int getDoubleSize() {
        return this.doubleSize;
    }

    @Override
    public int getLongDoubleSize() {
        return this.longDoubleSize;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.charSize;
        n2 = 31 * n2 + this.doubleSize;
        n2 = 31 * n2 + this.floatSize;
        n2 = 31 * n2 + this.intSize;
        n2 = 31 * n2 + this.longDoubleSize;
        n2 = 31 * n2 + this.longLongSize;
        n2 = 31 * n2 + this.longSize;
        n2 = 31 * n2 + this.shortSize;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PrimitiveSizes primitiveSizes = (PrimitiveSizes)object;
        if (this.charSize != primitiveSizes.charSize) {
            return false;
        }
        if (this.doubleSize != primitiveSizes.doubleSize) {
            return false;
        }
        if (this.floatSize != primitiveSizes.floatSize) {
            return false;
        }
        if (this.intSize != primitiveSizes.intSize) {
            return false;
        }
        if (this.longDoubleSize != primitiveSizes.longDoubleSize) {
            return false;
        }
        if (this.longLongSize != primitiveSizes.longLongSize) {
            return false;
        }
        if (this.longSize != primitiveSizes.longSize) {
            return false;
        }
        return this.shortSize == primitiveSizes.shortSize;
    }

    public String toString() {
        return Strings.ff("char:%d,short:%d,int:%d,long:%d,long-long:%d,float:%d,double:%d,long-double:%d", this.charSize, this.shortSize, this.intSize, this.longSize, this.longLongSize, this.floatSize, this.doubleSize, this.longDoubleSize);
    }

    static {
        MSVC_ARM = MSVC_GENERIC = new PrimitiveSizes(1, 2, 4, 4, 8, 4, 8, 8);
        MSVC_ARM64 = MSVC_GENERIC;
        MSVC_X86 = MSVC_GENERIC;
        MSVC_X86_64 = MSVC_GENERIC;
        COMMON_PRIMITIVE_SIZES = new PrimitiveSizes(1, 2, 4, 4, 8, 4, 8, 10);
        COMMON_PRIMITIVE_SIZES64 = new PrimitiveSizes(1, 2, 4, 8, 8, 4, 8, 10);
    }
}

