/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.type.IAliasType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IArrayType;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IReferenceType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureTypeField;
import com.pnfsoftware.jeb.util.format.Strings;

public class PrettyTypeFormatter {
    private int levelStructDepth = 1;
    private boolean displayOffsets = false;
    private boolean displayPaddingInfo = false;
    private boolean displayAliasedType = false;
    private boolean displayTrailingSemicolon = false;
    private INativeType type;
    private StringBuilder sb;

    public PrettyTypeFormatter() {
    }

    public PrettyTypeFormatter(int n2, boolean bl) {
        this.setLevelStructDepth(n2);
        this.setDisplayOffsets(bl);
        this.setDisplayPaddingInfo(bl);
        this.setDisplayAliasedType(bl);
    }

    public void setLevelStructDepth(int n2) {
        this.levelStructDepth = n2;
    }

    public int getLevelStructDepth() {
        return this.levelStructDepth;
    }

    public void setDisplayOffsets(boolean bl) {
        this.displayOffsets = bl;
    }

    public boolean isDisplayOffsets() {
        return this.displayOffsets;
    }

    public void setDisplayPaddingInfo(boolean bl) {
        this.displayPaddingInfo = bl;
    }

    public boolean isDisplayPaddingInfo() {
        return this.displayPaddingInfo;
    }

    public void setDisplayAliasedType(boolean bl) {
        this.displayAliasedType = bl;
    }

    public boolean isDisplayAliasedType() {
        return this.displayAliasedType;
    }

    public void setDisplayTrailingSemicolon(boolean bl) {
        this.displayTrailingSemicolon = bl;
    }

    public boolean isDisplayTrailingSemicolon() {
        return this.displayTrailingSemicolon;
    }

    public synchronized String format(INativeType iNativeType) {
        if (iNativeType == null) {
            throw new IllegalArgumentException();
        }
        this.type = iNativeType;
        try {
            String string = this.format();
            return string;
        }
        finally {
            this.type = null;
            this.sb = null;
        }
    }

    private String format() {
        this.sb = new StringBuilder();
        this.gen(this.type, this.displayAliasedType, 0, 0);
        if (this.displayTrailingSemicolon) {
            this.sb.append(';');
        }
        if (this.displayOffsets) {
            Strings.ff(this.sb, "  // size:%Xh", this.type.getSize());
        }
        return this.sb.toString();
    }

    private void gen(INativeType iNativeType, boolean bl, int n2, int n3) {
        if (bl && iNativeType instanceof IStructureType) {
            bl = false;
        }
        boolean bl2 = false;
        if (n2 < this.levelStructDepth) {
            if (iNativeType instanceof IArrayType) {
                IArrayType iArrayType = (IArrayType)iNativeType;
                this.gen(iArrayType.getElementType(), bl, n2, n3);
                Strings.ff(this.sb, "[%d]", iArrayType.getElementCount());
            } else if (iNativeType instanceof IReferenceType) {
                IReferenceType iReferenceType = (IReferenceType)iNativeType;
                this.indentAppend(iReferenceType.getMainType().getName(true), n2);
                this.sb.append(Strings.generate('*', iReferenceType.getReferenceCount()));
            } else if (iNativeType instanceof IAliasType) {
                IAliasType iAliasType = (IAliasType)iNativeType;
                this.indentAppend(iAliasType.getName(true), n2);
                if (bl) {
                    this.sb.append(" ==> ");
                    this.gen(iAliasType.getAliasedType(), bl, n2, n3);
                }
            } else if (iNativeType instanceof IStructureType) {
                IStructureType iStructureType = (IStructureType)iNativeType;
                int n4 = iStructureType.getPadding();
                int n5 = iStructureType.getAlignment();
                if ((n4 > 1 || n5 > 1) && this.displayPaddingInfo) {
                    Strings.ff(this.sb, "/*pack:%s,align:%d*/ ", n4 == Integer.MAX_VALUE ? "NATURAL" : Integer.toString(n4), n5);
                }
                this.indentAppend(iStructureType.isUnion() ? "union" : "struct", n2);
                Strings.ff(this.sb, " %s {\n", iStructureType.getName(true));
                for (IStructureTypeField iStructureTypeField : iStructureType.getFieldsWithGaps()) {
                    INativeType iNativeType2 = iStructureTypeField.getType();
                    this.gen(iNativeType2, false, n2 + 1, n3 + iStructureTypeField.getOffset());
                    if (iStructureTypeField.getAlignment() > 1 && this.displayPaddingInfo) {
                        Strings.ff(this.sb, " /*alignas(%d)*/", iStructureTypeField.getAlignment());
                    }
                    if (iNativeType2 != null) {
                        Strings.ff(this.sb, " %s;", iStructureTypeField.getName(true));
                    }
                    if (this.displayOffsets) {
                        Strings.ff(this.sb, "  // %Xh", n3 + iStructureTypeField.getOffset());
                    }
                    this.sb.append('\n');
                }
                this.indentAppend("}", n2);
            } else {
                bl2 = true;
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            if (iNativeType == null) {
                if (this.displayPaddingInfo) {
                    this.indentAppend("/*padding*/", n2);
                }
            } else {
                this.indentAppend(iNativeType.getName(true), n2);
            }
        }
    }

    private void indentAppend(String string, int n2) {
        this.sb.append(Strings.generate(' ', n2 * 2));
        this.sb.append(string);
    }
}

