/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionBuilder;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConventionManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStorageEntryGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.core.units.codeobject.CompilerType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorUtil;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.io.Endianness;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

public class CallingConventionUtil {
    public static Collection<Long> getOrderedSingleInputRegisters(ICallingConvention iCallingConvention, Endianness endianness) {
        LinkedHashSet<Long> linkedHashSet = new LinkedHashSet<Long>();
        for (StorageEntry storageEntry : ((CallingConvention)iCallingConvention).inEntries) {
            if (storageEntry.getType() != StorageEntry.Type.REGISTER) continue;
            linkedHashSet.add(storageEntry.getValue());
        }
        return linkedHashSet;
    }

    public static Collection<Long> getOrderedSingleOutputRegisters(ICallingConvention iCallingConvention, Endianness endianness) {
        LinkedHashSet<Long> linkedHashSet = new LinkedHashSet<Long>();
        for (StorageEntry storageEntry : ((CallingConvention)iCallingConvention).outEntries) {
            if (storageEntry.getType() != StorageEntry.Type.REGISTER) continue;
            linkedHashSet.add(storageEntry.getValue());
        }
        return linkedHashSet;
    }

    public static Set<Long> getInputRegisters(ICallingConvention iCallingConvention, Endianness endianness) {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (StorageEntry storageEntry : ((CallingConvention)iCallingConvention).inEntries) {
            if (storageEntry.getType() != StorageEntry.Type.REGISTER) continue;
            hashSet.add(storageEntry.getValue());
        }
        for (StorageEntry storageEntry : ((CallingConvention)iCallingConvention).inRegPairs) {
            hashSet.add(storageEntry.getValue(endianness));
            hashSet.add(storageEntry.getValue2(endianness));
        }
        return hashSet;
    }

    public static Set<Long> getOutputRegisters(ICallingConvention iCallingConvention, Endianness endianness) {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (StorageEntry storageEntry : ((CallingConvention)iCallingConvention).outEntries) {
            if (storageEntry.getType() != StorageEntry.Type.REGISTER) continue;
            hashSet.add(storageEntry.getValue());
        }
        for (StorageEntry storageEntry : ((CallingConvention)iCallingConvention).outRegPairs) {
            hashSet.add(storageEntry.getValue(endianness));
            hashSet.add(storageEntry.getValue2(endianness));
        }
        return hashSet;
    }

    public static Set<Long> getParameterRegisters(ICallingConventionManager iCallingConventionManager, Endianness endianness) {
        HashSet<Long> hashSet = new HashSet<Long>();
        if (iCallingConventionManager != null) {
            List<ICallingConvention> list = iCallingConventionManager.getConventions();
            for (ICallingConvention iCallingConvention : list) {
                hashSet.addAll(CallingConventionUtil.getInputRegisters((CallingConvention)iCallingConvention, endianness));
            }
        }
        return hashSet;
    }

    public static Set<Long> getSpoiledRegisters(ICallingConventionManager iCallingConventionManager) {
        HashSet<Long> hashSet = new HashSet<Long>();
        if (iCallingConventionManager != null) {
            List<ICallingConvention> list = iCallingConventionManager.getConventions();
            for (ICallingConvention iCallingConvention : list) {
                hashSet.addAll(iCallingConvention.getSpoiledRegisters());
            }
        }
        return hashSet;
    }

    public static int getParameterIndexByArgumentStackOffset(ICallingConvention iCallingConvention, IPrototypeItem iPrototypeItem, int n2, int n3) {
        int n4 = n2 / n3;
        IStorageEntryGenerator iStorageEntryGenerator = iCallingConvention.getInputsGenerator();
        int n5 = 0;
        for (INativeType iNativeType : iPrototypeItem.getParameterTypes()) {
            StorageEntry storageEntry = iStorageEntryGenerator.next(TypeUtil.getLayoutInfo(iNativeType));
            if (storageEntry.getType() == StorageEntry.Type.STACK) {
                if (storageEntry.getValue() > (long)n4) break;
                if (storageEntry.getValue() == (long)n4) {
                    return n5;
                }
            }
            ++n5;
        }
        return -1;
    }

    public static ICallingConvention parseAndBuild(String string, boolean bl) {
        return CallingConventionUtil.parse(string).build();
    }

    public static CallingConventionBuilder parse(String string) {
        String string2;
        List<StorageEntry> list;
        Object object;
        Object object222;
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(string);
        List list2 = new ArrayList<String>();
        String string3 = (String)map.get("name");
        if (string3 != null) {
            list2.add(string3);
        } else {
            list2 = (List)map.get("names");
            if (list2 == null || list2.isEmpty()) {
                throw new IllegalArgumentException("A calling convention must have a name");
            }
        }
        CallingConventionBuilder callingConventionBuilder = new CallingConventionBuilder((String)list2.get(0));
        callingConventionBuilder.addAlternateNames(list2.subList(1, list2.size()));
        for (Object object222 : Lists.safe((List)map.get("processors"))) {
            object = ProcessorUtil.fromArchName((String)object222);
            if (object == null) {
                throw new IllegalArgumentException("Unknown processor type: " + (String)object222);
            }
            callingConventionBuilder.addProcessorType((ProcessorType)object);
        }
        for (Object object222 : Lists.safe((List)map.get("subsystems"))) {
            object = SubsystemType.valueOf(((String)object222).toUpperCase());
            if (object == null) {
                throw new IllegalArgumentException("Unknown subsystem type: " + (String)object222);
            }
            callingConventionBuilder.addSubsystemType((SubsystemType)object);
        }
        for (Object object222 : Lists.safe((List)map.get("compilers"))) {
            object = CompilerType.valueOf(((String)object222).toUpperCase());
            if (object == null) {
                throw new IllegalArgumentException("Unknown compiler type: " + (String)object222);
            }
            callingConventionBuilder.addCompilerType((CompilerType)object);
        }
        ProcessorType processorType = callingConventionBuilder.proctypes.get(0);
        object222 = RegisterUtil.getBank(processorType);
        if (object222 == null) {
            throw new IllegalArgumentException("No register bank found for processor: " + (ProcessorType)processorType);
        }
        object = (List)map.get("flags");
        if (object != null) {
            int n2 = 0;
            list = object.iterator();
            block31: while (list.hasNext()) {
                string2 = (String)list.next();
                Object object3 = string2.toUpperCase();
                if (!((String)object3).startsWith("FLAG_")) {
                    object3 = "FLAG_" + (String)object3;
                }
                switch (object3) {
                    case "FLAG_STACK_CLEANED_BY_CALLEE": {
                        n2 |= 1;
                        continue block31;
                    }
                    case "FLAG_OUTPUT_AFTER_INPUT": {
                        n2 |= 0x20;
                        continue block31;
                    }
                    case "FLAG_FLOAT_INPUT_ON_STACK": {
                        n2 |= 0x40;
                        continue block31;
                    }
                    case "FLAG_LINK_AFTER_INPUT": {
                        n2 |= 0x80;
                        continue block31;
                    }
                    case "FLAG_IPRD": {
                        n2 |= 0x100;
                        continue block31;
                    }
                    case "FLAG_OUTPUT_PUSHED": {
                        n2 |= 0x200;
                        continue block31;
                    }
                    case "FLAG_PARALLEL_INPUT_REGISTER_STACKS": {
                        n2 |= 0x400;
                        continue block31;
                    }
                    case "FLAG_FIRST_ARG_IS_THIS_POINTER": {
                        n2 |= 0x800;
                        continue block31;
                    }
                    case "FLAG_COMPOSITE_INPUT_ON_STACK": {
                        n2 |= 0x1000;
                        continue block31;
                    }
                    case "FLAG_FORBID_PARAMS_2SLOTSUP": {
                        n2 |= 0x2000;
                        continue block31;
                    }
                    case "FLAG_FORBID_PARAMS_3SLOTSUP": {
                        n2 |= 0x4000;
                        continue block31;
                    }
                    case "FLAG_SKIP_PASSED_INPUT_REGISTERS": {
                        n2 |= 0x8000;
                        continue block31;
                    }
                }
                throw new IllegalArgumentException("Unknown flag: " + string2);
            }
            callingConventionBuilder.setFlags(n2);
        }
        list = CallingConventionUtil.parseEntries(map.get("spoiled_registers"), (IRegisterBank)object222);
        callingConventionBuilder.addSpoiledRegisters((Collection<StorageEntry>)list);
        StorageEntry storageEntry = CallingConventionUtil.parseEntry(map.get("return_address_location"), (IRegisterBank)object222);
        callingConventionBuilder.setReturnAddressSlot(storageEntry);
        list = CallingConventionUtil.parseEntries(map.get("inputs"), (IRegisterBank)object222);
        callingConventionBuilder.addInputSlots(list);
        list = CallingConventionUtil.parseEntries(map.get("outputs"), (IRegisterBank)object222);
        callingConventionBuilder.addOutputSlots(list);
        list = CallingConventionUtil.parseEntries(map.get("input_pairs"), (IRegisterBank)object222);
        callingConventionBuilder.addInputRegisterPairs(list);
        list = CallingConventionUtil.parseEntries(map.get("output_pairs"), (IRegisterBank)object222);
        callingConventionBuilder.addOutputRegisterPairs(list);
        list = CallingConventionUtil.parseEntries(map.get("input_floats"), (IRegisterBank)object222);
        callingConventionBuilder.addInputFpSlots(list);
        storageEntry = CallingConventionUtil.parseEntry(map.get("output_float"), (IRegisterBank)object222);
        callingConventionBuilder.setOutputFpSlot(storageEntry);
        string2 = (String)map.get("notes");
        callingConventionBuilder.setNotes(string2);
        return callingConventionBuilder;
    }

    private static StorageEntry parseEntry(Object object, IRegisterBank iRegisterBank) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String[] stringArray;
            String string = (String)object;
            if (string.toLowerCase().startsWith("stack@")) {
                int n2 = Integer.parseInt(string.substring(6));
                return StorageEntry.createStackSlot(n2);
            }
            boolean bl = false;
            if (string.toLowerCase().endsWith("%end%")) {
                bl = true;
                string = string.substring(0, string.length() - 5);
            }
            if ((stringArray = string.split("\\+")).length == 1) {
                RegisterDescriptionEntry registerDescriptionEntry = iRegisterBank.getDescriptionEntryByName(stringArray[0]);
                if (registerDescriptionEntry == null) {
                    throw new IllegalArgumentException("Cannot find register: " + stringArray[0]);
                }
                return StorageEntry.createRegister(registerDescriptionEntry.getId());
            }
            if (stringArray.length == 2) {
                RegisterDescriptionEntry registerDescriptionEntry = iRegisterBank.getDescriptionEntryByName(stringArray[0]);
                if (registerDescriptionEntry == null) {
                    throw new IllegalArgumentException("Cannot find first register in pair: " + stringArray[0]);
                }
                RegisterDescriptionEntry registerDescriptionEntry2 = iRegisterBank.getDescriptionEntryByName(stringArray[1]);
                if (registerDescriptionEntry2 == null) {
                    throw new IllegalArgumentException("Cannot find second register in pair: " + stringArray[1]);
                }
                if (bl) {
                    return StorageEntry.createRegisterPairEndianDep(registerDescriptionEntry.getId(), registerDescriptionEntry2.getId());
                }
                return StorageEntry.createRegisterPair(registerDescriptionEntry.getId(), registerDescriptionEntry2.getId());
            }
            throw new RuntimeException("Unsupported entry type");
        }
        if (object instanceof Map) {
            throw new RuntimeException("TBI: long form of StorageEntry");
        }
        throw new RuntimeException("Unsupported");
    }

    private static List<StorageEntry> parseEntries(Object object, IRegisterBank iRegisterBank) {
        if (object == null) {
            return new ArrayList<StorageEntry>();
        }
        if (object instanceof List) {
            ArrayList<StorageEntry> arrayList = new ArrayList<StorageEntry>();
            for (Object e : (List)object) {
                StorageEntry storageEntry = CallingConventionUtil.parseEntry(e, iRegisterBank);
                if (storageEntry == null) continue;
                arrayList.add(storageEntry);
            }
            return arrayList;
        }
        StorageEntry storageEntry = CallingConventionUtil.parseEntry(object, iRegisterBank);
        if (storageEntry != null) {
            return Lists.createArrayList(storageEntry);
        }
        throw new RuntimeException("Unsupported");
    }

    public static boolean isValidForProcessor(ICallingConvention iCallingConvention, List<ProcessorType> list) {
        if (iCallingConvention.getProcessorTypes().isEmpty()) {
            return true;
        }
        for (ProcessorType processorType : iCallingConvention.getProcessorTypes()) {
            if (!list.contains(processorType)) continue;
            return true;
        }
        return false;
    }
}

