/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankArm;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankArm64;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankMips;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankMips64;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankX64;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankX86;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionBuilder;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionName;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CallingConventionService {
    private static final ILogger logger = GlobalLog.getLogger(CallingConventionService.class);
    private static volatile CallingConventionService instance;
    private List<ICallingConvention> cclist = new ArrayList<ICallingConvention>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CallingConventionService getInstance() {
        if (instance != null) return instance;
        Class<CallingConventionService> clazz = CallingConventionService.class;
        synchronized (CallingConventionService.class) {
            CallingConventionService callingConventionService;
            if (instance != null) return instance;
            instance = callingConventionService = new CallingConventionService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CallingConventionService() {
        this.createStandardConventions();
    }

    private void createStandardConventions() {
        long l2 = RegisterBankX86.getInstance().getDescriptionEntryByName("eax").getId();
        long l3 = RegisterBankX86.getInstance().getDescriptionEntryByName("ecx").getId();
        long l4 = RegisterBankX86.getInstance().getDescriptionEntryByName("edx").getId();
        long l5 = RegisterBankX86.getInstance().getDescriptionEntryByName("esp").getId();
        long l6 = RegisterBankX86.getInstance().getDescriptionEntryByName("st(0)").getId();
        CallingConventionBuilder callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.CDECL, ProcessorType.X86).addSpoiledRegisters(l2, l3, l4).setReturnAddressSlot(StorageEntry.createStackSlot(0L)).addOutputSlot(StorageEntry.createRegister(l2)).addOutputRegisterPair(StorageEntry.createRegisterPair(l2, l4)).setOutputFpSlot(StorageEntry.createRegister(l6)).addInputSlot(StorageEntry.createStackSlot(1L)).addFlags(64).addFlags(4096).addFlags(256).setIPRD(3, null, null);
        this.add(callingConventionBuilder.build());
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.STDCALL, ProcessorType.X86).addFlags(1).addSpoiledRegisters(l2, l3, l4, l5).setReturnAddressSlot(StorageEntry.createStackSlot(0L)).addOutputSlot(StorageEntry.createRegister(l2)).addOutputRegisterPair(StorageEntry.createRegisterPair(l2, l4)).setOutputFpSlot(StorageEntry.createRegister(l6)).addInputSlot(StorageEntry.createStackSlot(1L)).addFlags(64).addFlags(4096).addFlags(256).setIPRD(3, null, null);
        this.add(callingConventionBuilder.build());
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.THISCALL, ProcessorType.X86).addFlags(1).addSpoiledRegisters(l2, l3, l4, l5).setReturnAddressSlot(StorageEntry.createStackSlot(0L)).addOutputSlot(StorageEntry.createRegister(l2)).addOutputRegisterPair(StorageEntry.createRegisterPair(l2, l4)).setOutputFpSlot(StorageEntry.createRegister(l6)).addInputSlot(StorageEntry.createRegister(l3)).addInputSlot(StorageEntry.createStackSlot(1L)).addFlags(64).addFlags(4096).addFlags(2048);
        this.add(callingConventionBuilder.build());
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.FASTCALL, ProcessorType.X86).addSubsystemType(SubsystemType.WINDOWS).addFlags(1).addSpoiledRegisters(l2, l3, l4).setReturnAddressSlot(StorageEntry.createStackSlot(0L)).addOutputSlot(StorageEntry.createRegister(l2)).addOutputRegisterPair(StorageEntry.createRegisterPair(l2, l4)).setOutputFpSlot(StorageEntry.createRegister(l6)).addInputSlot(StorageEntry.createRegister(l3)).addInputSlot(StorageEntry.createRegister(l4)).addInputSlot(StorageEntry.createStackSlot(1L)).addFlags(64).addFlags(4096).addFlags(256).setIPRD(3, StorageEntry.createStackSlot(1L), null);
        this.add(callingConventionBuilder.build());
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.FASTCALL, ProcessorType.X86).addSubsystemType(SubsystemType.LINUX).addFlags(1).addSpoiledRegisters(l2, l3, l4).setReturnAddressSlot(StorageEntry.createStackSlot(0L)).addOutputSlot(StorageEntry.createRegister(l2)).addOutputRegisterPair(StorageEntry.createRegisterPair(l2, l4)).setOutputFpSlot(StorageEntry.createRegister(l6)).addInputSlot(StorageEntry.createRegister(l3)).addInputSlot(StorageEntry.createRegister(l4)).addInputSlot(StorageEntry.createStackSlot(1L)).addFlags(64).addFlags(4096).addFlags(32768).addFlags(256).setIPRD(3, StorageEntry.createStackSlot(1L), null);
        this.add(callingConventionBuilder.build());
        callingConventionBuilder = new CallingConventionBuilder("__passthru", ProcessorType.X86).setReturnAddressSlot(StorageEntry.createStackSlot(0L));
        this.add(callingConventionBuilder.build());
        long l7 = RegisterBankX64.getInstance().getDescriptionEntryByName("rax").getId();
        long l8 = RegisterBankX64.getInstance().getDescriptionEntryByName("rcx").getId();
        long l9 = RegisterBankX64.getInstance().getDescriptionEntryByName("rdx").getId();
        long l10 = RegisterBankX64.getInstance().getDescriptionEntryByName("r8").getId();
        long l11 = RegisterBankX64.getInstance().getDescriptionEntryByName("r9").getId();
        long l12 = RegisterBankX64.getInstance().getDescriptionEntryByName("r10").getId();
        long l13 = RegisterBankX64.getInstance().getDescriptionEntryByName("r11").getId();
        long l14 = RegisterBankX64.getInstance().getDescriptionEntryByName("xmm0").getId();
        long l15 = RegisterBankX64.getInstance().getDescriptionEntryByName("xmm1").getId();
        long l16 = RegisterBankX64.getInstance().getDescriptionEntryByName("xmm2").getId();
        long l17 = RegisterBankX64.getInstance().getDescriptionEntryByName("xmm3").getId();
        long l18 = RegisterBankX64.getInstance().getDescriptionEntryByName("xmm4").getId();
        long l19 = RegisterBankX64.getInstance().getDescriptionEntryByName("xmm5").getId();
        long l20 = RegisterBankX64.getInstance().getDescriptionEntryByName("xmm6").getId();
        long l21 = RegisterBankX64.getInstance().getDescriptionEntryByName("xmm7").getId();
        long[] lArray = new long[8];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = RegisterBankX64.getInstance().getDescriptionEntryByName("xmm" + i).getId();
        }
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.STDCALL, ProcessorType.X86_64).addAlternateName(CallingConventionName.CDECL.toString()).addAlternateName(CallingConventionName.FASTCALL.toString()).addAlternateName(CallingConventionName.THISCALL.toString()).addSubsystemType(SubsystemType.WINDOWS).addSpoiledRegisters(l7, l8, l9, l10, l11, l12, l13).addSpoiledRegisters(lArray).setReturnAddressSlot(StorageEntry.createStackSlot(0L)).addOutputSlot(StorageEntry.createRegister(l7)).setOutputFpSlot(StorageEntry.createRegister(l14)).addInputSlot(StorageEntry.createRegister(l8)).addInputSlot(StorageEntry.createRegister(l9)).addInputSlot(StorageEntry.createRegister(l10)).addInputSlot(StorageEntry.createRegister(l11)).addInputSlot(StorageEntry.createStackSlot(5L)).addInputFpSlot(StorageEntry.createRegister(l14)).addInputFpSlot(StorageEntry.createRegister(l15)).addInputFpSlot(StorageEntry.createRegister(l16)).addInputFpSlot(StorageEntry.createRegister(l17)).addFlags(1024).addFlags(8192).addFlags(256).setIPRD(2, null, null);
        this.add(callingConventionBuilder.build());
        long l22 = RegisterBankX64.getInstance().getDescriptionEntryByName("rsi").getId();
        long l23 = RegisterBankX64.getInstance().getDescriptionEntryByName("rdi").getId();
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.CDECL, ProcessorType.X86_64).addAlternateName(CallingConventionName.SYSVAMD64.toString()).addSubsystemType(SubsystemType.LINUX).addSpoiledRegisters(l7, l8, l9, l22, l23, l10, l11, l12, l13).addSpoiledRegisters(lArray).setReturnAddressSlot(StorageEntry.createStackSlot(0L)).addOutputSlot(StorageEntry.createRegister(l7)).addOutputRegisterPair(StorageEntry.createRegisterPair(l7, l9)).setOutputFpSlot(StorageEntry.createRegister(l14)).addInputSlot(StorageEntry.createRegister(l23)).addInputSlot(StorageEntry.createRegister(l22)).addInputSlot(StorageEntry.createRegister(l9)).addInputSlot(StorageEntry.createRegister(l8)).addInputSlot(StorageEntry.createRegister(l10)).addInputSlot(StorageEntry.createRegister(l11)).addInputFpSlot(StorageEntry.createRegister(l14)).addInputFpSlot(StorageEntry.createRegister(l15)).addInputFpSlot(StorageEntry.createRegister(l16)).addInputFpSlot(StorageEntry.createRegister(l17)).addInputFpSlot(StorageEntry.createRegister(l18)).addInputFpSlot(StorageEntry.createRegister(l19)).addInputFpSlot(StorageEntry.createRegister(l20)).addInputFpSlot(StorageEntry.createRegister(l21)).addInputSlot(StorageEntry.createStackSlot(1L)).addInputRegisterPair(StorageEntry.createRegisterPair(l23, l22)).addInputRegisterPair(StorageEntry.createRegisterPair(l22, l9)).addInputRegisterPair(StorageEntry.createRegisterPair(l9, l8)).addInputRegisterPair(StorageEntry.createRegisterPair(l8, l10)).addInputRegisterPair(StorageEntry.createRegisterPair(l10, l11)).addFlags(256).setIPRD(3, null, null);
        this.add(callingConventionBuilder.build());
        long l24 = RegisterBankArm.getInstance().getDescriptionEntryByName("R0").getId();
        long l25 = RegisterBankArm.getInstance().getDescriptionEntryByName("R1").getId();
        long l26 = RegisterBankArm.getInstance().getDescriptionEntryByName("R2").getId();
        long l27 = RegisterBankArm.getInstance().getDescriptionEntryByName("R3").getId();
        long l28 = RegisterBankArm.getInstance().getDescriptionEntryByName("LR").getId();
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.CDECL, ProcessorType.ARM).addAlternateName(CallingConventionName.ARM_A32.toString()).addSpoiledRegisters(l24, l25, l26, l27).setReturnAddressSlot(StorageEntry.createRegister(l28)).addOutputSlot(StorageEntry.createRegister(l24)).addOutputRegisterPair(StorageEntry.createRegisterPairEndianDep(l24, l25)).addInputSlot(StorageEntry.createRegister(l24)).addInputSlot(StorageEntry.createRegister(l25)).addInputSlot(StorageEntry.createRegister(l26)).addInputSlot(StorageEntry.createRegister(l27)).addAlignementRequirement(2, 2).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l24, l25)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l26, l27)).addInputSlot(StorageEntry.createStackSlot(0L));
        this.add(callingConventionBuilder.build());
        long l29 = RegisterBankArm.getInstance().getDescriptionEntryByName("S0").getId();
        long l30 = RegisterBankArm.getInstance().getDescriptionEntryByName("S1").getId();
        long l31 = RegisterBankArm.getInstance().getDescriptionEntryByName("S2").getId();
        long l32 = RegisterBankArm.getInstance().getDescriptionEntryByName("S3").getId();
        callingConventionBuilder = callingConventionBuilder.duplicate().setName(CallingConventionName.ARM_A32_HF.name(), true).addInputFpSlot(StorageEntry.createRegister(l29)).addInputFpSlot(StorageEntry.createRegister(l30)).addInputFpSlot(StorageEntry.createRegister(l31)).addInputFpSlot(StorageEntry.createRegister(l32)).setOutputFpSlot(StorageEntry.createRegister(l29));
        this.add(callingConventionBuilder.build());
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.CDECL, ProcessorType.ARM).addAlternateName(CallingConventionName.STDCALL.toString()).addAlternateName(CallingConventionName.FASTCALL.toString()).addAlternateName(CallingConventionName.VECTORCALL.toString()).addSubsystemType(SubsystemType.WINDOWS).addSubsystemType(SubsystemType.WINDOWS_USER).addSubsystemType(SubsystemType.WINDOWS_KERNEL).addSpoiledRegisters(l24, l25, l26, l27).setReturnAddressSlot(StorageEntry.createRegister(l28)).addOutputSlot(StorageEntry.createRegister(l24)).addOutputRegisterPair(StorageEntry.createRegisterPairEndianDep(l24, l25)).addInputSlot(StorageEntry.createRegister(l24)).addInputSlot(StorageEntry.createRegister(l25)).addInputSlot(StorageEntry.createRegister(l26)).addInputSlot(StorageEntry.createRegister(l27)).addAlignementRequirement(2, 2).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l24, l25)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l26, l27)).addInputSlot(StorageEntry.createStackSlot(0L));
        this.add(callingConventionBuilder.build());
        callingConventionBuilder = callingConventionBuilder.duplicate().setName(CallingConventionName.ARM_A32_HF.name(), true).addInputFpSlot(StorageEntry.createRegister(l29)).addInputFpSlot(StorageEntry.createRegister(l30)).addInputFpSlot(StorageEntry.createRegister(l31)).addInputFpSlot(StorageEntry.createRegister(l32)).setOutputFpSlot(StorageEntry.createRegister(l29));
        this.add(callingConventionBuilder.build());
        long l33 = RegisterBankArm64.getInstance().getDescriptionEntryByName("X0").getId();
        long l34 = RegisterBankArm64.getInstance().getDescriptionEntryByName("X1").getId();
        long l35 = RegisterBankArm64.getInstance().getDescriptionEntryByName("X2").getId();
        long l36 = RegisterBankArm64.getInstance().getDescriptionEntryByName("X3").getId();
        long l37 = RegisterBankArm64.getInstance().getDescriptionEntryByName("X4").getId();
        long l38 = RegisterBankArm64.getInstance().getDescriptionEntryByName("X5").getId();
        long l39 = RegisterBankArm64.getInstance().getDescriptionEntryByName("X6").getId();
        long l40 = RegisterBankArm64.getInstance().getDescriptionEntryByName("X7").getId();
        long l41 = RegisterBankArm64.getInstance().getDescriptionEntryByName("X8").getId();
        long l42 = RegisterBankArm64.getInstance().getDescriptionEntryByName("X30").getId();
        long l43 = RegisterBankArm64.getInstance().getDescriptionEntryByName("V0").getId();
        long l44 = RegisterBankArm64.getInstance().getDescriptionEntryByName("V1").getId();
        long l45 = RegisterBankArm64.getInstance().getDescriptionEntryByName("V2").getId();
        long l46 = RegisterBankArm64.getInstance().getDescriptionEntryByName("V3").getId();
        long l47 = RegisterBankArm64.getInstance().getDescriptionEntryByName("V4").getId();
        long l48 = RegisterBankArm64.getInstance().getDescriptionEntryByName("V5").getId();
        long l49 = RegisterBankArm64.getInstance().getDescriptionEntryByName("V6").getId();
        long l50 = RegisterBankArm64.getInstance().getDescriptionEntryByName("V7").getId();
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.CDECL, ProcessorType.ARM64).addAlternateName(CallingConventionName.ARM_A64.toString()).addSpoiledRegisters(l33, l34, l35, l36, l37, l38, l39, l40).setReturnAddressSlot(StorageEntry.createRegister(l42)).addOutputSlot(StorageEntry.createRegister(l33)).addOutputRegisterPair(StorageEntry.createRegisterPairEndianDep(l33, l34)).addInputSlot(StorageEntry.createRegister(l33)).addInputSlot(StorageEntry.createRegister(l34)).addInputSlot(StorageEntry.createRegister(l35)).addInputSlot(StorageEntry.createRegister(l36)).addInputSlot(StorageEntry.createRegister(l37)).addInputSlot(StorageEntry.createRegister(l38)).addInputSlot(StorageEntry.createRegister(l39)).addInputSlot(StorageEntry.createRegister(l40)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l33, l34)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l34, l35)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l35, l36)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l36, l37)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l37, l38)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l38, l39)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l39, l40)).addInputSlot(StorageEntry.createStackSlot(0L)).addInputFpSlot(StorageEntry.createRegister(l43)).addInputFpSlot(StorageEntry.createRegister(l44)).addInputFpSlot(StorageEntry.createRegister(l45)).addInputFpSlot(StorageEntry.createRegister(l46)).addInputFpSlot(StorageEntry.createRegister(l47)).addInputFpSlot(StorageEntry.createRegister(l48)).addInputFpSlot(StorageEntry.createRegister(l49)).addInputFpSlot(StorageEntry.createRegister(l50)).setOutputFpSlot(StorageEntry.createRegister(l43)).addFlags(16384).addFlags(256).setIPRD(3, StorageEntry.createRegister(l41), null);
        this.add(callingConventionBuilder.build());
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.CDECL, ProcessorType.ARM64).addAlternateName(CallingConventionName.STDCALL.toString()).addAlternateName(CallingConventionName.FASTCALL.toString()).addAlternateName(CallingConventionName.VECTORCALL.toString()).addSubsystemType(SubsystemType.WINDOWS).addSubsystemType(SubsystemType.WINDOWS_USER).addSubsystemType(SubsystemType.WINDOWS_KERNEL).addSpoiledRegisters(l33, l34, l35, l36, l37, l38, l39, l40).setReturnAddressSlot(StorageEntry.createRegister(l42)).addOutputSlot(StorageEntry.createRegister(l33)).addOutputRegisterPair(StorageEntry.createRegisterPairEndianDep(l33, l34)).addInputSlot(StorageEntry.createRegister(l33)).addInputSlot(StorageEntry.createRegister(l34)).addInputSlot(StorageEntry.createRegister(l35)).addInputSlot(StorageEntry.createRegister(l36)).addInputSlot(StorageEntry.createRegister(l37)).addInputSlot(StorageEntry.createRegister(l38)).addInputSlot(StorageEntry.createRegister(l39)).addInputSlot(StorageEntry.createRegister(l40)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l33, l34)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l34, l35)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l35, l36)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l36, l37)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l37, l38)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l38, l39)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l39, l40)).addInputSlot(StorageEntry.createStackSlot(0L)).addInputFpSlot(StorageEntry.createRegister(l43)).addInputFpSlot(StorageEntry.createRegister(l44)).addInputFpSlot(StorageEntry.createRegister(l45)).addInputFpSlot(StorageEntry.createRegister(l46)).addInputFpSlot(StorageEntry.createRegister(l47)).addInputFpSlot(StorageEntry.createRegister(l48)).addInputFpSlot(StorageEntry.createRegister(l49)).addInputFpSlot(StorageEntry.createRegister(l50)).setOutputFpSlot(StorageEntry.createRegister(l43)).addFlags(16384).addFlags(256).setIPRD(3, StorageEntry.createRegister(l41), null);
        this.add(callingConventionBuilder.build());
        long l51 = RegisterBankMips.getInstance().getDescriptionEntryByName("$v0").getId();
        long l52 = RegisterBankMips.getInstance().getDescriptionEntryByName("$v1").getId();
        long l53 = RegisterBankMips.getInstance().getDescriptionEntryByName("$a0").getId();
        long l54 = RegisterBankMips.getInstance().getDescriptionEntryByName("$a1").getId();
        long l55 = RegisterBankMips.getInstance().getDescriptionEntryByName("$a2").getId();
        long l56 = RegisterBankMips.getInstance().getDescriptionEntryByName("$a3").getId();
        long l57 = RegisterBankMips.getInstance().getDescriptionEntryByName("$t0").getId();
        long l58 = RegisterBankMips.getInstance().getDescriptionEntryByName("$t1").getId();
        long l59 = RegisterBankMips.getInstance().getDescriptionEntryByName("$t2").getId();
        long l60 = RegisterBankMips.getInstance().getDescriptionEntryByName("$t3").getId();
        long l61 = RegisterBankMips.getInstance().getDescriptionEntryByName("$t4").getId();
        long l62 = RegisterBankMips.getInstance().getDescriptionEntryByName("$t5").getId();
        long l63 = RegisterBankMips.getInstance().getDescriptionEntryByName("$t6").getId();
        long l64 = RegisterBankMips.getInstance().getDescriptionEntryByName("$t7").getId();
        long l65 = RegisterBankMips.getInstance().getDescriptionEntryByName("$t8").getId();
        long l66 = RegisterBankMips.getInstance().getDescriptionEntryByName("$t9").getId();
        long l67 = RegisterBankMips.getInstance().getDescriptionEntryByName("$ra").getId();
        long l68 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f0").getId();
        long l69 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f1").getId();
        long l70 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f2").getId();
        long l71 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f3").getId();
        long l72 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f4").getId();
        long l73 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f5").getId();
        long l74 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f6").getId();
        long l75 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f7").getId();
        long l76 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f8").getId();
        long l77 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f9").getId();
        long l78 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f10").getId();
        long l79 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f11").getId();
        long l80 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f12").getId();
        long l81 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f13").getId();
        long l82 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f14").getId();
        long l83 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f15").getId();
        long l84 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f16").getId();
        long l85 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f17").getId();
        long l86 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f18").getId();
        long l87 = RegisterBankMips.getInstance().getDescriptionEntryByName("$f19").getId();
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.MIPS_O32, ProcessorType.MIPS).addSpoiledRegisters(l51, l52, l53, l54, l55, l56, l57, l58, l59, l60, l61, l62, l63, l64, l65, l66).addSpoiledRegisters(l68, l69, l70, l71, l72, l73, l74, l75, l76, l77, l78, l79, l80, l81, l82, l83, l84, l85, l86, l87).setReturnAddressSlot(StorageEntry.createRegister(l67)).addOutputSlot(StorageEntry.createRegister(l51)).addOutputRegisterPair(StorageEntry.createRegisterPairEndianDep(l51, l52)).addInputSlot(StorageEntry.createRegister(l53)).addInputSlot(StorageEntry.createRegister(l54)).addInputSlot(StorageEntry.createRegister(l55)).addInputSlot(StorageEntry.createRegister(l56)).setOutputFpSlot(StorageEntry.createRegister(l68)).addInputFpSlot(StorageEntry.createRegister(l80)).addInputFpSlot(StorageEntry.createRegister(l82)).addInputFpSlot(StorageEntry.createRegister(l55)).addInputFpSlot(StorageEntry.createRegister(l56)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l53, l54)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l55, l56)).addInputSlot(StorageEntry.createStackSlot(4L));
        this.add(callingConventionBuilder.build());
        long l88 = l57;
        long l89 = l58;
        long l90 = l59;
        long l91 = l60;
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.MIPS_N32, ProcessorType.MIPS).addSpoiledRegisters(l51, l52, l53, l54, l55, l56, l88, l89, l90, l91, l61, l62, l63, l64, l65, l66).addSpoiledRegisters(l68, l69, l70, l71, l72, l73, l74, l75, l76, l77, l78, l79, l80, l81, l82, l83, l84, l85, l86, l87).setReturnAddressSlot(StorageEntry.createRegister(l67)).addOutputSlot(StorageEntry.createRegister(l51)).addOutputRegisterPair(StorageEntry.createRegisterPairEndianDep(l51, l52)).addInputSlot(StorageEntry.createRegister(l53)).addInputSlot(StorageEntry.createRegister(l54)).addInputSlot(StorageEntry.createRegister(l55)).addInputSlot(StorageEntry.createRegister(l56)).addInputSlot(StorageEntry.createRegister(l88)).addInputSlot(StorageEntry.createRegister(l89)).addInputSlot(StorageEntry.createRegister(l90)).addInputSlot(StorageEntry.createRegister(l91)).setOutputFpSlot(StorageEntry.createRegister(l68)).addInputFpSlot(StorageEntry.createRegister(l80)).addInputFpSlot(StorageEntry.createRegister(l81)).addInputFpSlot(StorageEntry.createRegister(l82)).addInputFpSlot(StorageEntry.createRegister(l83)).addInputFpSlot(StorageEntry.createRegister(l84)).addInputFpSlot(StorageEntry.createRegister(l85)).addInputFpSlot(StorageEntry.createRegister(l86)).addInputFpSlot(StorageEntry.createRegister(l87)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l53, l54)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l55, l56)).addInputSlot(StorageEntry.createStackSlot(0L));
        this.add(callingConventionBuilder.build());
        long l92 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$v0").getId();
        long l93 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$v1").getId();
        long l94 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$a0").getId();
        long l95 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$a1").getId();
        long l96 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$a2").getId();
        long l97 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$a3").getId();
        long l98 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$a4").getId();
        long l99 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$a5").getId();
        long l100 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$a6").getId();
        long l101 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$a7").getId();
        long l102 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$t4").getId();
        long l103 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$t5").getId();
        long l104 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$t6").getId();
        long l105 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$t7").getId();
        long l106 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$t8").getId();
        long l107 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$t9").getId();
        long l108 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$ra").getId();
        long l109 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f0").getId();
        long l110 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f1").getId();
        long l111 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f2").getId();
        long l112 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f3").getId();
        long l113 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f4").getId();
        long l114 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f5").getId();
        long l115 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f6").getId();
        long l116 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f7").getId();
        long l117 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f8").getId();
        long l118 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f9").getId();
        long l119 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f10").getId();
        long l120 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f11").getId();
        long l121 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f12").getId();
        long l122 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f13").getId();
        long l123 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f14").getId();
        long l124 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f15").getId();
        long l125 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f16").getId();
        long l126 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f17").getId();
        long l127 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f18").getId();
        long l128 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f19").getId();
        long l129 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f20").getId();
        long l130 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f21").getId();
        long l131 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f22").getId();
        long l132 = RegisterBankMips64.getInstance().getDescriptionEntryByName("$f23").getId();
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.MIPS_N64, ProcessorType.MIPS64).addSpoiledRegisters(l92, l93, l94, l95, l96, l97, l98, l99, l100, l101, l102, l103, l104, l105, l106, l107).addSpoiledRegisters(l109, l110, l111, l112, l113, l114, l115, l116, l117, l118, l119, l120, l121, l122, l123, l124, l125, l126, l127, l128, l129, l130, l131, l132).setReturnAddressSlot(StorageEntry.createRegister(l108)).addOutputSlot(StorageEntry.createRegister(l92)).addOutputRegisterPair(StorageEntry.createRegisterPairEndianDep(l92, l93)).addInputSlot(StorageEntry.createRegister(l94)).addInputSlot(StorageEntry.createRegister(l95)).addInputSlot(StorageEntry.createRegister(l96)).addInputSlot(StorageEntry.createRegister(l97)).addInputSlot(StorageEntry.createRegister(l98)).addInputSlot(StorageEntry.createRegister(l99)).addInputSlot(StorageEntry.createRegister(l100)).addInputSlot(StorageEntry.createRegister(l101)).setOutputFpSlot(StorageEntry.createRegister(l109)).addInputFpSlot(StorageEntry.createRegister(l121)).addInputFpSlot(StorageEntry.createRegister(l122)).addInputFpSlot(StorageEntry.createRegister(l123)).addInputFpSlot(StorageEntry.createRegister(l124)).addInputFpSlot(StorageEntry.createRegister(l125)).addInputFpSlot(StorageEntry.createRegister(l126)).addInputFpSlot(StorageEntry.createRegister(l127)).addInputFpSlot(StorageEntry.createRegister(l128)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l94, l95)).addInputRegisterPair(StorageEntry.createRegisterPairEndianDep(l96, l97)).addInputSlot(StorageEntry.createStackSlot(0L));
        this.add(callingConventionBuilder.build());
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.CDECL, ProcessorType.AVR).setReturnAddressSlot(StorageEntry.createStackSlot(0L)).addInputSlot(StorageEntry.createRegister(24L)).addInputRegisterPair(StorageEntry.createRegisterPair(24L, 25L)).addInputSlot(StorageEntry.createRegister(22L)).addInputRegisterPair(StorageEntry.createRegisterPair(22L, 23L)).addInputSlot(StorageEntry.createRegister(20L)).addInputRegisterPair(StorageEntry.createRegisterPair(20L, 21L)).addInputSlot(StorageEntry.createRegister(18L)).addInputRegisterPair(StorageEntry.createRegisterPair(18L, 19L)).addInputSlot(StorageEntry.createStackSlot(1L)).addOutputSlot(StorageEntry.createRegister(24L)).addOutputRegisterPair(StorageEntry.createRegisterPair(24L, 25L));
        this.add(callingConventionBuilder.build());
        callingConventionBuilder = new CallingConventionBuilder("__godecl", ProcessorType.UNKNOWN).setReturnAddressSlot(StorageEntry.createStackSlot(0L)).addInputSlot(StorageEntry.createStackSlot(1L)).addOutputSlot(StorageEntry.createStackSlot(1L)).addFlags(32);
        this.add(callingConventionBuilder.build());
        callingConventionBuilder = new CallingConventionBuilder(CallingConventionName.UNKNOWN, ProcessorType.UNKNOWN).addFlags(1);
        this.add(callingConventionBuilder.build());
        if (Licensing.isReleaseBuild()) {
            return;
        }
    }

    private void add(ICallingConvention iCallingConvention) {
        if (!this.addConvention(iCallingConvention)) {
            throw new RuntimeException("CC collision!");
        }
        ICallingConvention iCallingConvention2 = iCallingConvention.getIPRDConvention();
        if (iCallingConvention2 != null) {
            this.addConvention(iCallingConvention2);
        }
    }

    public List<ICallingConvention> getConventions() {
        return Collections.unmodifiableList(this.cclist);
    }

    public boolean addConvention(ICallingConvention iCallingConvention) {
        if (iCallingConvention == null) {
            throw new IllegalArgumentException();
        }
        long l2 = iCallingConvention.getIdentifierKey();
        for (ICallingConvention iCallingConvention2 : this.cclist) {
            if (iCallingConvention2.getIdentifierKey() != l2) continue;
            logger.error("Calling convention cannot be registered: %s. It collides with: %s.", iCallingConvention, iCallingConvention2);
            return false;
        }
        this.cclist.add(iCallingConvention);
        return true;
    }

    public boolean removeConvention(ICallingConvention iCallingConvention) {
        if (iCallingConvention == null) {
            throw new IllegalArgumentException();
        }
        return this.cclist.remove(iCallingConvention);
    }

    public String toString() {
        return Strings.ff("ccsvc(%d)", this.cclist.size());
    }
}

