/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionName;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.core.units.codeobject.CompilerType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CallingConventionBuilder {
    int flags;
    String notes;
    String name;
    List<String> altnames = new ArrayList<String>();
    List<ProcessorType> proctypes = new ArrayList<ProcessorType>();
    List<SubsystemType> sstypes = new ArrayList<SubsystemType>();
    List<CompilerType> comptypes = new ArrayList<CompilerType>();
    List<Long> spoiledRegisters = new ArrayList<Long>();
    StorageEntry retAddrEntry;
    List<StorageEntry> inEntries = new ArrayList<StorageEntry>();
    List<StorageEntry> inRegPairs = new ArrayList<StorageEntry>();
    List<StorageEntry> inFpEntries = new ArrayList<StorageEntry>();
    List<StorageEntry> outEntries = new ArrayList<StorageEntry>();
    List<StorageEntry> outRegPairs = new ArrayList<StorageEntry>();
    StorageEntry outFpEntry;
    int iprdSlotcnt;
    StorageEntry iprdInputPtrEntry;
    StorageEntry iprdOutputPtrEntry;
    Map<Integer, Integer> slotcountAlignmentMap = new HashMap<Integer, Integer>();
    private boolean built;

    private CallingConventionBuilder() {
    }

    public CallingConventionBuilder duplicate() {
        CallingConventionBuilder callingConventionBuilder = new CallingConventionBuilder();
        callingConventionBuilder.flags = this.flags;
        callingConventionBuilder.notes = this.notes;
        callingConventionBuilder.name = this.name;
        callingConventionBuilder.altnames.addAll(this.altnames);
        callingConventionBuilder.proctypes.addAll(this.proctypes);
        callingConventionBuilder.sstypes.addAll(this.sstypes);
        callingConventionBuilder.comptypes.addAll(this.comptypes);
        callingConventionBuilder.spoiledRegisters.addAll(this.spoiledRegisters);
        callingConventionBuilder.retAddrEntry = this.retAddrEntry;
        callingConventionBuilder.inEntries.addAll(this.inEntries);
        callingConventionBuilder.inRegPairs.addAll(this.inRegPairs);
        callingConventionBuilder.inFpEntries.addAll(this.inFpEntries);
        callingConventionBuilder.outEntries.addAll(this.outEntries);
        callingConventionBuilder.outRegPairs.addAll(this.outRegPairs);
        callingConventionBuilder.outFpEntry = this.outFpEntry;
        callingConventionBuilder.slotcountAlignmentMap.putAll(this.slotcountAlignmentMap);
        return callingConventionBuilder;
    }

    public CallingConventionBuilder(String string) {
        this.setName(string);
    }

    public CallingConventionBuilder(String string, ProcessorType processorType) {
        this.setName(string);
        this.addProcessorType(processorType);
    }

    public CallingConventionBuilder(CallingConventionName callingConventionName, ProcessorType processorType) {
        this(callingConventionName.toString(), processorType);
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public CallingConventionBuilder setFlags(int n2) {
        this.flags = n2;
        return this;
    }

    public CallingConventionBuilder addFlags(int n2) {
        this.flags |= n2;
        return this;
    }

    public CallingConventionBuilder setName(String string) {
        return this.setName(string, false);
    }

    public CallingConventionBuilder setName(String string, boolean bl) {
        this.name = string;
        if (bl) {
            this.altnames.clear();
        }
        return this;
    }

    public CallingConventionBuilder setAlternateNames(Collection<String> collection) {
        if (collection != null) {
            this.altnames.clear();
            this.altnames.addAll(collection);
        }
        return this;
    }

    public CallingConventionBuilder addAlternateName(String string) {
        if (string != null && !this.altnames.contains(string)) {
            this.altnames.add(string);
        }
        return this;
    }

    public CallingConventionBuilder addAlternateNames(Collection<String> collection) {
        if (collection != null) {
            for (String string : collection) {
                this.addAlternateName(string);
            }
        }
        return this;
    }

    public CallingConventionBuilder setProcessorTypes(Collection<ProcessorType> collection) {
        if (collection != null) {
            this.proctypes.clear();
            this.proctypes.addAll(collection);
        }
        return this;
    }

    public CallingConventionBuilder addProcessorType(ProcessorType processorType) {
        if (processorType != null && !this.proctypes.contains(processorType)) {
            this.proctypes.add(processorType);
        }
        return this;
    }

    public CallingConventionBuilder addSubsystemType(SubsystemType subsystemType) {
        if (subsystemType != null && !this.sstypes.contains(subsystemType)) {
            this.sstypes.add(subsystemType);
        }
        return this;
    }

    public CallingConventionBuilder addCompilerType(CompilerType compilerType) {
        if (compilerType != null && !this.comptypes.contains(compilerType)) {
            this.comptypes.add(compilerType);
        }
        return this;
    }

    public CallingConventionBuilder addSpoiledRegister(long l2) {
        if (!this.spoiledRegisters.contains(l2)) {
            this.spoiledRegisters.add(l2);
        }
        return this;
    }

    public CallingConventionBuilder addSpoiledRegisters(long ... lArray) {
        for (long l2 : lArray) {
            this.addSpoiledRegister(l2);
        }
        return this;
    }

    public CallingConventionBuilder addSpoiledRegisters(Collection<StorageEntry> collection) {
        if (collection != null) {
            for (StorageEntry storageEntry : collection) {
                if (storageEntry.getType() != StorageEntry.Type.REGISTER) continue;
                this.addSpoiledRegister(storageEntry.getValue());
            }
        }
        return this;
    }

    public CallingConventionBuilder setReturnAddressSlot(StorageEntry storageEntry) {
        this.retAddrEntry = storageEntry;
        return this;
    }

    public CallingConventionBuilder addOutputSlot(StorageEntry storageEntry) {
        this.outEntries.add(storageEntry);
        return this;
    }

    public CallingConventionBuilder addOutputSlots(Collection<StorageEntry> collection) {
        if (collection != null) {
            this.outEntries.addAll(collection);
        }
        return this;
    }

    public CallingConventionBuilder addInputSlot(StorageEntry storageEntry) {
        this.inEntries.add(storageEntry);
        return this;
    }

    public CallingConventionBuilder addInputSlots(Collection<StorageEntry> collection) {
        this.inEntries.addAll(collection);
        return this;
    }

    public CallingConventionBuilder addInputFpSlot(StorageEntry storageEntry) {
        this.inFpEntries.add(storageEntry);
        return this;
    }

    public CallingConventionBuilder addInputFpSlots(Collection<StorageEntry> collection) {
        if (collection != null) {
            for (StorageEntry storageEntry : collection) {
                this.addInputFpSlot(storageEntry);
            }
        }
        return this;
    }

    public CallingConventionBuilder addOutputRegisterPair(StorageEntry storageEntry) {
        if (storageEntry.getType() != StorageEntry.Type.REGISTER_PAIR) {
            throw new IllegalArgumentException("Expected a register pair slot, got " + storageEntry);
        }
        this.outRegPairs.add(storageEntry);
        return this;
    }

    public CallingConventionBuilder addOutputRegisterPairs(Collection<StorageEntry> collection) {
        if (collection != null) {
            for (StorageEntry storageEntry : collection) {
                this.addOutputRegisterPair(storageEntry);
            }
        }
        return this;
    }

    public CallingConventionBuilder addInputRegisterPair(StorageEntry storageEntry) {
        if (storageEntry.getType() != StorageEntry.Type.REGISTER_PAIR) {
            throw new IllegalArgumentException("Expected a register pair slot, got " + storageEntry);
        }
        this.inRegPairs.add(storageEntry);
        return this;
    }

    public CallingConventionBuilder addInputRegisterPairs(Collection<StorageEntry> collection) {
        if (collection != null) {
            for (StorageEntry storageEntry : collection) {
                this.addInputRegisterPair(storageEntry);
            }
        }
        return this;
    }

    public CallingConventionBuilder setOutputFpSlot(StorageEntry storageEntry) {
        this.outFpEntry = storageEntry;
        return this;
    }

    public CallingConventionBuilder setIPRD(int n2, StorageEntry storageEntry, StorageEntry storageEntry2) {
        this.iprdSlotcnt = n2;
        this.iprdInputPtrEntry = storageEntry;
        this.iprdOutputPtrEntry = storageEntry2;
        return this;
    }

    public CallingConventionBuilder addAlignementRequirement(int n2, int n3) {
        this.slotcountAlignmentMap.put(n2, n3);
        return this;
    }

    public ICallingConvention build() {
        if (this.built) {
            throw new IllegalStateException();
        }
        this.built = true;
        CallingConvention callingConvention = new CallingConvention();
        callingConvention.flags = this.flags;
        callingConvention.notes = this.notes;
        callingConvention.name = this.name;
        callingConvention.altnames = this.altnames;
        callingConvention.proctypes = this.proctypes;
        callingConvention.sstypes = this.sstypes;
        callingConvention.comptypes = this.comptypes;
        callingConvention.spoiledRegisters = this.spoiledRegisters;
        callingConvention.retAddrEntry = this.retAddrEntry;
        callingConvention.inEntries = this.inEntries;
        callingConvention.outEntries = this.outEntries;
        callingConvention.inRegPairs = this.inRegPairs;
        callingConvention.outRegPairs = this.outRegPairs;
        callingConvention.inFpEntries = this.inFpEntries;
        callingConvention.outFpEntry = this.outFpEntry;
        callingConvention.slotcountAlignmentMap = this.slotcountAlignmentMap;
        callingConvention.iprdSlotcnt = this.iprdSlotcnt;
        callingConvention.iprdInputPtrEntry = this.iprdInputPtrEntry;
        callingConvention.iprdOutputPtrEntry = this.iprdOutputPtrEntry;
        if ((callingConvention.flags & 0x100) != 0) {
            CallingConvention callingConvention2 = callingConvention.clone();
            callingConvention2.name = callingConvention2.name + "_iprd";
            callingConvention2.altnames.clear();
            callingConvention2.flags &= 0xFFFFFEFF;
            callingConvention2.iprdSlotcnt = 0;
            callingConvention2.iprdConvention = null;
            if (callingConvention2.iprdInputPtrEntry != null) {
                callingConvention2.inEntries.add(0, callingConvention2.iprdInputPtrEntry);
                callingConvention2.iprdInputPtrEntry = null;
            }
            if (callingConvention2.iprdOutputPtrEntry != null) {
                callingConvention2.outEntries.add(0, callingConvention2.iprdOutputPtrEntry);
                callingConvention2.iprdOutputPtrEntry = null;
            }
            callingConvention2.outFpEntry = null;
            callingConvention2.outRegPairs.clear();
            callingConvention2.outRegQuads.clear();
            callingConvention.iprdConvention = callingConvention2;
        }
        return callingConvention;
    }
}

