/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionName;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStorageEntryGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLayoutInfo;
import com.pnfsoftware.jeb.core.units.codeobject.CompilerType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.util.collect.CollectionUtil;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jebglobal.adw;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Ser
public class CallingConvention
implements ICallingConvention {
    @SerId(value=1)
    String name;
    @SerId(value=2)
    List<String> altnames = new ArrayList<String>();
    @SerId(value=3)
    int flags;
    @SerId(value=4)
    List<ProcessorType> proctypes = new ArrayList<ProcessorType>();
    @SerId(value=5)
    List<SubsystemType> sstypes = new ArrayList<SubsystemType>();
    @SerId(value=6)
    List<CompilerType> comptypes = new ArrayList<CompilerType>();
    @SerId(value=7)
    List<Long> spoiledRegisters;
    @SerId(value=8)
    List<Long> savedRegisters;
    @SerId(value=9)
    StorageEntry retAddrEntry;
    @SerId(value=10)
    List<StorageEntry> outEntries = new ArrayList<StorageEntry>();
    @SerId(value=11)
    List<StorageEntry> inEntries = new ArrayList<StorageEntry>();
    @SerId(value=12)
    List<StorageEntry> outRegPairs = new ArrayList<StorageEntry>();
    @SerId(value=13)
    List<StorageEntry> inRegPairs = new ArrayList<StorageEntry>();
    @SerId(value=14)
    StorageEntry outFpEntry;
    @SerId(value=15)
    List<StorageEntry> inFpEntries = new ArrayList<StorageEntry>();
    @SerId(value=16)
    String notes;
    @SerId(value=17)
    Map<Integer, Integer> slotcountAlignmentMap = new HashMap<Integer, Integer>();
    @SerId(value=18)
    List<StorageEntry> outRegQuads = new ArrayList<StorageEntry>();
    @SerId(value=19)
    List<StorageEntry> inRegQuads = new ArrayList<StorageEntry>();
    @SerId(value=21)
    int iprdSlotcnt;
    @SerId(value=22)
    StorageEntry iprdInputPtrEntry;
    @SerId(value=23)
    StorageEntry iprdOutputPtrEntry;
    @SerId(value=24)
    CallingConvention iprdConvention;
    @SerTransient
    private volatile Set<Long> allSpoiledRegisters;
    @SerTransient
    private volatile Set<Long> pureSpoiledRegisters;
    @SerTransient
    private Long key;

    public CallingConvention clone() {
        CallingConvention callingConvention = new CallingConvention();
        callingConvention.name = this.name;
        callingConvention.altnames.addAll(this.altnames);
        callingConvention.flags = this.flags;
        callingConvention.proctypes.addAll(this.proctypes);
        callingConvention.sstypes.addAll(this.sstypes);
        callingConvention.comptypes.addAll(this.comptypes);
        if (this.spoiledRegisters != null) {
            callingConvention.spoiledRegisters = new ArrayList<Long>(this.spoiledRegisters);
        }
        if (this.savedRegisters != null) {
            callingConvention.savedRegisters = new ArrayList<Long>(this.savedRegisters);
        }
        callingConvention.retAddrEntry = this.retAddrEntry;
        callingConvention.outEntries.addAll(this.outEntries);
        callingConvention.inEntries.addAll(this.inEntries);
        callingConvention.outRegPairs.addAll(this.outRegPairs);
        callingConvention.inRegPairs.addAll(this.inRegPairs);
        callingConvention.outFpEntry = this.outFpEntry;
        callingConvention.inFpEntries.addAll(this.inFpEntries);
        callingConvention.notes = this.notes;
        callingConvention.slotcountAlignmentMap.putAll(this.slotcountAlignmentMap);
        callingConvention.outRegQuads.addAll(this.outRegQuads);
        callingConvention.inRegQuads.addAll(this.inRegQuads);
        callingConvention.iprdSlotcnt = this.iprdSlotcnt;
        callingConvention.iprdInputPtrEntry = this.iprdInputPtrEntry;
        callingConvention.iprdOutputPtrEntry = this.iprdOutputPtrEntry;
        callingConvention.iprdConvention = this.iprdConvention;
        return callingConvention;
    }

    @Override
    public long getIdentifierKey() {
        if (this.key == null) {
            String string = this.getName() + Strings.joinList(this.getAlternateNames()) + this.getFlags() + Strings.joinList(this.getProcessorTypes()) + Strings.joinList(this.getSubsystemTypes()) + Strings.joinList(this.getCompilerTypes());
            byte[] byArray = Hash.calculateMD5(Strings.encodeUTF8(string));
            this.key = EndianUtil.bytesToLong(byArray, 0, ByteOrder.LITTLE_ENDIAN);
        }
        return this.key;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public boolean hasFlag(int n2) {
        return (this.flags & n2) == n2;
    }

    @Override
    public boolean isUnknown() {
        return CallingConventionName.UNKNOWN.toString().equals(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getAlternateNames() {
        return Collections.unmodifiableList(this.altnames);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> arrayList = new ArrayList<String>(1 + this.altnames.size());
        if (this.name != null) {
            arrayList.add(this.name);
        }
        arrayList.addAll(this.altnames);
        return Collections.unmodifiableList(arrayList);
    }

    public ProcessorType getPrimaryProcessorType() {
        return this.proctypes.isEmpty() ? null : this.proctypes.get(0);
    }

    @Override
    public List<ProcessorType> getProcessorTypes() {
        return Collections.unmodifiableList(this.proctypes);
    }

    @Override
    public List<SubsystemType> getSubsystemTypes() {
        return Collections.unmodifiableList(this.sstypes);
    }

    @Override
    public List<CompilerType> getCompilerTypes() {
        return Collections.unmodifiableList(this.comptypes);
    }

    @Override
    public boolean isCompatibleWith(ProcessorType processorType, SubsystemType subsystemType, CompilerType compilerType) {
        if ((processorType.isARM() || processorType.isIntel()) && subsystemType == SubsystemType.UNKNOWN) {
            subsystemType = SubsystemType.LINUX;
        }
        boolean bl = false;
        for (ProcessorType dynamicEnum : this.proctypes) {
            if (dynamicEnum != ProcessorType.UNKNOWN && dynamicEnum != processorType) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        if (!this.sstypes.isEmpty()) {
            bl = false;
            for (SubsystemType subsystemType2 : this.sstypes) {
                if (subsystemType2 != SubsystemType.UNKNOWN && !subsystemType2.isCompatibleWith(subsystemType)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        if (!this.comptypes.isEmpty()) {
            bl = false;
            for (CompilerType compilerType2 : this.comptypes) {
                if (compilerType2 != CompilerType.UNKNOWN && !compilerType2.isCompatibleWith(compilerType)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Collection<Long> getSpoiledRegisters() {
        if (this.allSpoiledRegisters == null) {
            CallingConvention callingConvention = this;
            synchronized (callingConvention) {
                if (this.allSpoiledRegisters == null) {
                    HashSet<Long> hashSet = new HashSet<Long>(this.spoiledRegisters);
                    if (this.retAddrEntry != null && this.retAddrEntry.isRegisterBased()) {
                        hashSet.addAll(this.retAddrEntry.getRegisters());
                    }
                    for (StorageEntry storageEntry : this.outEntries) {
                        if (!storageEntry.isRegisterBased()) continue;
                        hashSet.addAll(storageEntry.getRegisters());
                    }
                    for (StorageEntry storageEntry : this.outRegPairs) {
                        if (!storageEntry.isRegisterBased()) continue;
                        hashSet.addAll(storageEntry.getRegisters());
                    }
                    for (StorageEntry storageEntry : this.outRegQuads) {
                        if (!storageEntry.isRegisterBased()) continue;
                        hashSet.addAll(storageEntry.getRegisters());
                    }
                    if (this.outFpEntry != null && this.outFpEntry.isRegisterBased()) {
                        hashSet.addAll(this.outFpEntry.getRegisters());
                    }
                    this.allSpoiledRegisters = hashSet;
                }
            }
        }
        return Collections.unmodifiableCollection(this.allSpoiledRegisters);
    }

    @Override
    public Collection<Long> getPureSpoiledRegisters() {
        if (this.pureSpoiledRegisters == null) {
            CallingConvention callingConvention = this;
            synchronized (callingConvention) {
                if (this.pureSpoiledRegisters == null) {
                    HashSet<Long> hashSet = new HashSet<Long>(this.spoiledRegisters);
                    if (this.retAddrEntry != null && this.retAddrEntry.isRegisterBased()) {
                        hashSet.removeAll(this.retAddrEntry.getRegisters());
                    }
                    for (StorageEntry storageEntry : this.outEntries) {
                        if (!storageEntry.isRegisterBased()) continue;
                        hashSet.removeAll(storageEntry.getRegisters());
                    }
                    for (StorageEntry storageEntry : this.outRegPairs) {
                        if (!storageEntry.isRegisterBased()) continue;
                        hashSet.removeAll(storageEntry.getRegisters());
                    }
                    for (StorageEntry storageEntry : this.outRegQuads) {
                        if (!storageEntry.isRegisterBased()) continue;
                        hashSet.removeAll(storageEntry.getRegisters());
                    }
                    if (this.outFpEntry != null && this.outFpEntry.isRegisterBased()) {
                        hashSet.removeAll(this.outFpEntry.getRegisters());
                    }
                    this.pureSpoiledRegisters = hashSet;
                }
            }
        }
        return Collections.unmodifiableCollection(this.pureSpoiledRegisters);
    }

    @Override
    public StorageEntry getReturnAddressSlot() {
        return this.getReturnAddressSlot(null);
    }

    @Override
    public StorageEntry getReturnAddressSlot(Integer n2) {
        if (this.hasFlag(128)) {
            if (n2 == null) {
                n2 = 0;
            }
            return StorageEntry.createStackSlot(n2.intValue());
        }
        return this.retAddrEntry;
    }

    StorageEntry getOutputSlotByIndex(int n2) {
        return this.getSlotByIndex(this.outEntries, n2);
    }

    StorageEntry getOutputDualSlot() {
        if (this.outRegPairs.isEmpty()) {
            return null;
        }
        return this.outRegPairs.get(0);
    }

    private StorageEntry getStackParamBegin() {
        if (this.inEntries.isEmpty()) {
            return null;
        }
        StorageEntry storageEntry = this.inEntries.get(this.inEntries.size() - 1);
        if (!storageEntry.isStackBased()) {
            return null;
        }
        return storageEntry;
    }

    private StorageEntry getStackParamBegin(int n2) {
        StorageEntry storageEntry = this.getStackParamBegin();
        if (storageEntry == null) {
            return null;
        }
        return storageEntry.withCount(n2);
    }

    @Override
    public StorageEntry getOutput(TypeLayoutInfo typeLayoutInfo, int n2) {
        return this.getOutputsGenerator(n2).next(typeLayoutInfo);
    }

    private StorageEntry getSlotByIndex(List<StorageEntry> list, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid slot index: " + n2);
        }
        if (n2 < list.size()) {
            return list.get(n2);
        }
        int n3 = list.size() - 1;
        if (n3 < 0) {
            return null;
        }
        StorageEntry storageEntry = list.get(n3);
        if (storageEntry.getType() == StorageEntry.Type.STACK) {
            return StorageEntry.createStackSlot(storageEntry.getValue() + (long)n2 - (long)n3);
        }
        return null;
    }

    @Override
    public int getInputSlotCountHint() {
        return this.inEntries.size();
    }

    @Override
    public int getOutputSlotCountHint() {
        return this.outEntries.size();
    }

    @Override
    public Map<Integer, Integer> getSlotcountAlignmentMap() {
        return this.slotcountAlignmentMap;
    }

    @Override
    public int determineSlotcountAlignment(int n2) {
        if (n2 <= 1 || this.slotcountAlignmentMap == null || this.slotcountAlignmentMap.isEmpty()) {
            return 1;
        }
        Integer n3 = this.slotcountAlignmentMap.get(n2);
        if (n3 == null && (n3 = this.slotcountAlignmentMap.get(0)) == null) {
            n3 = 1;
        }
        return n3;
    }

    @Override
    public int getIPRDMinimumSlotCount() {
        return this.iprdSlotcnt;
    }

    @Override
    public StorageEntry getIPRDInputPtrEntry() {
        return this.iprdInputPtrEntry;
    }

    @Override
    public StorageEntry getIPRDOutputPtrEntry() {
        return this.iprdOutputPtrEntry;
    }

    @Override
    public ICallingConvention getIPRDConvention() {
        return this.iprdConvention;
    }

    public String toString() {
        return this.format(0);
    }

    @Override
    public String format(int n2) {
        if (n2 == 1) {
            return this.formatUser();
        }
        if (n2 == 2) {
            return this.formatParseable();
        }
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        if (!this.getAlternateNames().isEmpty()) {
            Strings.ff(stringBuilder, "(%s)", Strings.join(",", this.getAlternateNames()));
        }
        if (!this.getProcessorTypes().isEmpty()) {
            Strings.ff(stringBuilder, ",procs:%s", Strings.join(",", this.getProcessorTypes()));
        }
        if (!this.getSubsystemTypes().isEmpty()) {
            Strings.ff(stringBuilder, ",subs:%s", Strings.join(",", this.getSubsystemTypes()));
        }
        if (!this.getCompilerTypes().isEmpty()) {
            Strings.ff(stringBuilder, ",comps:%s", Strings.join(",", this.getCompilerTypes()));
        }
        return stringBuilder.toString();
    }

    public String formatParseable() {
        IRegisterBank iRegisterBank;
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getNotes();
        if (string != null) {
            Strings.ff(stringBuilder, "notes: %s\n", string);
        }
        if (this.getAlternateNames().isEmpty()) {
            Strings.ff(stringBuilder, "name: %s\n", Strings.safe(this.getName()));
        } else {
            Strings.ff(stringBuilder, "names: %s\n", Strings.joinList(this.getNames()));
        }
        Strings.ff(stringBuilder, "processors: %s\n", Strings.joinList(this.getProcessorTypes()));
        Strings.ff(stringBuilder, "subsystems: %s\n", Strings.joinList(this.getSubsystemTypes()));
        Strings.ff(stringBuilder, "compilers: %s\n", Strings.joinList(this.getCompilerTypes()));
        if (this.getFlags() != 0) {
            Strings.ff(stringBuilder, "flags: [", new Object[0]);
            this.formatFlags(stringBuilder, ",");
            Strings.ff(stringBuilder, "]\n", new Object[0]);
        }
        if ((iRegisterBank = RegisterUtil.getBank(this.proctypes.get(0))) == null) {
            Strings.ff(stringBuilder, "\n! cannot format registers information\n", new Object[0]);
        } else {
            Strings.ff(stringBuilder, "\nspoiled_registers: %s\n", Strings.joinList(this.spoiledRegisters.stream().map(l2 -> iRegisterBank.getDescriptionEntryById((long)l2).getName()).collect(Collectors.toList())));
            if (this.getReturnAddressSlot() != null) {
                Strings.ff(stringBuilder, "return_address_location: %s\n", this.getReturnAddressSlot().formatParseable(iRegisterBank));
            }
            Strings.ff(stringBuilder, "\ninputs: %s\n", Strings.joinList(this.inEntries.stream().map(storageEntry -> storageEntry.formatParseable(iRegisterBank)).collect(Collectors.toList())));
            Strings.ff(stringBuilder, "outputs: %s\n", Strings.joinList(this.outEntries.stream().map(storageEntry -> storageEntry.formatParseable(iRegisterBank)).collect(Collectors.toList())));
            Strings.ff(stringBuilder, "\ninput_pairs: %s\n", Strings.joinList(this.inRegPairs.stream().map(storageEntry -> storageEntry.formatParseable(iRegisterBank)).collect(Collectors.toList())));
            Strings.ff(stringBuilder, "output_pairs: %s\n", Strings.joinList(this.outRegPairs.stream().map(storageEntry -> storageEntry.formatParseable(iRegisterBank)).collect(Collectors.toList())));
            Strings.ff(stringBuilder, "\ninput_floats: %s\n", Strings.joinList(this.inFpEntries.stream().map(storageEntry -> storageEntry.formatParseable(iRegisterBank)).collect(Collectors.toList())));
            Strings.ff(stringBuilder, "output_float: %s\n", this.outFpEntry == null ? "" : this.outFpEntry.formatParseable(iRegisterBank));
            Strings.ff(stringBuilder, "\nalignments: %s\n", this.slotcountAlignmentMap);
        }
        return stringBuilder.toString();
    }

    public String formatUser() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getNotes();
        if (string != null) {
            Strings.ff(stringBuilder, "Notes      : %s\n", string);
        }
        Strings.ff(stringBuilder, "Names      : %s\n", Strings.join(",", this.getNames()));
        if (!this.getProcessorTypes().isEmpty()) {
            Strings.ff(stringBuilder, "Processors : %s\n", Strings.join(",", this.getProcessorTypes()));
        }
        if (!this.getSubsystemTypes().isEmpty()) {
            Strings.ff(stringBuilder, "Subsystem  : %s\n", Strings.join(",", this.getSubsystemTypes()));
        }
        if (!this.getCompilerTypes().isEmpty()) {
            Strings.ff(stringBuilder, "Compiler   : %s\n", Strings.join(",", this.getCompilerTypes()));
        }
        if (this.getFlags() != 0) {
            Strings.ff(stringBuilder, "Flags      : ", new Object[0]);
            this.formatFlags(stringBuilder, " ");
            Strings.ff(stringBuilder, "\n", new Object[0]);
        }
        Strings.ff(stringBuilder, "\n", new Object[0]);
        IRegisterBank iRegisterBank = RegisterUtil.getBank(this.proctypes.get(0));
        if (iRegisterBank == null) {
            Strings.ff(stringBuilder, "\n! cannot format registers information\n", new Object[0]);
        } else {
            if (!this.spoiledRegisters.isEmpty()) {
                Strings.ff(stringBuilder, "Spoiled registers:\n  ", new Object[0]);
                for (long l2 : this.spoiledRegisters) {
                    Strings.ff(stringBuilder, "%s ", iRegisterBank.getDescriptionEntryById(l2).getName());
                }
                Strings.ff(stringBuilder, "\n", new Object[0]);
            }
            Strings.ff(stringBuilder, "\n", new Object[0]);
            if (this.getReturnAddressSlot() != null) {
                Strings.ff(stringBuilder, "Return address location:\n", new Object[0]);
                Strings.ff(stringBuilder, "  %s\n", this.getReturnAddressSlot().formatLong(iRegisterBank));
                Strings.ff(stringBuilder, "\n", new Object[0]);
            }
            Strings.ff(stringBuilder, "Inputs:\n", new Object[0]);
            int n2 = 0;
            for (StorageEntry storageEntry : this.inEntries) {
                Strings.ff(stringBuilder, "  param #%d: %s\n", n2, storageEntry.formatLong(iRegisterBank));
                ++n2;
            }
            Strings.ff(stringBuilder, "  ...\n", new Object[0]);
            n2 = 0;
            for (StorageEntry storageEntry : this.inRegPairs) {
                Strings.ff(stringBuilder, "  (long param #%d: %s)\n", n2, storageEntry.formatLong(iRegisterBank));
                ++n2;
            }
            Strings.ff(stringBuilder, "\n", new Object[0]);
            Strings.ff(stringBuilder, "Outputs:\n", new Object[0]);
            n2 = 0;
            for (StorageEntry storageEntry : this.outEntries) {
                Strings.ff(stringBuilder, "  retval #%d: %s\n", n2, storageEntry.formatLong(iRegisterBank));
                ++n2;
            }
            n2 = 0;
            for (StorageEntry storageEntry : this.outRegPairs) {
                Strings.ff(stringBuilder, "  (long retval #%d: %s)\n", n2, storageEntry.formatLong(iRegisterBank));
                ++n2;
            }
            Strings.ff(stringBuilder, "\n", new Object[0]);
            Strings.ff(stringBuilder, "FP Inputs:\n", new Object[0]);
            n2 = 0;
            for (StorageEntry storageEntry : this.inFpEntries) {
                Strings.ff(stringBuilder, "  float #%d: %s\n", n2, storageEntry.formatLong(iRegisterBank));
                ++n2;
            }
            Strings.ff(stringBuilder, "FP Output:\n", new Object[0]);
            if (this.outFpEntry != null) {
                Strings.ff(stringBuilder, "  float: %s\n", this.outFpEntry.formatLong(iRegisterBank));
            }
            Strings.ff(stringBuilder, "\n", new Object[0]);
            if (!this.slotcountAlignmentMap.isEmpty()) {
                Strings.ff("Alignments: %s\n", this.slotcountAlignmentMap);
            }
        }
        return stringBuilder.toString();
    }

    private void formatFlags(StringBuilder stringBuilder, String string) {
        if (this.hasFlag(1)) {
            Strings.ff(stringBuilder, "STACK_CLEANED_BY_CALLEE" + string, new Object[0]);
        }
        if (this.hasFlag(32)) {
            Strings.ff(stringBuilder, "OUTPUT_AFTER_INPUT" + string, new Object[0]);
        }
        if (this.hasFlag(64)) {
            Strings.ff(stringBuilder, "FLOAT_INPUT_ON_STACK" + string, new Object[0]);
        }
        if (this.hasFlag(128)) {
            Strings.ff(stringBuilder, "LINK_AFTER_INPUT" + string, new Object[0]);
        }
        if (this.hasFlag(256)) {
            Strings.ff(stringBuilder, "IPRD" + string, new Object[0]);
        }
        if (this.hasFlag(512)) {
            Strings.ff(stringBuilder, "OUTPUT_PUSHED" + string, new Object[0]);
        }
        if (this.hasFlag(1024)) {
            Strings.ff(stringBuilder, "PARALLEL_INPUT_REGISTER_STACKS" + string, new Object[0]);
        }
        if (this.hasFlag(2048)) {
            Strings.ff(stringBuilder, "FIRST_ARG_IS_THIS_POINTER" + string, new Object[0]);
        }
        if (this.hasFlag(4096)) {
            Strings.ff(stringBuilder, "COMPOSITE_INPUT_ON_STACK" + string, new Object[0]);
        }
        if (this.hasFlag(8192)) {
            Strings.ff(stringBuilder, "FORBID_PARAMS_2SLOTSUP" + string, new Object[0]);
        }
        if (this.hasFlag(16384)) {
            Strings.ff(stringBuilder, "FORBID_PARAMS_3SLOTSUP" + string, new Object[0]);
        }
        if (this.hasFlag(32768)) {
            Strings.ff(stringBuilder, "SKIP_PASSED_INPUT_REGISTERS" + string, new Object[0]);
        }
    }

    @Override
    public ArgLocationGenerator getInputsGenerator() {
        return new ArgLocationGenerator();
    }

    @Override
    public RetLocationGenerator getOutputsGenerator(int n2) {
        return new RetLocationGenerator(n2);
    }

    public class RetLocationGenerator
    implements IStorageEntryGenerator {
        private final int inputStackSlotCount;
        private List<StorageEntry> entries = new ArrayList<StorageEntry>();
        private StorageEntry lastEntry;
        private StorageEntry lastStackEntry;

        private RetLocationGenerator(int n2) {
            this.inputStackSlotCount = n2;
        }

        @Override
        public void reset() {
            this.entries.clear();
            this.lastEntry = null;
            this.lastStackEntry = null;
        }

        @Override
        public List<StorageEntry> getCurrentEntries() {
            return Collections.unmodifiableList(this.entries);
        }

        @Override
        public StorageEntry next(TypeLayoutInfo typeLayoutInfo) {
            StorageEntry storageEntry = this.nextInternal(typeLayoutInfo);
            if (storageEntry == null) {
                return null;
            }
            this.entries.add(storageEntry);
            this.lastEntry = storageEntry;
            if (storageEntry.isStackBased()) {
                this.lastStackEntry = storageEntry;
            }
            return storageEntry;
        }

        private StorageEntry nextInternal(TypeLayoutInfo typeLayoutInfo) {
            int n2 = this.entries.size();
            if (CallingConvention.this.hasFlag(32)) {
                return CallingConvention.this.getOutputSlotByIndex(this.inputStackSlotCount + n2);
            }
            if (CallingConvention.this.hasFlag(512)) {
                int n3 = this.inputStackSlotCount;
                if (CallingConvention.this.getReturnAddressSlot(this.inputStackSlotCount).isStackBased()) {
                    ++n3;
                }
                return StorageEntry.createStackSlot(n3 -= 1 + n2);
            }
            if (typeLayoutInfo.isFloat() && n2 == 0 && CallingConvention.this.outFpEntry != null) {
                return CallingConvention.this.outFpEntry;
            }
            if (typeLayoutInfo.getSlotcount() == 1) {
                return CallingConvention.this.getOutputSlotByIndex(n2);
            }
            if (typeLayoutInfo.getSlotcount() == 2) {
                if (n2 != 0) {
                    adw.ce(new RuntimeException("Unexpected index for multi-slot output: " + n2));
                    return null;
                }
                return CallingConvention.this.getOutputDualSlot();
            }
            return null;
        }
    }

    public class ArgLocationGenerator
    implements IStorageEntryGenerator {
        private final boolean parallel;
        private final StorageEntry stkSlotStart;
        private final List<StorageEntry> regSlots;
        private List<StorageEntry> entries = new ArrayList<StorageEntry>();
        private StorageEntry lastEntry;
        private StorageEntry lastStackEntry;
        private int gpRegIndex;
        private int fpRegIndex;

        private ArgLocationGenerator() {
            this.parallel = CallingConvention.this.hasFlag(1024);
            int n2 = CallingConvention.this.inEntries.size();
            if (n2 >= 1 && CallingConvention.this.inEntries.get(n2 - 1).isStackBased()) {
                ArrayList<StorageEntry> arrayList = new ArrayList<StorageEntry>(CallingConvention.this.inEntries);
                this.stkSlotStart = (StorageEntry)arrayList.remove(n2 - 1);
                this.regSlots = Collections.unmodifiableList(arrayList);
            } else {
                this.stkSlotStart = null;
                this.regSlots = Collections.unmodifiableList(CallingConvention.this.inEntries);
            }
        }

        @Override
        public void reset() {
            this.entries.clear();
            this.lastEntry = null;
            this.lastStackEntry = null;
            this.gpRegIndex = 0;
            this.fpRegIndex = 0;
        }

        private void incrGpRegIndex() {
            ++this.gpRegIndex;
            if (this.parallel) {
                ++this.fpRegIndex;
            }
        }

        private void incrFpRegIndex() {
            ++this.fpRegIndex;
            if (this.parallel) {
                ++this.gpRegIndex;
            }
        }

        @Override
        public List<StorageEntry> getCurrentEntries() {
            return Collections.unmodifiableList(this.entries);
        }

        @Override
        public StorageEntry next(TypeLayoutInfo typeLayoutInfo) {
            StorageEntry storageEntry = this.nextInternal(typeLayoutInfo);
            if (storageEntry == null) {
                return null;
            }
            this.entries.add(storageEntry);
            this.lastEntry = storageEntry;
            if (storageEntry.isStackBased()) {
                this.lastStackEntry = storageEntry;
            }
            return storageEntry;
        }

        private StorageEntry nextInternal(TypeLayoutInfo typeLayoutInfo) {
            StorageEntry storageEntry2 = null;
            int n2 = typeLayoutInfo.getSlotcount();
            if (n2 <= 0) {
                return null;
            }
            if (n2 >= 2 && CallingConvention.this.hasFlag(8192)) {
                return null;
            }
            if (n2 >= 3 && CallingConvention.this.hasFlag(16384)) {
                return null;
            }
            if (typeLayoutInfo.isFloat()) {
                if (CallingConvention.this.hasFlag(64)) {
                    if (this.lastEntry == null || this.lastStackEntry == null) {
                        if (this.stkSlotStart != null) {
                            return this.stkSlotStart.withCount(n2);
                        }
                    } else {
                        storageEntry2 = this.lastStackEntry.nextStackEntry(n2);
                    }
                    return storageEntry2;
                }
                if (CallingConvention.this.inFpEntries != null && !CallingConvention.this.inFpEntries.isEmpty()) {
                    if (this.lastEntry == null || this.fpRegIndex < CallingConvention.this.inFpEntries.size()) {
                        storageEntry2 = CallingConvention.this.inFpEntries.get(this.fpRegIndex);
                        this.incrFpRegIndex();
                    } else {
                        storageEntry2 = this.lastStackEntry == null ? CallingConvention.this.getStackParamBegin(n2) : this.lastStackEntry.nextStackEntry(n2);
                    }
                    return storageEntry2;
                }
            }
            if (typeLayoutInfo.isComposite() && CallingConvention.this.hasFlag(4096)) {
                if (this.lastEntry == null || this.lastStackEntry == null) {
                    if (this.stkSlotStart != null) {
                        return this.stkSlotStart.withCount(n2);
                    }
                } else {
                    storageEntry2 = this.lastStackEntry.nextStackEntry(n2);
                }
                return storageEntry2;
            }
            if (n2 == 1) {
                if (this.lastEntry == null) {
                    if (this.regSlots.isEmpty()) {
                        if (this.stkSlotStart != null) {
                            storageEntry2 = this.stkSlotStart.withCount(n2);
                        }
                    } else {
                        storageEntry2 = this.regSlots.get(this.gpRegIndex);
                        this.incrGpRegIndex();
                    }
                    return storageEntry2;
                }
                if (this.gpRegIndex < this.regSlots.size() && this.canUseGPReg()) {
                    storageEntry2 = this.regSlots.get(this.gpRegIndex);
                    this.incrGpRegIndex();
                } else if (this.lastStackEntry == null) {
                    if (this.stkSlotStart != null) {
                        storageEntry2 = this.stkSlotStart.withCount(1);
                    }
                } else {
                    storageEntry2 = this.lastStackEntry.nextStackEntry(1);
                }
                return storageEntry2;
            }
            int n3 = CallingConvention.this.determineSlotcountAlignment(n2);
            if (n2 == 2) {
                if (this.lastEntry == null) {
                    if (CallingConvention.this.inRegPairs.isEmpty()) {
                        if (this.stkSlotStart != null) {
                            storageEntry2 = this.stkSlotStart.withCount(2);
                        }
                    } else {
                        storageEntry2 = CallingConvention.this.inRegPairs.get(0);
                        this.incrGpRegIndex();
                        this.incrGpRegIndex();
                    }
                    return storageEntry2;
                }
                if (this.gpRegIndex < this.regSlots.size() && this.canUseGPReg()) {
                    HashSet hashSet = new HashSet();
                    this.entries.forEach(storageEntry -> storageEntry.collectRegisters(hashSet));
                    for (StorageEntry storageEntry3 : CallingConvention.this.inRegPairs) {
                        Collection<Long> collection = storageEntry3.getRegisters();
                        if (CollectionUtil.hasIntersection(collection, hashSet)) continue;
                        for (int i = this.regSlots.size() - 1; i >= 0; --i) {
                            if (!CollectionUtil.hasIntersection(this.regSlots.get(i).getRegisters(), collection)) continue;
                            while (this.gpRegIndex <= i) {
                                this.incrGpRegIndex();
                            }
                            break;
                        }
                        return storageEntry3;
                    }
                }
                if (this.lastStackEntry == null) {
                    if (this.stkSlotStart != null) {
                        storageEntry2 = this.stkSlotStart.withCount(2);
                    }
                } else {
                    storageEntry2 = this.lastStackEntry.nextStackEntry(2, n3);
                }
                return storageEntry2;
            }
            if (this.lastStackEntry == null) {
                if (this.stkSlotStart != null) {
                    storageEntry2 = this.stkSlotStart.withCount(n2);
                }
            } else {
                storageEntry2 = this.lastStackEntry.nextStackEntry(n2, n3);
            }
            return storageEntry2;
        }

        private boolean canUseGPReg() {
            return this.lastStackEntry == null || !CallingConvention.this.hasFlag(32768);
        }
    }
}

