/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.sig.codeless;

import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.ModuleId;
import com.pnfsoftware.jeb.util.collect.ISegment;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class Module
implements ISegment<Long> {
    private static final Module UNKNOWN_MODULE = new Module(ModuleId.UNKNOWN_MODULE_ID);
    @SerId(value=1)
    private final ModuleId id;
    @SerId(value=2)
    private Long begin;
    @SerId(value=3)
    private Long end;

    private Module(ModuleId moduleId) {
        this.id = moduleId;
    }

    private Module(ModuleId moduleId, long l2, long l3) {
        this(moduleId);
        this.begin = l2;
        this.end = l3;
    }

    @Override
    public Long getBegin() {
        return this.begin;
    }

    @Override
    public Long getEnd() {
        return this.end;
    }

    public static Module createKnownModule(ModuleId moduleId) {
        return new Module(moduleId);
    }

    public static Module createKnownModule(ModuleId moduleId, long l2, long l3) {
        return new Module(moduleId, l2, l3);
    }

    public static Module createUnknownModule() {
        return UNKNOWN_MODULE;
    }

    public boolean isUnknown() {
        return this.id.isUnknown();
    }

    public String getName() {
        return this.id.getFileName();
    }

    public ModuleId getId() {
        return this.id;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.begin == null ? 0 : this.begin.hashCode());
        n2 = 31 * n2 + (this.end == null ? 0 : this.end.hashCode());
        n2 = 31 * n2 + (this.id == null ? 0 : this.id.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Module module = (Module)object;
        if (this.begin == null ? module.begin != null : !this.begin.equals(module.begin)) {
            return false;
        }
        if (this.end == null ? module.end != null : !this.end.equals(module.end)) {
            return false;
        }
        return !(this.id == null ? module.id != null : !this.id.equals(module.id));
    }

    public String toString() {
        return Strings.ff("Module [id=%s - begin=%08x - end=%08x]", this.id, this.begin != null ? this.begin : 0L, this.end != null ? this.end : 0L);
    }
}

