/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.sig.codeless;

import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.Constraint;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.ExecutableModelMetadata;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.Func;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.Module;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.ModuleId;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.codeless.qo;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.BiMap;
import com.pnfsoftware.jeb.util.collect.SegmentMap;
import com.pnfsoftware.jeb.util.io.DirectByteArrayOutputStream;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.Deserializer;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jeb.util.serialization.SerializationManager;
import com.pnfsoftware.jeb.util.serialization.Serializer;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jebglobal.csd;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Ser
public class MatchingState {
    static final ILogger logger = GlobalLog.getLogger(MatchingState.class);
    public static final String DEFAULT_NAME = "codeless-sig.state";
    @SerId(value=1)
    private ExecutableModelMetadata refMetadata;
    @SerId(value=2)
    private BiMap<Func, Func> identifiedRoutines = new BiMap();
    @SerId(value=3)
    private Map<Func, List<Constraint>> routinesConstraints = new HashMap<Func, List<Constraint>>();
    @SerId(value=4)
    private Set<Func> nonIdentifiableRoutines = new HashSet<Func>();
    @SerId(value=5)
    Map<Func, Func> possibleMultiIdentityRoutines = new HashMap<Func, Func>();
    @SerId(value=6)
    Couple<Long, Long> identifiedRoutinesRange;
    @SerId(value=7)
    private Map<ModuleId, Module> targetModules = new HashMap<ModuleId, Module>();
    @SerId(value=8)
    private SegmentMap<Long, Module> targetModulesMapping = new SegmentMap();
    @SerTransient
    private String resultLog;

    public void addConstraint(Func func, Constraint constraint) {
        if (this.getNonIdentifiableRoutines().contains(func)) {
            return;
        }
        List<Constraint> list = this.getRoutinesConstraints().get(func);
        if (list == null) {
            list = new ArrayList<Constraint>();
            this.getRoutinesConstraints().put(func, list);
        }
        if (qo.mm != null && func.getName().equals(qo.mm)) {
            (new Object[1])[0] = constraint.getPossibleFuncs();
        }
        list.add(constraint);
    }

    public Module getModuleAt(long l2) {
        return this.getTargetModulesMapping().getSegmentContaining(l2);
    }

    public long getMatchedRangeStartAddress() {
        Module module = (Module)this.getTargetModulesMapping().firstEntry().getValue();
        return module.getBegin();
    }

    public long getMatchedRangeEndAddress() {
        Module module = (Module)this.getTargetModulesMapping().lastEntry().getValue();
        return module.getEnd();
    }

    public static MatchingState deserialize(String string) {
        MatchingState matchingState = null;
        try (FileInputStream fileInputStream = new FileInputStream(new File(string));){
            csd csd2 = csd.ce();
            SerializationManager serializationManager = new SerializationManager(csd2);
            Deserializer deserializer = serializationManager.getDeserializer(fileInputStream);
            matchingState = (MatchingState)deserializer.deserialize();
        }
        catch (IOException iOException) {}
        return matchingState;
    }

    public static void serialize(MatchingState matchingState, String string) throws IOException {
        csd csd2 = csd.ce();
        SerializationManager serializationManager = new SerializationManager(csd2);
        DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream();
        Serializer serializer = serializationManager.getSerializer(directByteArrayOutputStream);
        try {
            serializer.serialize(matchingState);
            serializer.close();
        }
        catch (SerializationException serializationException) {
            logger.catching(serializationException);
        }
        File file = new File(string);
        if (!file.exists()) {
            IO.createDirectory(file);
        }
        File file2 = new File(string.concat(File.separator).concat(DEFAULT_NAME));
        IO.writeFile(file2, directByteArrayOutputStream.getRawBytes(), 0, directByteArrayOutputStream.size());
    }

    public Couple<Long, Long> getIdentifiedRoutinesRange() {
        return this.identifiedRoutinesRange;
    }

    public void setIdentifiedRoutinesRange(long l2, long l3) {
        this.identifiedRoutinesRange = new Couple<Long, Long>(l2, l3);
    }

    public String toString() {
        return "MatchingState [identifiedRoutines=" + this.getIdentifiedRoutines() + ", routinesConstraints=" + this.getRoutinesConstraints() + ", nonIdentifiableRoutines=" + this.getNonIdentifiableRoutines() + ", possibleMultiIdentityRoutines=" + this.possibleMultiIdentityRoutines + ", identifiedRoutinesRange=" + this.identifiedRoutinesRange + ", modulesSegmentMap=" + this.getTargetModulesMapping() + ", modulesNamesMap=" + this.getTargetModules() + "]";
    }

    public BiMap<Func, Func> getIdentifiedRoutines() {
        return this.identifiedRoutines;
    }

    public void setIdentifiedRoutines(BiMap<Func, Func> biMap) {
        this.identifiedRoutines = biMap;
    }

    public Map<Func, List<Constraint>> getRoutinesConstraints() {
        return this.routinesConstraints;
    }

    public void setRoutinesConstraints(Map<Func, List<Constraint>> map) {
        this.routinesConstraints = map;
    }

    public SegmentMap<Long, Module> getTargetModulesMapping() {
        return this.targetModulesMapping;
    }

    public void setTargetModulesMapping(SegmentMap<Long, Module> segmentMap) {
        this.targetModulesMapping = segmentMap;
    }

    public Map<ModuleId, Module> getTargetModules() {
        return this.targetModules;
    }

    public void setTargetModules(Map<ModuleId, Module> map) {
        this.targetModules = map;
    }

    public Set<Func> getNonIdentifiableRoutines() {
        return this.nonIdentifiableRoutines;
    }

    public void setNonIdentifiableRoutines(Set<Func> set) {
        this.nonIdentifiableRoutines = set;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.identifiedRoutines == null ? 0 : this.identifiedRoutines.size());
        n2 = 31 * n2 + (this.identifiedRoutinesRange == null ? 0 : this.identifiedRoutinesRange.hashCode());
        n2 = 31 * n2 + (this.nonIdentifiableRoutines == null ? 0 : this.nonIdentifiableRoutines.hashCode());
        n2 = 31 * n2 + (this.possibleMultiIdentityRoutines == null ? 0 : this.possibleMultiIdentityRoutines.hashCode());
        n2 = 31 * n2 + (this.routinesConstraints == null ? 0 : this.routinesConstraints.hashCode());
        n2 = 31 * n2 + (this.targetModules == null ? 0 : this.targetModules.hashCode());
        n2 = 31 * n2 + (this.targetModulesMapping == null ? 0 : this.targetModulesMapping.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MatchingState matchingState = (MatchingState)object;
        if (this.identifiedRoutines == null && matchingState.identifiedRoutines != null) {
            return false;
        }
        for (Func func : this.identifiedRoutines.keySet()) {
            if (matchingState.identifiedRoutines.containsKey(func) && this.identifiedRoutines.get(func).equals(matchingState.identifiedRoutines.get(func))) continue;
            return false;
        }
        for (Func func : matchingState.identifiedRoutines.keySet()) {
            if (this.identifiedRoutines.containsKey(func) && this.identifiedRoutines.get(func).equals(matchingState.identifiedRoutines.get(func))) continue;
            return false;
        }
        if (this.identifiedRoutinesRange == null ? matchingState.identifiedRoutinesRange != null : !this.identifiedRoutinesRange.equals(matchingState.identifiedRoutinesRange)) {
            return false;
        }
        if (this.nonIdentifiableRoutines == null ? matchingState.nonIdentifiableRoutines != null : !this.nonIdentifiableRoutines.equals(matchingState.nonIdentifiableRoutines)) {
            return false;
        }
        if (this.possibleMultiIdentityRoutines == null ? matchingState.possibleMultiIdentityRoutines != null : !this.possibleMultiIdentityRoutines.equals(matchingState.possibleMultiIdentityRoutines)) {
            return false;
        }
        if (this.routinesConstraints == null ? matchingState.routinesConstraints != null : !this.routinesConstraints.equals(matchingState.routinesConstraints)) {
            return false;
        }
        if (this.targetModules == null ? matchingState.targetModules != null : !this.targetModules.equals(matchingState.targetModules)) {
            return false;
        }
        return !(this.targetModulesMapping == null ? matchingState.targetModulesMapping != null : !this.targetModulesMapping.equals(matchingState.targetModulesMapping));
    }

    public ExecutableModelMetadata getRefMetadata() {
        return this.refMetadata;
    }

    public void setRefMetadata(ExecutableModelMetadata executableModelMetadata) {
        this.refMetadata = executableModelMetadata;
    }

    public String getResultLog() {
        return this.resultLog;
    }

    public void setResultLog(String string) {
        this.resultLog = string;
    }
}

