/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.sig.codeless;

import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.ModuleId;
import com.pnfsoftware.jeb.util.base.Triple;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class Func {
    @SerId(value=1)
    private final String name;
    @SerId(value=2)
    private final ModuleId moduleId;
    @SerId(value=3)
    private Triple<Long, Long, Long> addresses;
    @SerId(value=4)
    private Func trampolineTarget;

    private Func(String string, ModuleId moduleId) {
        this.name = string;
        this.moduleId = moduleId;
    }

    public static Func createFrom(String string, ModuleId moduleId) {
        return new Func(string, moduleId);
    }

    public static Func createUnknownFrom(String string) {
        return new Func(string, ModuleId.UNKNOWN_MODULE_ID);
    }

    public String getName() {
        return this.name;
    }

    public ModuleId getModuleId() {
        return this.moduleId;
    }

    public void setAddresses(long l2, long l3, long l4) {
        this.addresses = new Triple<Long, Long, Long>(l2, l3, l4);
    }

    public boolean isMapped() {
        return this.addresses != null;
    }

    public Func getTrampolineTarget() {
        return this.trampolineTarget;
    }

    public void setTrampolineTarget(Func func) {
        this.trampolineTarget = func;
    }

    public Long getEntryPoint() {
        if (this.addresses == null) {
            return null;
        }
        return this.addresses.getFirst();
    }

    public Long getLowestAddress() {
        if (this.addresses == null) {
            return null;
        }
        return this.addresses.getSecond();
    }

    public Long getHighestAddress() {
        if (this.addresses == null) {
            return null;
        }
        return this.addresses.getThird();
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.addresses == null ? 0 : this.addresses.hashCode());
        n2 = 31 * n2 + (this.moduleId == null ? 0 : this.moduleId.hashCode());
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = 31 * n2 + (this.trampolineTarget == null ? 0 : this.trampolineTarget.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Func func = (Func)object;
        if (this.addresses == null ? func.addresses != null : !this.addresses.equals(func.addresses)) {
            return false;
        }
        if (this.moduleId == null ? func.moduleId != null : !this.moduleId.equals(func.moduleId)) {
            return false;
        }
        if (this.name == null ? func.name != null : !this.name.equals(func.name)) {
            return false;
        }
        return !(this.trampolineTarget == null ? func.trampolineTarget != null : !this.trampolineTarget.equals(func.trampolineTarget));
    }

    public String toString() {
        return "(" + this.name + ":" + this.moduleId.getFileName() + ")";
    }
}

