/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.sig.codeless;

import com.pnfsoftware.jeb.core.EnginesContextUtil;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.CodelessSignaturePackageEntry;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.LibraryIdentificationResults;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.MatchingState;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.codeless.dQ;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.codeless.qo;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.codeless.ri;
import com.pnfsoftware.jeb.util.collect.CollectionUtil;
import com.pnfsoftware.jeb.util.collect.SetMap;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CodelessSignatureManager
implements IEventListener {
    private static final ILogger logger = GlobalLog.getLogger(CodelessSignatureManager.class);
    public static final String CODELESS_SIGS_EXTENSION = ".codeless-siglib";
    public static final String CODELESS_FOLDER_DEFAULT_NAME = "codeless";
    private static CodelessSignatureManager instance;
    private final IEnginesContext enginesContext;
    private Set<File> folders = new HashSet<File>();
    private List<CodelessSignaturePackageEntry> entries = new ArrayList<CodelessSignaturePackageEntry>();
    private SetMap<INativeCodeUnit<IInstruction>, CodelessSignaturePackageEntry> matchedEntries = new SetMap();

    public static CodelessSignatureManager getInstance(IEnginesContext iEnginesContext) {
        if (instance == null) {
            instance = new CodelessSignatureManager(iEnginesContext);
        }
        return instance;
    }

    private CodelessSignatureManager(IEnginesContext iEnginesContext) {
        this.enginesContext = iEnginesContext;
    }

    public void addFolder(File file, boolean bl) {
        this.folders.add(file);
        if (bl) {
            this.scan();
        }
    }

    public List<CodelessSignaturePackageEntry> getAvailablePackages() {
        return this.entries;
    }

    public void rescan() {
        this.scan();
    }

    public List<CodelessSignaturePackageEntry> scan() {
        for (File file : this.folders) {
            if (file == null || !file.exists() || !file.isDirectory()) {
                logger.warn("Codeless signature folder is invalid: %s", file);
                continue;
            }
            for (File file2 : file.listFiles()) {
                if (!file2.isFile() || !file2.getName().endsWith(CODELESS_SIGS_EXTENSION)) continue;
                CodelessSignaturePackageEntry codelessSignaturePackageEntry = new CodelessSignaturePackageEntry(file2);
                this.entries.add(codelessSignaturePackageEntry);
            }
        }
        return this.entries;
    }

    public boolean isMatched(INativeCodeUnit<IInstruction> iNativeCodeUnit, CodelessSignaturePackageEntry codelessSignaturePackageEntry) {
        return CollectionUtil.contains(this.matchedEntries.get(iNativeCodeUnit), codelessSignaturePackageEntry);
    }

    public INativeCodeUnit<IInstruction> getMatchableUnit() {
        IRuntimeProject iRuntimeProject = EnginesContextUtil.getMainProject(this.enginesContext);
        if (iRuntimeProject == null) {
            return null;
        }
        INativeCodeUnit iNativeCodeUnit = iRuntimeProject.findUnit(INativeCodeUnit.class);
        return iNativeCodeUnit;
    }

    public MatchingState match(INativeCodeUnit<IInstruction> iNativeCodeUnit, CodelessSignaturePackageEntry codelessSignaturePackageEntry) {
        qo qo2 = new qo();
        MatchingState matchingState = qo2.ce(codelessSignaturePackageEntry.getFile().getAbsolutePath(), iNativeCodeUnit);
        if (matchingState != null) {
            this.matchedEntries.put(iNativeCodeUnit, codelessSignaturePackageEntry);
            iNativeCodeUnit.addListener(this);
        }
        return matchingState;
    }

    public boolean importState(INativeCodeUnit<IInstruction> iNativeCodeUnit, MatchingState matchingState) {
        dQ dQ2 = new dQ();
        dQ2.ce(iNativeCodeUnit, matchingState);
        return true;
    }

    public LibraryIdentificationResults identifyLibraries(INativeCodeUnit<IInstruction> iNativeCodeUnit) {
        ri ri2 = new ri();
        return ri2.ce(this.entries, iNativeCodeUnit);
    }

    @Override
    public void onEvent(IEvent iEvent) {
        JebEvent jebEvent = (JebEvent)iEvent;
        if (jebEvent.getType() == J.UnitDisposed && jebEvent.getSource() instanceof INativeCodeUnit) {
            this.matchedEntries.remove((INativeCodeUnit)jebEvent.getSource());
        }
    }
}

