/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.sig;

import com.pnfsoftware.jeb.core.units.code.asm.sig.INativeSignature;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignaturePackageMetadata;
import com.pnfsoftware.jeb.util.format.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class NativeSignaturePackageEntry {
    private File file;
    private NativeSignaturePackageMetadata metadata;
    private List<INativeSignature> signaturesToWrite;
    private int openHandle;
    private PackageStatus status;

    public NativeSignaturePackageEntry(File file, NativeSignaturePackageMetadata nativeSignaturePackageMetadata) {
        this.file = file;
        this.metadata = nativeSignaturePackageMetadata;
    }

    public long getSize() {
        return this.file.length();
    }

    public PackageStatus getStatus() {
        return this.status;
    }

    public void setStatus(PackageStatus packageStatus) {
        this.status = packageStatus;
    }

    public boolean isActive() {
        return this.status == PackageStatus.ACTIVE;
    }

    public boolean isLoadedInMemory() {
        return this.openHandle > 0;
    }

    public void incrementOpenHandle() {
        ++this.openHandle;
    }

    public void decrementOpenHandle() {
        --this.openHandle;
    }

    public File getFile() {
        return this.file;
    }

    public NativeSignaturePackageMetadata getMetadata() {
        return this.metadata;
    }

    public boolean isUserCreated() {
        return this.metadata.getUuid() < 0;
    }

    public void clearSignaturesToWrite() {
        this.signaturesToWrite.clear();
    }

    public void addSignatureToWrite(INativeSignature iNativeSignature) {
        if (this.signaturesToWrite == null) {
            this.signaturesToWrite = new ArrayList<INativeSignature>();
        }
        this.signaturesToWrite.add(iNativeSignature);
    }

    public List<INativeSignature> getSignatureToWrite() {
        return this.signaturesToWrite;
    }

    public String toString() {
        return Strings.ff("Status:%s|Header=%s|File:%s", new Object[]{this.getStatus(), this.getMetadata(), this.getFile()});
    }

    public static enum PackageStatus {
        INACTIVE,
        ACTIVE;

    }
}

