/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.sig;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.sig.INativeAttribute;
import com.pnfsoftware.jeb.core.units.code.asm.sig.INativeFeature;
import com.pnfsoftware.jeb.core.units.code.asm.sig.INativeSignature;
import com.pnfsoftware.jeb.core.units.code.asm.sig.ISigningStrategy;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeAttributeSignerID;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeFeatureSignerID;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignatureFlags;
import com.pnfsoftware.jeb.core.units.code.asm.sig.SignatureTargetType;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.HY;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.dQ;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.qo;
import com.pnfsoftware.jeb.util.base.Assert;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NativeSignatureGenerator {
    private ISigningStrategy defaultStrategy;
    private final Map<INativeCodeAnalyzer<IInstruction>, dQ> featureSignersManagerDB;
    private final Map<INativeCodeAnalyzer<IInstruction>, HY> attributeSignersManagerDB;
    private static NativeSignatureGenerator instance;

    private NativeSignatureGenerator(ISigningStrategy iSigningStrategy) {
        this.defaultStrategy = iSigningStrategy;
        this.featureSignersManagerDB = new HashMap<INativeCodeAnalyzer<IInstruction>, dQ>();
        this.attributeSignersManagerDB = new HashMap<INativeCodeAnalyzer<IInstruction>, HY>();
    }

    public static NativeSignatureGenerator getInstance(ISigningStrategy iSigningStrategy) {
        if (instance == null) {
            instance = new NativeSignatureGenerator(iSigningStrategy);
        }
        return instance;
    }

    public INativeSignature generateSignature(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer, INativeMethodItem iNativeMethodItem, Set<NativeFeatureSignerID> set, Set<NativeAttributeSignerID> set2) {
        Assert.a(set == null && set2 == null, "TBI: client provided features/attributes");
        Set<NativeFeatureSignerID> set3 = this.defaultStrategy.getFeatureSigners(iNativeCodeAnalyzer, iNativeMethodItem);
        dQ dQ2 = this.featureSignersManagerDB.get(iNativeCodeAnalyzer);
        if (dQ2 == null) {
            dQ2 = new dQ(iNativeCodeAnalyzer);
            this.featureSignersManagerDB.put(iNativeCodeAnalyzer, dQ2);
        }
        List<INativeFeature> list = dQ2.ce(iNativeMethodItem, set3);
        Set<NativeAttributeSignerID> set4 = this.defaultStrategy.getAttributeSigners(iNativeCodeAnalyzer, iNativeMethodItem);
        HY hY = this.attributeSignersManagerDB.get(iNativeCodeAnalyzer);
        if (hY == null) {
            hY = new HY(iNativeCodeAnalyzer);
            this.attributeSignersManagerDB.put(iNativeCodeAnalyzer, hY);
        }
        List<INativeAttribute> list2 = hY.ce(iNativeMethodItem, set4);
        qo qo2 = new qo(iNativeMethodItem.getName(true), list, list2, new NativeSignatureFlags(SignatureTargetType.ROUTINE));
        return qo2;
    }

    public void setDefaultStrategy(ISigningStrategy iSigningStrategy) {
        this.defaultStrategy = iSigningStrategy;
    }
}

