/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.sig;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.ICompiler;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.LibraryID;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.sig.INativeFeature;
import com.pnfsoftware.jeb.core.units.code.asm.sig.INativeSignature;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeFeatureSignerID;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignatureGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignatureMatchResult;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignaturePackageEntry;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignaturePackageMetadata;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignatureScopeException;
import com.pnfsoftware.jeb.core.units.code.asm.sig.SignatureTargetType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.AD;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.Kh;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.UB;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.cU;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.ca;
import com.pnfsoftware.jeb.corei.parsers.asm.nativesig.qo;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.concurrent.ACLock;
import com.pnfsoftware.jeb.util.encoding.HashCalculator;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.DirectByteArrayOutputStream;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.Deserializer;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jeb.util.serialization.SerializationManager;
import com.pnfsoftware.jeb.util.serialization.Serializer;
import com.pnfsoftware.jebglobal.aab;
import com.pnfsoftware.jebglobal.aah;
import com.pnfsoftware.jebglobal.axk;
import com.pnfsoftware.jebglobal.azk;
import com.pnfsoftware.jebglobal.azo;
import com.pnfsoftware.jebglobal.azu;
import com.pnfsoftware.jebglobal.bbd;
import com.pnfsoftware.jebglobal.csd;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class NativeSignatureDBManager
implements IEventListener {
    private static final ILogger logger = GlobalLog.getLogger(NativeSignatureDBManager.class);
    public static final String SIGLIB_EXTENSION = ".siglib";
    public static final String SIGLIB_USER_PACKAGE_FOLDER = "custom";
    private static NativeSignatureDBManager instance;
    private final IEnginesContext enginesContext;
    private final NativeSignatureGenerator signatureGenerator;
    private Set<File> folders = new HashSet<File>();
    private File userCreatedPackageFolder;
    private List<NativeSignaturePackageEntry> entries = new ArrayList<NativeSignaturePackageEntry>();
    private boolean isActive = true;
    private Map<Integer, NativeSignaturePackageEntry> idEntryMap = new HashMap<Integer, NativeSignaturePackageEntry>();
    private Map<INativeCodeAnalyzer<IInstruction>, SignatureMemoryStorage> memoryStorage = new HashMap<INativeCodeAnalyzer<IInstruction>, SignatureMemoryStorage>();
    private Map<INativeCodeAnalyzer<IInstruction>, NativeSignaturePackageEntry> userSelectedPackageStorage = new HashMap<INativeCodeAnalyzer<IInstruction>, NativeSignaturePackageEntry>();
    private Map<INativeCodeAnalyzer<IInstruction>, aah> autoModeManagerStorage = new HashMap<INativeCodeAnalyzer<IInstruction>, aah>();

    public static NativeSignatureDBManager getInstance(IEnginesContext iEnginesContext) {
        if (instance == null) {
            instance = new NativeSignatureDBManager(iEnginesContext);
        }
        return instance;
    }

    private NativeSignatureDBManager(IEnginesContext iEnginesContext) {
        this.signatureGenerator = NativeSignatureGenerator.getInstance(new UB());
        this.enginesContext = iEnginesContext;
        this.enginesContext.addListener(this);
    }

    public void addFolder(File file, boolean bl) {
        this.folders.add(file);
        if (file.getName().equals(SIGLIB_USER_PACKAGE_FOLDER)) {
            this.userCreatedPackageFolder = file;
        }
        if (bl) {
            this.rescan();
        }
    }

    public void removeFolder(File file, boolean bl) {
        this.folders.remove(file);
        if (bl) {
            this.rescan();
        }
    }

    public void removeAllFolders() {
        this.folders.clear();
    }

    public synchronized void rescan() {
        this.rescan(true);
    }

    /*
     * Could not resolve type clashes
     */
    public synchronized void rescan(boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Object object : this.entries) {
            ((NativeSignaturePackageEntry)object).setStatus(NativeSignaturePackageEntry.PackageStatus.INACTIVE);
        }
        for (Object object : this.folders) {
            if (object == null || !((File)object).exists() || !((File)object).isDirectory()) {
                logger.warn("Native signature folder is invalid: %s", object);
                continue;
            }
            if (((File)object).getName().equals("codeless")) continue;
            for (File file : ((File)object).listFiles()) {
                NativeSignaturePackageMetadata nativeSignaturePackageMetadata;
                Object object2;
                Object object3;
                if (!file.isFile() || !file.getName().endsWith(SIGLIB_EXTENSION)) continue;
                try {
                    object3 = new FileInputStream(file);
                    try {
                        csd csd2 = csd.ce();
                        Object object4 = new SerializationManager(csd2);
                        object2 = ((SerializationManager)object4).getDeserializer((InputStream)object3);
                        nativeSignaturePackageMetadata = (NativeSignaturePackageMetadata)((Deserializer)object2).deserialize();
                    }
                    finally {
                        ((FileInputStream)object3).close();
                    }
                }
                catch (Exception exception) {
                    logger.error("Error when opening native signature package %s", file);
                    NativeSignatureDBManager.collectInformationDeserFailure(file, "metadata", exception);
                    continue;
                }
                object3 = null;
                for (Object object4 : this.entries) {
                    if (!((NativeSignaturePackageEntry)object4).getFile().equals(file)) continue;
                    object3 = object4;
                    break;
                }
                if (object3 != null) {
                    ((NativeSignaturePackageEntry)object3).setStatus(NativeSignaturePackageEntry.PackageStatus.ACTIVE);
                    continue;
                }
                boolean bl2 = true;
                int n2 = nativeSignaturePackageMetadata.getUuid();
                if (n2 == 0) {
                    arrayList.add(file);
                    bl2 = false;
                } else if (n2 > 0 && (object2 = this.idEntryMap.get(n2)) != null) {
                    int n3;
                    int n4 = ((NativeSignaturePackageEntry)object2).getMetadata().getVersion();
                    if (n4 > (n3 = nativeSignaturePackageMetadata.getVersion())) {
                        arrayList.add(file);
                        bl2 = false;
                    } else if (n4 < n3) {
                        arrayList.add(((NativeSignaturePackageEntry)object2).getFile());
                        this.entries.remove(object2);
                    } else {
                        logger.warn("Two siglib entries have the same UUID and version number: uuid=%d (files: %s and %s)", n2, file, ((NativeSignaturePackageEntry)object2).getFile());
                    }
                }
                if (!bl2) continue;
                object3 = new NativeSignaturePackageEntry(file, nativeSignaturePackageMetadata);
                ((NativeSignaturePackageEntry)object3).setStatus(NativeSignaturePackageEntry.PackageStatus.ACTIVE);
                this.entries.add((NativeSignaturePackageEntry)object3);
                if (n2 <= 0) continue;
                this.idEntryMap.put(n2, (NativeSignaturePackageEntry)object3);
            }
        }
        if (bl) {
            for (Object object : arrayList) {
                ((File)object).delete();
            }
        }
        int n5 = 0;
        while (n5 < this.entries.size()) {
            Object object;
            object = this.entries.get(n5);
            if (((NativeSignaturePackageEntry)object).getStatus() == NativeSignaturePackageEntry.PackageStatus.INACTIVE) {
                this.entries.remove(n5);
                continue;
            }
            ++n5;
        }
    }

    private static void collectInformationDeserFailure(File file, String string, Exception exception) {
        Object object;
        String string2 = "";
        try {
            object = new FileInputStream(file);
            try {
                HashCalculator hashCalculator = new HashCalculator((InputStream)object, 16);
                if (hashCalculator.compute()) {
                    string2 = Formatter.byteArrayToHexString(hashCalculator.getSha256());
                }
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {}
        object = Strings.ff("Signature package deser failed (msg:%s - fileName:%s - sha256:%s - lastModified:%d)", string, file.getName(), string2, file.lastModified());
        JebCoreService.notifySilentExceptionToClient(new SerializationException((String)object, exception));
    }

    public List<NativeSignaturePackageEntry> getAvailablePackages() {
        return this.entries;
    }

    public void removeAllPackages() {
        this.entries.clear();
        this.idEntryMap.clear();
    }

    public List<NativeSignaturePackageEntry> getLoadedPackages() {
        ArrayList<NativeSignaturePackageEntry> arrayList = new ArrayList<NativeSignaturePackageEntry>();
        for (NativeSignaturePackageEntry nativeSignaturePackageEntry : this.entries) {
            if (!nativeSignaturePackageEntry.isLoadedInMemory()) continue;
            arrayList.add(nativeSignaturePackageEntry);
        }
        return arrayList;
    }

    public List<NativeSignaturePackageEntry> getUserCreatedPackages(ProcessorType processorType) {
        ArrayList<NativeSignaturePackageEntry> arrayList = new ArrayList<NativeSignaturePackageEntry>();
        for (NativeSignaturePackageEntry nativeSignaturePackageEntry : this.entries) {
            if (!nativeSignaturePackageEntry.isActive() || !nativeSignaturePackageEntry.isUserCreated() || !nativeSignaturePackageEntry.getMetadata().getTargetProcessorType().equals(processorType)) continue;
            arrayList.add(nativeSignaturePackageEntry);
        }
        return arrayList;
    }

    public List<NativeSignaturePackageEntry> getUserCreatedPackages() {
        ArrayList<NativeSignaturePackageEntry> arrayList = new ArrayList<NativeSignaturePackageEntry>();
        for (NativeSignaturePackageEntry nativeSignaturePackageEntry : this.entries) {
            if (!nativeSignaturePackageEntry.isActive() || !nativeSignaturePackageEntry.isUserCreated()) continue;
            arrayList.add(nativeSignaturePackageEntry);
        }
        return arrayList;
    }

    public void updateOnDiskPackages(boolean bl) {
        for (NativeSignaturePackageEntry nativeSignaturePackageEntry : this.entries) {
            AD aD;
            NativeSignaturePackageMetadata nativeSignaturePackageMetadata;
            Object object;
            List<INativeSignature> list;
            block16: {
                if (!nativeSignaturePackageEntry.isActive() || !nativeSignaturePackageEntry.isUserCreated() || (list = nativeSignaturePackageEntry.getSignatureToWrite()) == null || list.isEmpty()) continue;
                try (Iterator<INativeSignature> iterator = new FileInputStream(nativeSignaturePackageEntry.getFile());){
                    csd csd2 = csd.ce();
                    object = new SerializationManager(csd2);
                    Deserializer deserializer = ((SerializationManager)object).getDeserializer((InputStream)((Object)iterator));
                    nativeSignaturePackageMetadata = (NativeSignaturePackageMetadata)deserializer.deserialize();
                    if (nativeSignaturePackageMetadata == null || (aD = (AD)deserializer.deserialize()) == null) {
                        continue;
                    }
                    break block16;
                }
                catch (Exception exception) {
                    logger.error("Error when opening native signature package %s", nativeSignaturePackageEntry.getFile());
                    NativeSignatureDBManager.collectInformationDeserFailure(nativeSignaturePackageEntry.getFile(), "update on disk", exception);
                }
                continue;
            }
            if (!bl) {
                for (INativeSignature iNativeSignature : list) {
                    aD.ce(iNativeSignature);
                }
            } else {
                for (INativeSignature iNativeSignature : list) {
                    object = null;
                    for (INativeSignature iNativeSignature2 : aD.getSignatures()) {
                        if (!iNativeSignature2.matchExactly(iNativeSignature)) continue;
                        object = iNativeSignature2;
                        break;
                    }
                    if (object != null) {
                        aD.getSignatures().remove(object);
                    }
                    aD.ce(iNativeSignature);
                }
            }
            this.writePackageOnDisk(nativeSignaturePackageEntry.getFile(), nativeSignaturePackageMetadata, aD);
            nativeSignaturePackageEntry.clearSignaturesToWrite();
        }
    }

    public NativeSignaturePackageEntry createUserPackage(ProcessorType processorType, String string, String string2, String string3) {
        if (this.userCreatedPackageFolder == null) {
            logger.error("user folder is not set", new Object[0]);
            return null;
        }
        return this.createPackageInternal(this.userCreatedPackageFolder, processorType, string, -1, 0, string2, string3, null, null);
    }

    private NativeSignaturePackageEntry createPackageInternal(File file, ProcessorType processorType, String string, int n2, int n3, String string2, String string3, ICompiler iCompiler, LibraryID libraryID) {
        File file2 = new File(file, string + SIGLIB_EXTENSION);
        if (file2.exists()) {
            return null;
        }
        NativeSignaturePackageMetadata nativeSignaturePackageMetadata = NativeSignaturePackageMetadata.create(processorType, string, n2, n3, string2, string3, iCompiler, libraryID);
        AD aD = new AD(nativeSignaturePackageMetadata);
        this.writePackageOnDisk(file2, nativeSignaturePackageMetadata, aD);
        NativeSignaturePackageEntry nativeSignaturePackageEntry = new NativeSignaturePackageEntry(file2, nativeSignaturePackageMetadata);
        nativeSignaturePackageEntry.setStatus(NativeSignaturePackageEntry.PackageStatus.ACTIVE);
        this.entries.add(nativeSignaturePackageEntry);
        return nativeSignaturePackageEntry;
    }

    private boolean writePackageOnDisk(File file, NativeSignaturePackageMetadata nativeSignaturePackageMetadata, AD aD) {
        try (DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream();){
            csd csd2 = csd.ce();
            SerializationManager serializationManager = new SerializationManager(csd2);
            Serializer serializer = serializationManager.getSerializer(directByteArrayOutputStream);
            serializer.serialize(nativeSignaturePackageMetadata);
            serializer.serialize(aD);
            serializer.close();
            IO.writeFile(file, directByteArrayOutputStream.getRawBytes(), 0, directByteArrayOutputStream.size());
        }
        catch (IOException iOException) {
            logger.catching(iOException);
            return false;
        }
        return true;
    }

    public void loadDefaultPackages(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        ProcessorType processorType = iNativeCodeAnalyzer.getProcessor().getType();
        ICompiler iCompiler = iNativeCodeAnalyzer.getDetectedCompiler();
        for (NativeSignaturePackageEntry nativeSignaturePackageEntry : this.getAvailablePackages()) {
            SignatureMemoryStorage signatureMemoryStorage;
            ICompiler iCompiler2;
            if (!nativeSignaturePackageEntry.getMetadata().getTargetProcessorType().equals(processorType) || nativeSignaturePackageEntry.isUserCreated() || (iCompiler2 = nativeSignaturePackageEntry.getMetadata().getTargetCompiler()) != null && (iCompiler == null || !iCompiler.getClass().equals(iCompiler2.getClass())) || (signatureMemoryStorage = this.memoryStorage.get(iNativeCodeAnalyzer)) != null && signatureMemoryStorage.loadedPackages != null && signatureMemoryStorage.loadedPackages.contains(nativeSignaturePackageEntry)) continue;
            this.loadPackage(iNativeCodeAnalyzer, nativeSignaturePackageEntry);
        }
    }

    public boolean loadPackage(NativeSignaturePackageEntry nativeSignaturePackageEntry, boolean bl) {
        boolean bl2 = false;
        for (INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer : this.memoryStorage.keySet()) {
            ACLock aCLock = ((aab)iNativeCodeAnalyzer).lg().getLock().a();
            try {
                if (!iNativeCodeAnalyzer.getProcessor().getType().equals(nativeSignaturePackageEntry.getMetadata().getTargetProcessorType()) || !this.loadInternal(iNativeCodeAnalyzer, nativeSignaturePackageEntry)) continue;
                if (bl) {
                    ((aab)iNativeCodeAnalyzer).Wz();
                }
                bl2 = true;
            }
            finally {
                if (aCLock == null) continue;
                aCLock.close();
            }
        }
        return bl2;
    }

    public boolean loadPackage(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer, NativeSignaturePackageEntry nativeSignaturePackageEntry) {
        return this.loadInternal(iNativeCodeAnalyzer, nativeSignaturePackageEntry);
    }

    private synchronized boolean loadInternal(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer, NativeSignaturePackageEntry nativeSignaturePackageEntry) {
        SignatureMemoryStorage signatureMemoryStorage = this.memoryStorage.get(iNativeCodeAnalyzer);
        if (signatureMemoryStorage == null) {
            logger.error("unknown analyzer", new Object[0]);
            return false;
        }
        return signatureMemoryStorage.loadPackage(nativeSignaturePackageEntry);
    }

    public void activateAutoSigningMode(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        Assert.a(this.getUserSelectedPackage(iNativeCodeAnalyzer) != null);
        aah aah2 = this.autoModeManagerStorage.get(iNativeCodeAnalyzer);
        if (aah2 == null) {
            int n2 = 10;
            aah2 = new Kh(iNativeCodeAnalyzer, this, n2);
            iNativeCodeAnalyzer.getModel().addListener(aah2);
            ((bbd)iNativeCodeAnalyzer.getTypeManager()).addListener(aah2);
            this.autoModeManagerStorage.put(iNativeCodeAnalyzer, aah2);
        }
    }

    public void deactivateAutoSigningMode(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        aah aah2 = this.autoModeManagerStorage.remove(iNativeCodeAnalyzer);
        if (aah2 != null) {
            iNativeCodeAnalyzer.getModel().removeListener(aah2);
            ((bbd)iNativeCodeAnalyzer.getTypeManager()).removeListener(aah2);
        }
    }

    public boolean isAutoSigningModeActivated(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        return this.autoModeManagerStorage.containsKey(iNativeCodeAnalyzer);
    }

    public void registerAnalyzer(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        SignatureMemoryStorage signatureMemoryStorage = this.memoryStorage.get(iNativeCodeAnalyzer);
        if (signatureMemoryStorage == null) {
            signatureMemoryStorage = new SignatureMemoryStorage(iNativeCodeAnalyzer);
            this.memoryStorage.put(iNativeCodeAnalyzer, signatureMemoryStorage);
        }
    }

    public void unregisterAnalyzer(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        SignatureMemoryStorage signatureMemoryStorage = this.memoryStorage.remove(iNativeCodeAnalyzer);
        if (signatureMemoryStorage != null && signatureMemoryStorage.loadedPackages != null) {
            for (NativeSignaturePackageEntry nativeSignaturePackageEntry : signatureMemoryStorage.loadedPackages) {
                nativeSignaturePackageEntry.decrementOpenHandle();
            }
        }
        this.userSelectedPackageStorage.remove(iNativeCodeAnalyzer);
        this.deactivateAutoSigningMode(iNativeCodeAnalyzer);
    }

    public int getNumberLoadedSigs() {
        int n2 = 0;
        for (SignatureMemoryStorage signatureMemoryStorage : this.memoryStorage.values()) {
            for (Map<INativeSignature, INativeSignature> map : signatureMemoryStorage.signaturesDB.values()) {
                n2 += map.size();
            }
        }
        return n2;
    }

    private static int getRoutineSize(INativeSignature iNativeSignature) {
        int n2 = 0;
        for (INativeFeature iNativeFeature : ((ca)iNativeSignature).ce()) {
            if (!(iNativeFeature instanceof azu)) continue;
            n2 = ((azu)iNativeFeature).ce();
            break;
        }
        return n2;
    }

    private static azo getRoutineCodeHash(INativeSignature iNativeSignature) {
        azo azo2 = null;
        for (INativeFeature iNativeFeature : ((ca)iNativeSignature).ce()) {
            if (!(iNativeFeature instanceof azo)) continue;
            azo2 = (azo)iNativeFeature;
            break;
        }
        return azo2;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private NativeSignatureMatchResult internalMatch(SignatureMemoryStorage signatureMemoryStorage, INativeMethodItem iNativeMethodItem, boolean bl, boolean bl2, boolean bl3) throws NativeSignatureScopeException {
        Object object;
        if (signatureMemoryStorage == null) {
            List<INativeSignature> list = Collections.emptyList();
            return new NativeSignatureMatchResult(iNativeMethodItem, list, true, INativeSignature.ConfidenceLevel.UNKNOWN);
        }
        int n2 = iNativeMethodItem.getData().getCFG().getInstructionCount();
        Set<NativeFeatureSignerID> set = signatureMemoryStorage.routineSignersDB.get(n2);
        Map<INativeSignature, INativeSignature> map = signatureMemoryStorage.signaturesDB.get(n2);
        if (map == null || set == null) {
            List<INativeSignature> list = Collections.emptyList();
            return new NativeSignatureMatchResult(iNativeMethodItem, list, true, INativeSignature.ConfidenceLevel.UNKNOWN);
        }
        ArrayList<INativeFeature> arrayList = new ArrayList<INativeFeature>();
        for (NativeFeatureSignerID nativeFeatureSignerID : set) {
            object = signatureMemoryStorage.signersDB.get((Object)nativeFeatureSignerID);
            ((azk)object).ce(iNativeMethodItem);
            arrayList.addAll(((azk)object).ce());
            ((azk)object).mm();
        }
        List<INativeSignature> list = new ArrayList();
        boolean bl4 = true;
        object = INativeSignature.ConfidenceLevel.LOW;
        for (INativeSignature iNativeSignature3 : map.keySet()) {
            if (iNativeSignature3.getFlags().getTargetType() != SignatureTargetType.ROUTINE || !((qo)iNativeSignature3).fz(arrayList)) continue;
            if (bl2) {
                INativeSignature.ConfidenceLevel confidenceLevel = iNativeSignature3.getConfidenceLevel();
                if (confidenceLevel == null || confidenceLevel.compareTo(object) < 0) continue;
                if (confidenceLevel.compareTo(object) == 0) {
                    list.add(iNativeSignature3);
                } else {
                    object = confidenceLevel;
                    list.clear();
                    list.add(iNativeSignature3);
                }
            } else {
                list.add(iNativeSignature3);
            }
            if (list.size() < 2 || !bl) continue;
            bl4 = false;
            break;
        }
        Collections.sort(list, (iNativeSignature, iNativeSignature2) -> {
            if (iNativeSignature2.getFlags().hasMeaningfulTargetName()) {
                if (!iNativeSignature.getFlags().hasMeaningfulTargetName()) {
                    return 1;
                }
            } else if (iNativeSignature.getFlags().hasMeaningfulTargetName()) {
                return -1;
            }
            if (iNativeSignature2.getTargetName() == null) {
                if (iNativeSignature.getTargetName() == null) {
                    return 0;
                }
                return -1;
            }
            if (iNativeSignature.getTargetName() == null) {
                return 1;
            }
            return iNativeSignature.getTargetName().compareTo(iNativeSignature2.getTargetName());
        });
        if (bl3) {
            signatureMemoryStorage.registerPackageUsed(list);
        } else if (signatureMemoryStorage.isSafeSignatureList(list = signatureMemoryStorage.findBestPackage(list))) {
            signatureMemoryStorage.registerPackageUsed(list);
        }
        NativeSignatureMatchResult nativeSignatureMatchResult = new NativeSignatureMatchResult(iNativeMethodItem, list, bl4, (INativeSignature.ConfidenceLevel)((Object)(bl2 ? object : INativeSignature.ConfidenceLevel.UNKNOWN)));
        return nativeSignatureMatchResult;
    }

    public List<NativeSignatureMatchResult> match(INativeCodeAnalyzer<? extends IInstruction> iNativeCodeAnalyzer, Collection<INativeMethodDataItem> collection, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        iNativeCodeAnalyzer.getModel().getLock().verifyLocked();
        List<NativeSignatureMatchResult> list = Collections.emptyList();
        if (!this.isActive || collection.isEmpty()) {
            return list;
        }
        SignatureMemoryStorage signatureMemoryStorage = this.memoryStorage.get(iNativeCodeAnalyzer);
        if (signatureMemoryStorage == null) {
            return list;
        }
        list = new ArrayList<NativeSignatureMatchResult>();
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        for (INativeMethodDataItem object2 : collection) {
            object = (axk)object2.getRoutine();
            if (!this.canBeMatched((axk)object, bl3)) continue;
            ((axk)object).ce((Boolean)false);
            try {
                NativeSignatureMatchResult nativeSignatureMatchResult = this.internalMatch(signatureMemoryStorage, (INativeMethodItem)object, bl, bl2, true);
                if (nativeSignatureMatchResult.getSignatures().isEmpty() || signatureMemoryStorage.isSafeSignatureList(nativeSignatureMatchResult.getSignatures())) {
                    list.add(nativeSignatureMatchResult);
                    continue;
                }
                treeMap.put(list.size(), object);
                list.add(nativeSignatureMatchResult);
            }
            catch (NativeSignatureScopeException nativeSignatureScopeException) {
                Object[] cfr_ignored_0 = new Object[0];
            }
        }
        for (NativeSignatureMatchResult nativeSignatureMatchResult : list) {
            signatureMemoryStorage.updatePackageNames(nativeSignatureMatchResult.getSignatures());
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            try {
                object = this.internalMatch(signatureMemoryStorage, (INativeMethodItem)entry.getValue(), bl, bl2, false);
                list.set((Integer)entry.getKey(), (NativeSignatureMatchResult)object);
            }
            catch (NativeSignatureScopeException nativeSignatureScopeException) {
                Object[] cfr_ignored_1 = new Object[0];
            }
        }
        return list;
    }

    private boolean canBeMatched(axk axk2, boolean bl) {
        if (axk2 == null) {
            return false;
        }
        if (axk2.isDisposed()) {
            return false;
        }
        if (axk2.mH() == null) {
            return false;
        }
        return bl || axk2.jR() == null;
    }

    public NativeSignatureGenerator getSignatureGenerator() {
        return this.signatureGenerator;
    }

    public File getUserCreatedPackageFolder() {
        return this.userCreatedPackageFolder;
    }

    public NativeSignaturePackageEntry getUserSelectedPackage(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        return this.userSelectedPackageStorage.get(iNativeCodeAnalyzer);
    }

    public void setUserSelectedPackage(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer, NativeSignaturePackageEntry nativeSignaturePackageEntry) {
        this.userSelectedPackageStorage.put(iNativeCodeAnalyzer, nativeSignaturePackageEntry);
    }

    @Override
    public void onEvent(IEvent iEvent) {
        if (iEvent.getType() == J.ProjectSaved) {
            this.updateOnDiskPackages(true);
        }
    }

    private static class SignatureMemoryStorage {
        private List<NativeSignaturePackageEntry> loadedPackages;
        private Map<Integer, Map<INativeSignature, INativeSignature>> signaturesDB;
        private Map<NativeFeatureSignerID, azk<IInstruction>> signersDB;
        private Map<Integer, Set<NativeFeatureSignerID>> routineSignersDB;
        private Map<String, Integer> occurences = new HashMap<String, Integer>();
        private Map<String, Integer> occurencesAlt = new HashMap<String, Integer>();

        public SignatureMemoryStorage(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
            this.loadedPackages = new ArrayList<NativeSignaturePackageEntry>();
            this.signaturesDB = new HashMap<Integer, Map<INativeSignature, INativeSignature>>();
            this.signersDB = cU.ce((aab)iNativeCodeAnalyzer);
            this.routineSignersDB = new HashMap<Integer, Set<NativeFeatureSignerID>>();
        }

        public boolean loadPackage(NativeSignaturePackageEntry nativeSignaturePackageEntry) {
            boolean bl;
            FileInputStream fileInputStream = new FileInputStream(nativeSignaturePackageEntry.getFile());
            try {
                csd csd2 = csd.ce();
                SerializationManager serializationManager = new SerializationManager(csd2);
                Deserializer deserializer = serializationManager.getDeserializer(fileInputStream);
                deserializer.deserialize();
                AD aD = (AD)deserializer.deserialize();
                for (INativeSignature iNativeSignature : aD.getSignatures()) {
                    INativeSignature iNativeSignature2;
                    int n2 = NativeSignatureDBManager.getRoutineSize(iNativeSignature);
                    if (n2 == 0) {
                        (new Object[1])[0] = iNativeSignature;
                        continue;
                    }
                    Map<INativeSignature, INativeSignature> map = this.signaturesDB.get(n2);
                    if (map == null) {
                        map = new HashMap<INativeSignature, INativeSignature>();
                        this.signaturesDB.put(n2, map);
                    }
                    if ((iNativeSignature2 = map.get(iNativeSignature)) != null) {
                        ((ca)iNativeSignature2).ce(nativeSignaturePackageEntry);
                    } else {
                        ((ca)iNativeSignature).ce(nativeSignaturePackageEntry);
                        map.put(iNativeSignature, iNativeSignature);
                    }
                    Set<NativeFeatureSignerID> set = this.routineSignersDB.get(n2);
                    if (set == null) {
                        set = new HashSet<NativeFeatureSignerID>();
                        this.routineSignersDB.put(n2, set);
                    }
                    for (INativeFeature iNativeFeature : ((ca)iNativeSignature).ce()) {
                        NativeFeatureSignerID nativeFeatureSignerID = cU.ce(iNativeFeature);
                        set.add(nativeFeatureSignerID);
                    }
                }
                nativeSignaturePackageEntry.incrementOpenHandle();
                this.loadedPackages.add(nativeSignaturePackageEntry);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    logger.error("Error when opening native signature package %s", nativeSignaturePackageEntry.getFile());
                    NativeSignatureDBManager.collectInformationDeserFailure(nativeSignaturePackageEntry.getFile(), "package loading", exception);
                    return false;
                }
            }
            fileInputStream.close();
            return bl;
        }

        public boolean isSafeSignatureList(List<INativeSignature> list) {
            List<String> list2;
            return list.size() == 1 && ((list2 = list.get(0).getPossibleNames()) == null || list2.size() <= 1);
        }

        public void registerPackageUsed(List<INativeSignature> list) {
            Map<String, Integer> map;
            Set<Object> set = new HashSet();
            if (list.isEmpty()) {
                return;
            }
            if (this.isSafeSignatureList(list)) {
                set = ((ca)list.get(0)).fz();
                map = this.occurences;
            } else {
                for (INativeSignature object : list) {
                    set.addAll(((ca)object).fz());
                }
                map = this.occurencesAlt;
            }
            for (String string : set) {
                Integer n2 = map.get(string);
                if (n2 == null) {
                    map.put(string, 1);
                    continue;
                }
                map.put(string, n2 + 1);
            }
        }

        private List<Couple<String, Integer>> fillOccurences(Set<String> set, boolean bl) {
            ArrayList<Couple<String, Integer>> arrayList = new ArrayList<Couple<String, Integer>>();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                Integer n2 = (bl ? this.occurencesAlt : this.occurences).get(string = iterator.next());
                if (n2 == null) continue;
                arrayList.add(new Couple<String, Integer>(string, n2));
            }
            return arrayList;
        }

        public List<Couple<String, Integer>> getBestPackages(List<INativeSignature> list) {
            HashSet<String> hashSet = new HashSet<String>();
            for (INativeSignature object2 : list) {
                hashSet.addAll(((ca)object2).fz());
            }
            if (hashSet.size() <= 1) {
                return null;
            }
            List<Couple<String, Integer>> list2 = this.fillOccurences(hashSet, false);
            if (list2.isEmpty()) {
                list2 = this.fillOccurences(hashSet, true);
            }
            Collections.sort(list2, (couple, couple2) -> {
                int n2 = ((Integer)couple2.getSecond()).compareTo((Integer)couple.getSecond());
                if (n2 != 0) {
                    return n2;
                }
                return ((String)couple.getFirst()).compareTo((String)couple2.getFirst());
            });
            ArrayList<Couple<String, Integer>> arrayList = new ArrayList<Couple<String, Integer>>();
            arrayList.add(list2.get(0));
            for (int i = 1; i < list2.size() && list2.get(i).getSecond().doubleValue() / list2.get(0).getSecond().doubleValue() >= 0.75; ++i) {
                arrayList.add(list2.get(i));
            }
            return arrayList;
        }

        public List<INativeSignature> findBestPackage(List<INativeSignature> list) {
            List<Couple<String, Integer>> list2 = this.getBestPackages(list);
            if (list2 == null) {
                return list;
            }
            ArrayList<INativeSignature> arrayList = new ArrayList<INativeSignature>(list);
            ArrayList<INativeSignature> arrayList2 = new ArrayList();
            for (Couple<String, Integer> couple : list2) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!((ca)arrayList.get(i)).fz().contains(couple.getFirst())) continue;
                    arrayList2.add((INativeSignature)arrayList.get(i));
                    arrayList.remove(i);
                    --i;
                }
            }
            if (arrayList2.isEmpty()) {
                arrayList2 = list;
            }
            this.updatePackageNames(list, list2);
            return arrayList2;
        }

        public void updatePackageNames(List<INativeSignature> list) {
            List<Couple<String, Integer>> list2 = this.getBestPackages(list);
            if (list2 == null) {
                return;
            }
            this.updatePackageNames(list, list2);
        }

        private void updatePackageNames(List<INativeSignature> list, List<Couple<String, Integer>> list2) {
            List list3 = list2.stream().map(couple -> (String)couple.getFirst()).collect(Collectors.toList());
            for (INativeSignature iNativeSignature : list) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                for (String string : list3) {
                    if (!((ca)iNativeSignature).fz().contains(string)) continue;
                    linkedHashSet.add(string);
                }
                if (linkedHashSet.isEmpty()) continue;
                ((qo)iNativeSignature).ce(linkedHashSet);
            }
        }
    }
}

