/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.render;

import com.pnfsoftware.jeb.core.units.code.asm.render.ConstantsFormatter;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.primitives.Longs;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.math.BigInteger;

@Ser
public class NumberFormatter {
    private static final int FLAG_FORCE_POSITIVE_RENDERING_FOR_NON_BASE10 = 1;
    @SerId(value=1)
    NumberBase base;
    @SerId(value=2)
    boolean signedNumber;
    @SerId(value=3)
    HexaNotationType hexaNotationType;
    @SerId(value=4)
    ConstantsFormatter cf;
    @SerId(value=5)
    int flags;

    public NumberFormatter() {
        this.base = NumberBase.HEXADECIMAL;
        this.signedNumber = false;
        this.hexaNotationType = HexaNotationType._h_suffix;
    }

    public NumberFormatter(NumberFormatter numberFormatter) {
        this.base = numberFormatter.base;
        this.signedNumber = numberFormatter.signedNumber;
        this.hexaNotationType = numberFormatter.hexaNotationType;
        this.flags = numberFormatter.flags;
    }

    public NumberBase getBase() {
        return this.base;
    }

    public void setBase(NumberBase numberBase) {
        if (numberBase == null) {
            throw new IllegalArgumentException();
        }
        this.cf = null;
        this.base = numberBase;
    }

    public NumberBase rotateBase() {
        NumberBase numberBase = this.getBase().nextBase();
        this.setBase(numberBase);
        return numberBase;
    }

    public void setSignedNumber(boolean bl) {
        this.cf = null;
        this.signedNumber = bl;
    }

    public boolean isSignedNumber() {
        return this.signedNumber;
    }

    public void setHexaNotationType(HexaNotationType hexaNotationType) {
        if (hexaNotationType == null) {
            throw new IllegalArgumentException();
        }
        this.cf = null;
        this.hexaNotationType = hexaNotationType;
    }

    public HexaNotationType getHexaNotationType() {
        return this.hexaNotationType;
    }

    public void setConstantsFormatterOverride(ConstantsFormatter constantsFormatter) {
        this.cf = constantsFormatter;
    }

    public boolean hasConstantsFormatterOverride() {
        return this.cf != null;
    }

    public void setForcePositiveRenderingForNonBase10(boolean bl) {
        this.flags |= 1;
    }

    public boolean getForcePositiveRenderingForNonBase10() {
        return (this.flags & 1) != 0;
    }

    public String format(int n2, long l2) {
        return this.format(n2, l2, this.base, this.signedNumber);
    }

    public String format(int n2, long l2, NumberBase numberBase, boolean bl) {
        if (this.cf != null) {
            return this.cf.format();
        }
        if (numberBase == null) {
            numberBase = this.base;
        }
        if (n2 < 64 && l2 < 0L) {
            bl = true;
        }
        Long l3 = n2 == 8 ? Long.valueOf((long)((byte)l2) & 0xFFL) : (n2 == 16 ? Long.valueOf((long)((short)l2) & 0xFFFFL) : (n2 == 32 ? Long.valueOf((long)((int)l2) & 0xFFFFFFFFL) : Long.valueOf(l2)));
        if (numberBase == NumberBase.DECIMAL || numberBase == NumberBase.HEXADECIMAL || numberBase == NumberBase.OCTAL) {
            boolean bl2 = false;
            if (bl && (numberBase == NumberBase.DECIMAL || !this.getForcePositiveRenderingForNonBase10())) {
                boolean bl3;
                boolean bl4 = bl3 = (l2 >> n2 - 1 & 1L) == 1L;
                if (bl3) {
                    switch (n2) {
                        case 8: {
                            l3 = -(l3 | 0xFFFFFFFFFFFFFF00L);
                            break;
                        }
                        case 16: {
                            l3 = -(l3 | 0xFFFFFFFFFFFF0000L);
                            break;
                        }
                        case 32: {
                            l3 = -(l3 | 0xFFFFFFFF00000000L);
                            break;
                        }
                        default: {
                            l3 = -l3.longValue();
                        }
                    }
                    bl2 = true;
                }
            }
            if (l3 >= 0L) {
                if (numberBase == NumberBase.HEXADECIMAL && l3 <= 9L) {
                    numberBase = NumberBase.DECIMAL;
                } else if (numberBase == NumberBase.OCTAL && l3 <= 7L) {
                    numberBase = NumberBase.DECIMAL;
                }
            }
            switch (numberBase) {
                case HEXADECIMAL: {
                    if (bl2) {
                        return "-" + this.hexaNotationType.prefix() + Long.toHexString(l3).toUpperCase() + this.hexaNotationType.suffix();
                    }
                    return this.hexaNotationType.prefix() + Long.toHexString(l3).toUpperCase() + this.hexaNotationType.suffix();
                }
                case OCTAL: {
                    if (bl2) {
                        return "-0" + Long.toOctalString(l3);
                    }
                    return "0" + Long.toOctalString(l3);
                }
                case DECIMAL: {
                    if (bl2) {
                        return "-" + Longs.toUnsignedString(l3);
                    }
                    return Longs.toUnsignedString(l3);
                }
            }
            throw new RuntimeException();
        }
        switch (numberBase) {
            case BINARY: {
                String string = Long.toBinaryString(l2);
                if (string.length() > n2) {
                    string = string.substring(string.length() - n2, string.length());
                }
                return Strings.f("b'%s", string);
            }
            case ASCII: {
                if (l2 != 0L && n2 % 8 == 0) {
                    long l4 = l2;
                    byte[] byArray = new byte[8];
                    int n3 = 8;
                    do {
                        byte by = (byte)l4;
                        byArray[--n3] = by;
                    } while ((l4 >>>= 8) != 0L);
                    return Strings.f("'%s'", Formatter.escapeBytes(byArray, n3, 8 - n3));
                }
                return Strings.f("%d", l3);
            }
        }
        return Strings.f("%d", l3);
    }

    public String format(int n2, BigInteger bigInteger) {
        return this.format(n2, bigInteger, this.base, this.signedNumber);
    }

    public String format(int n2, BigInteger bigInteger, NumberBase numberBase, boolean bl) {
        if (n2 <= 64) {
            return this.format(n2, bigInteger.longValue(), numberBase, bl);
        }
        if (this.cf != null) {
            return this.cf.format();
        }
        if (numberBase == null) {
            numberBase = this.base;
        }
        BigInteger bigInteger2 = bigInteger;
        switch (numberBase) {
            case HEXADECIMAL: {
                return Strings.f("%s%s%s", this.hexaNotationType.prefix(), bigInteger2.toString(16), this.hexaNotationType.suffix());
            }
            case DECIMAL: {
                return Strings.f("%s", bigInteger2.toString());
            }
            case ASCII: {
                if (n2 % 8 == 0) {
                    return Strings.f("'%s'", Formatter.escapeBytes(bigInteger2.toByteArray()));
                }
                return Strings.f("%s", bigInteger2);
            }
        }
        return Strings.f("%s", bigInteger2.toString());
    }

    @Ser
    public static enum HexaNotationType {
        _h_suffix("", "h"),
        _0x_prefix("0x", "");

        private final String prefix;
        private final String suffix;

        private HexaNotationType(String string2, String string3) {
            this.prefix = string2;
            this.suffix = string3;
        }

        public String prefix() {
            return this.prefix;
        }

        public String suffix() {
            return this.suffix;
        }
    }

    @Ser
    public static enum NumberBase {
        BINARY,
        OCTAL,
        DECIMAL,
        HEXADECIMAL,
        ASCII;


        public NumberBase nextBase() {
            switch (this) {
                case BINARY: {
                    return OCTAL;
                }
                case OCTAL: {
                    return DECIMAL;
                }
                case DECIMAL: {
                    return HEXADECIMAL;
                }
                case HEXADECIMAL: {
                    return ASCII;
                }
                case ASCII: {
                    return BINARY;
                }
            }
            throw new RuntimeException();
        }
    }
}

