/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.render;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.code.CodeDocumentPart;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.AutoLabelPolicy;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandList;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandSized;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterUtil;
import com.pnfsoftware.jeb.core.units.code.asm.render.AddressFormatter;
import com.pnfsoftware.jeb.core.units.code.asm.render.NumberFormatter;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.abb;
import com.pnfsoftware.jebglobal.axc;
import com.pnfsoftware.jebglobal.axp;

@Ser
public class GenericCodeFormatter<InsnType extends IInstruction> {
    public static final int MNEMONIC_RIGHT_PADDING_LENGTH_DEFAULT = 10;
    @SerId(value=1)
    abb<InsnType> pbcu;
    @SerId(value=2)
    IVirtualMemory mem;
    @SerId(value=3)
    Endianness endianness;
    @SerId(value=4)
    NumberFormatter defaultNumberFormatter = new NumberFormatter();
    @SerId(value=5)
    int mnemonicRightPaddingLength = 10;
    @SerId(value=6)
    WeakIdentityHashMap<IInstructionOperand, NumberFormatter> operandNumberFormatterMap = new WeakIdentityHashMap();
    @SerId(value=7)
    AddressFormatter defaultAddressFormatter = new AddressFormatter();
    @SerId(value=8)
    boolean doNotResolveImmAsAddr;

    public GenericCodeFormatter() {
    }

    public GenericCodeFormatter(IVirtualMemory iVirtualMemory) {
        this.mem = iVirtualMemory;
        this.endianness = iVirtualMemory.getStandardEndianess();
    }

    public void setCodeUnit(INativeCodeUnit<InsnType> iNativeCodeUnit) {
        this.pbcu = (abb)iNativeCodeUnit;
        this.mem = iNativeCodeUnit.getMemory();
        this.endianness = iNativeCodeUnit.getEndianness();
    }

    public INativeCodeUnit<InsnType> getCodeUnit() {
        return this.pbcu;
    }

    public IVirtualMemory getMemory() {
        return this.mem;
    }

    public Endianness getEndianness() {
        return this.endianness;
    }

    public String getRawDataDeclarator(int n2) {
        switch (n2) {
            case 8: {
                return "db";
            }
            case 16: {
                return "dw";
            }
            case 32: {
                return "dd";
            }
            case 64: {
                return "dq";
            }
        }
        Assert.a(n2 > 0);
        return "d" + n2;
    }

    public String getDataSeparator() {
        return ",";
    }

    public int getArrayElementPerLine() {
        return 10;
    }

    public void formatDataDeclarator(int n2, CodeDocumentPart codeDocumentPart) {
        String string = this.getRawDataDeclarator(n2 * 8);
        codeDocumentPart.appendAndRecord(string, ItemClassIdentifiers.KEYWORD);
        codeDocumentPart.space();
    }

    public String getProcedureDefinitionStart() {
        return "proc";
    }

    public String getProcedureDefinitionEnd() {
        return "endp";
    }

    public String getLabelPrefix() {
        return "";
    }

    public String getLabelSuffix() {
        return ":";
    }

    public String getOperandSeparator() {
        return ",";
    }

    public String getMemoryAccessSizeInfo(InsnType InsnType, IInstructionOperandSized iInstructionOperandSized) {
        return Strings.ff("ptr%d", iInstructionOperandSized.getOperandBitsize());
    }

    public String getMemoryAccessPrefix() {
        return "[";
    }

    public String getMemoryAccessSuffix() {
        return "]";
    }

    public String getMemoryAccessSegmentInfo(InsnType InsnType, IInstructionOperand iInstructionOperand) {
        return "";
    }

    public String getInlineCommentString() {
        return ";";
    }

    public String getMultiLineCommentBegin() {
        return "/*";
    }

    public String getMultiLineCommentEnd() {
        return "*/";
    }

    public String getRegisterName(long l2) {
        return "r" + l2;
    }

    public String generateHeader() {
        return " === Code Disassembly ===";
    }

    public String generateExtraSegmentHeader(ISegmentInformation iSegmentInformation) {
        return null;
    }

    public String generateExtraSectionHeader(ISegmentInformation iSegmentInformation) {
        return null;
    }

    public String generateExtraMethodComment(long l2) {
        return null;
    }

    public CharSequence generateExtraComment(long l2, InsnType InsnType) {
        return null;
    }

    public void formatInstruction(long l2, InsnType InsnType, CodeDocumentPart codeDocumentPart) {
        this.formatMnemonic(l2, InsnType, true, codeDocumentPart);
        this.formatOperands(l2, InsnType, codeDocumentPart);
    }

    protected int formatPrefix(long l2, InsnType InsnType, CodeDocumentPart codeDocumentPart) {
        String string = InsnType.getPrefix();
        if (string == null) {
            return 0;
        }
        codeDocumentPart.appendAndRecord(string, ItemClassIdentifiers.MNEMONIC_PREFIX);
        codeDocumentPart.space();
        return string.length() + 1;
    }

    protected void formatMnemonic(long l2, InsnType InsnType, boolean bl, CodeDocumentPart codeDocumentPart) {
        int n2 = 0;
        if (bl) {
            n2 = this.formatPrefix(l2, InsnType, codeDocumentPart);
        }
        String string = this.generateMnemonic(l2, InsnType);
        codeDocumentPart.appendAndRecord(string, ItemClassIdentifiers.MNEMONIC, this.createItemIdForMnemonic(InsnType));
        n2 += string.length();
        if (InsnType.getOperands() != null && InsnType.getOperands().length != 0) {
            int n3 = Math.max(1, this.mnemonicRightPaddingLength - n2);
            codeDocumentPart.space(n3);
        }
    }

    protected String generateMnemonic(long l2, InsnType InsnType) {
        return InsnType.getMnemonic();
    }

    public final void setMnemonicRightPaddingLength(int n2) {
        this.mnemonicRightPaddingLength = n2;
    }

    public final int getMnemonicRightPaddingLength() {
        return this.mnemonicRightPaddingLength;
    }

    protected void formatOperands(long l2, InsnType InsnType, CodeDocumentPart codeDocumentPart) {
        int n2 = 0;
        for (IInstructionOperand iInstructionOperand : InsnType.getOperands()) {
            if (n2 >= 1) {
                codeDocumentPart.append(this.getOperandSeparator());
                codeDocumentPart.space();
            }
            this.formatOperand(l2, InsnType, iInstructionOperand, n2, 0, codeDocumentPart);
            ++n2;
        }
    }

    public void formatOperand(long l2, InsnType InsnType, IInstructionOperand iInstructionOperand, int n2, int n3, CodeDocumentPart codeDocumentPart) {
        Object object;
        boolean bl = false;
        if (iInstructionOperand instanceof IInstructionOperandGeneric) {
            object = (IInstructionOperandGeneric)iInstructionOperand;
            bl = this.formatOperandGeneric(l2, InsnType, (IInstructionOperandGeneric)object, n2, n3, codeDocumentPart);
        }
        if (!bl) {
            object = iInstructionOperand.format((IInstruction)InsnType, l2);
            codeDocumentPart.append((String)object);
        }
    }

    protected final void addPrefix(InsnType InsnType, IInstructionOperandGeneric iInstructionOperandGeneric, CodeDocumentPart codeDocumentPart) {
        String string = iInstructionOperandGeneric.getPrefix((IInstruction)InsnType);
        if (string != null) {
            codeDocumentPart.append(string);
        }
    }

    protected final void addSuffix(InsnType InsnType, IInstructionOperandGeneric iInstructionOperandGeneric, CodeDocumentPart codeDocumentPart) {
        String string = iInstructionOperandGeneric.getSuffix((IInstruction)InsnType);
        if (string != null) {
            codeDocumentPart.append(string);
        }
    }

    private boolean formatOperandGeneric(long l2, InsnType InsnType, IInstructionOperandGeneric iInstructionOperandGeneric, int n2, int n3, CodeDocumentPart codeDocumentPart) {
        int n4 = iInstructionOperandGeneric.getOperandType();
        long l3 = iInstructionOperandGeneric.getOperandValue(l2);
        switch (n4) {
            case 0: {
                this.addPrefix(InsnType, iInstructionOperandGeneric, codeDocumentPart);
                this.formatRegister(l3, codeDocumentPart);
                break;
            }
            case 1: 
            case 9: {
                String string;
                this.addPrefix(InsnType, iInstructionOperandGeneric, codeDocumentPart);
                NumberFormatter numberFormatter = this.getNumberFormatter(iInstructionOperandGeneric, false);
                if (numberFormatter == null) {
                    if (!this.isDoNotAttemptImmediateToAddressResolution() && (string = this.pbcu.ce(l3, AutoLabelPolicy.ITEM)) != null) {
                        codeDocumentPart.append("offset ");
                        this.formatAddress(l3, codeDocumentPart);
                        break;
                    }
                    numberFormatter = this.getDefaultNumberFormatter();
                }
                string = numberFormatter.format(iInstructionOperandGeneric.getOperandBitsize(), l3, numberFormatter.getBase(), n4 == 1 ? numberFormatter.isSignedNumber() : true);
                codeDocumentPart.appendAndRecord(string, ItemClassIdentifiers.IMMEDIATE, this.createItemIdForImmediate(l2, n2));
                break;
            }
            case 2: {
                this.addPrefix(InsnType, iInstructionOperandGeneric, codeDocumentPart);
                this.formatAddress(l3, codeDocumentPart);
                break;
            }
            case 3: {
                this.addPrefix(InsnType, iInstructionOperandGeneric, codeDocumentPart);
                this.formatRelativeAddress(iInstructionOperandGeneric, l3, codeDocumentPart);
                break;
            }
            case 4: 
            case 5: {
                this.addPrefix(InsnType, iInstructionOperandGeneric, codeDocumentPart);
                codeDocumentPart.append(this.getMemoryAccessSizeInfo(InsnType, iInstructionOperandGeneric));
                codeDocumentPart.append(this.getMemoryAccessSegmentInfo(InsnType, iInstructionOperandGeneric));
                codeDocumentPart.append(this.getMemoryAccessPrefix());
                if (n4 == 4) {
                    this.formatRegister(l3, codeDocumentPart);
                } else {
                    this.formatAddress(l3, codeDocumentPart);
                }
                codeDocumentPart.append(this.getMemoryAccessSuffix());
                break;
            }
            case 6: {
                this.addPrefix(InsnType, iInstructionOperandGeneric, codeDocumentPart);
                codeDocumentPart.appendAndRecord(iInstructionOperandGeneric.getAlias(l3), ItemClassIdentifiers.KEYWORD);
                break;
            }
            case 7: {
                IInstructionOperandList iInstructionOperandList = (IInstructionOperandList)iInstructionOperandGeneric;
                IInstructionOperandGeneric iInstructionOperandGeneric2 = iInstructionOperandList.merge(l2);
                if (iInstructionOperandGeneric2 != null) {
                    this.formatOperand(l2, InsnType, iInstructionOperandGeneric2, n2, n3, codeDocumentPart);
                    return true;
                }
                this.addPrefix(InsnType, iInstructionOperandGeneric, codeDocumentPart);
                int n5 = n3 + 1;
                for (int i = 0; i < iInstructionOperandList.getOperands().length; ++i) {
                    if (i != 0) {
                        codeDocumentPart.append(iInstructionOperandList.getSeparator());
                    }
                    int n6 = n2 | i << 4 * n5;
                    this.formatOperand(l2, InsnType, iInstructionOperandList.getOperands()[i], n6, n5, codeDocumentPart);
                }
                break;
            }
            default: {
                return false;
            }
        }
        this.addSuffix(InsnType, iInstructionOperandGeneric, codeDocumentPart);
        return true;
    }

    public final void formatImm(long l2, IInstructionOperandSized iInstructionOperandSized, long l3, int n2, CodeDocumentPart codeDocumentPart) {
        String string;
        NumberFormatter numberFormatter = this.getNumberFormatter(iInstructionOperandSized, false);
        if (numberFormatter == null) {
            if (!this.isDoNotAttemptImmediateToAddressResolution() && (string = this.pbcu.ce(l3, AutoLabelPolicy.ITEM)) != null) {
                codeDocumentPart.append("offset ");
                this.formatAddress(l3, codeDocumentPart);
                return;
            }
            numberFormatter = this.getDefaultNumberFormatter();
        }
        string = numberFormatter.format(iInstructionOperandSized.getOperandBitsize(), l3);
        codeDocumentPart.appendAndRecord(string, ItemClassIdentifiers.IMMEDIATE, this.createItemIdForImmediate(l2, n2));
    }

    public final void formatAddress(long l2, CodeDocumentPart codeDocumentPart) {
        this.formatAddress(l2, null, codeDocumentPart);
    }

    public final void formatRelativeAddress(IInstructionOperandGeneric iInstructionOperandGeneric, long l2, CodeDocumentPart codeDocumentPart) {
        this.formatAddress(l2, iInstructionOperandGeneric, codeDocumentPart);
    }

    public void formatAddress(long l2, IInstructionOperandGeneric iInstructionOperandGeneric, CodeDocumentPart codeDocumentPart) {
        long l3;
        String string;
        INativeContinuousItem iNativeContinuousItem = this.pbcu.getNativeItemOver(l2);
        if (iInstructionOperandGeneric == null && iNativeContinuousItem != null && iNativeContinuousItem.getMemoryAddress() != l2) {
            long l4 = l2 - iNativeContinuousItem.getMemoryAddress();
            this.formatAddress(iNativeContinuousItem.getMemoryAddress(), iInstructionOperandGeneric, codeDocumentPart);
            codeDocumentPart.append("+");
            String string2 = this.getDefaultNumberFormatter().format(32, l4, NumberFormatter.NumberBase.HEXADECIMAL, false);
            codeDocumentPart.appendAndRecord(string2, ItemClassIdentifiers.NUMBER);
            return;
        }
        if (this.pbcu.ok(l2)) {
            string = this.getDefaultAddressFormatter().format(this.pbcu, this.mem.getSpaceBits(), l2, iInstructionOperandGeneric);
            l3 = this.createItemIdForAddress(l2);
        } else {
            string = this.getDefaultAddressFormatter().format(this.mem.getSpaceBits(), l2, iInstructionOperandGeneric);
            l3 = 0L;
        }
        ItemClassIdentifiers itemClassIdentifiers = this.getBestClassIdForAddress(l2);
        codeDocumentPart.appendAndRecord(string, itemClassIdentifiers, l3);
    }

    protected void formatRegister(long l2, CodeDocumentPart codeDocumentPart) {
        codeDocumentPart.appendAndRecord(this.getRegisterName(l2), ItemClassIdentifiers.REGISTER, this.createItemIdForDefaultRegister(l2));
    }

    public NumberFormatter getDefaultNumberFormatter() {
        return this.defaultNumberFormatter;
    }

    public NumberFormatter getNumberFormatter(INativeDataItem iNativeDataItem) {
        NumberFormatter numberFormatter = ((axc)iNativeDataItem).ce(false);
        if (numberFormatter == null) {
            numberFormatter = this.defaultNumberFormatter;
        }
        return numberFormatter;
    }

    public NumberFormatter getNumberFormatter(IInstructionOperand iInstructionOperand, boolean bl) {
        NumberFormatter numberFormatter = this.operandNumberFormatterMap.get(iInstructionOperand);
        if (numberFormatter == null && bl) {
            numberFormatter = new NumberFormatter(this.defaultNumberFormatter);
            this.operandNumberFormatterMap.put(iInstructionOperand, numberFormatter);
        }
        return numberFormatter;
    }

    public AddressFormatter getDefaultAddressFormatter() {
        return this.defaultAddressFormatter;
    }

    public ItemClassIdentifiers getBestClassIdForAddress(long l2) {
        INativeContinuousItem iNativeContinuousItem = this.pbcu.getNativeItemAt(l2);
        ItemClassIdentifiers itemClassIdentifiers = this.pbcu.ok(l2) ? (iNativeContinuousItem instanceof axp ? ItemClassIdentifiers.EXTERNAL_METHOD_NAME : (iNativeContinuousItem instanceof axc ? ItemClassIdentifiers.FIELD_NAME : (this.pbcu.mm(l2) != null ? ItemClassIdentifiers.METHOD_NAME : ItemClassIdentifiers.LABEL))) : ItemClassIdentifiers.LABEL;
        return itemClassIdentifiers;
    }

    public final long createItemIdForMnemonic(InsnType InsnType) {
        return this.pbcu.ce((IInstruction)InsnType);
    }

    public final long createItemIdForAddress(long l2) {
        return this.pbcu.hG(l2);
    }

    public final long createItemIdForImmediate(long l2, int n2) {
        return this.pbcu.ce(l2, n2);
    }

    public long createItemIdForDefaultRegister(long l2) {
        return this.createItemIdForRegister(RegisterUtil.getPureId(l2));
    }

    public final long createItemIdForRegister(long l2) {
        return this.pbcu.ZQ(l2);
    }

    public void setDoNotAttemptImmediateToAddressResolution(boolean bl) {
        this.doNotResolveImmAsAddr = bl;
    }

    public boolean isDoNotAttemptImmediateToAddressResolution() {
        return this.doNotResolveImmAsAddr;
    }
}

