/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.render;

import com.pnfsoftware.jeb.core.units.code.asm.type.CodeConstant;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Ser
public class ConstantsFormatter {
    @SerId(value=1)
    List<CodeConstant> constants;
    @SerId(value=2)
    Object leftOver;

    public ConstantsFormatter(CodeConstant codeConstant) {
        if (codeConstant == null) {
            throw new IllegalArgumentException();
        }
        this.constants = new ArrayList<CodeConstant>(1);
        this.constants.add(codeConstant);
    }

    public ConstantsFormatter(Collection<CodeConstant> collection) {
        this(collection, null);
    }

    public ConstantsFormatter(Collection<CodeConstant> collection, Object object) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.constants = new ArrayList<CodeConstant>(collection.size());
        this.constants.addAll(collection);
        this.leftOver = object;
    }

    public List<CodeConstant> getConstants() {
        return this.constants;
    }

    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (CodeConstant codeConstant : this.constants) {
            if (n2 >= 1) {
                stringBuilder.append("|");
            }
            stringBuilder.append(codeConstant.getName());
            ++n2;
        }
        if (this.leftOver != null) {
            stringBuilder.append("|").append(this.leftOver);
        }
        return stringBuilder.toString();
    }
}

