/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.render;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.render.NumberFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.abb;

@Ser
public class AddressFormatter {
    @SerId(value=1)
    AddressBase base;
    @SerId(value=2)
    String relativePrefix;
    @SerId(value=3)
    NumberFormatter.HexaNotationType hexaNotationType;

    public AddressFormatter() {
        this(AddressBase.LABEL, "PC+", NumberFormatter.HexaNotationType._h_suffix);
    }

    public AddressFormatter(AddressBase addressBase, String string, NumberFormatter.HexaNotationType hexaNotationType) {
        this.base = addressBase;
        this.relativePrefix = string;
        this.hexaNotationType = hexaNotationType;
    }

    public void setBase(AddressBase addressBase) {
        if (addressBase == null) {
            throw new IllegalArgumentException();
        }
        this.base = addressBase;
    }

    public AddressBase getBase() {
        return this.base;
    }

    public void setRelativePrefix(String string) {
        if (string == null) {
            string = "";
        }
        this.relativePrefix = string;
    }

    public String getRelativePrefix() {
        return this.relativePrefix;
    }

    public void setHexaNotationType(NumberFormatter.HexaNotationType hexaNotationType) {
        if (hexaNotationType == null) {
            throw new IllegalArgumentException();
        }
        this.hexaNotationType = hexaNotationType;
    }

    public NumberFormatter.HexaNotationType getHexaNotationType() {
        return this.hexaNotationType;
    }

    public String format(INativeCodeUnit<?> iNativeCodeUnit, int n2, long l2, IInstructionOperandGeneric iInstructionOperandGeneric) {
        return this.format(iNativeCodeUnit, n2, l2, iInstructionOperandGeneric, this.base);
    }

    public String format(int n2, long l2, IInstructionOperandGeneric iInstructionOperandGeneric) {
        if (this.base == null || this.base == AddressBase.LABEL) {
            return this.format(null, n2, l2, iInstructionOperandGeneric, AddressBase.ABSOLUTE_ADDRESS);
        }
        return this.format(null, n2, l2, iInstructionOperandGeneric, this.base);
    }

    public String format(INativeCodeUnit<?> iNativeCodeUnit, int n2, long l2, IInstructionOperandGeneric iInstructionOperandGeneric, AddressBase addressBase) {
        if (addressBase == null) {
            addressBase = this.base;
        }
        if (iInstructionOperandGeneric == null && (addressBase == AddressBase.RELATIVE_ADDRESS_D || addressBase == AddressBase.RELATIVE_ADDRESS_H)) {
            addressBase = AddressBase.ABSOLUTE_ADDRESS;
        }
        switch (addressBase) {
            default: {
                return ((abb)iNativeCodeUnit).mH(l2);
            }
            case ABSOLUTE_ADDRESS: {
                return Strings.f("%s%X%s", this.hexaNotationType.prefix(), this.getValue(n2, l2), this.hexaNotationType.suffix());
            }
            case RELATIVE_ADDRESS_H: {
                return Strings.f("%s%s%X%s", this.relativePrefix, this.hexaNotationType.prefix(), this.getValue(n2, iInstructionOperandGeneric.getOperandValue()), this.hexaNotationType.suffix());
            }
            case RELATIVE_ADDRESS_D: 
        }
        long l3 = iInstructionOperandGeneric.getOperandValue();
        Long l4 = n2 == 16 ? Long.valueOf((short)l3) : (n2 == 32 ? Long.valueOf((int)l3) : Long.valueOf(l3));
        if (l4 >= 0L) {
            return Strings.f("%s%d", this.relativePrefix, l4);
        }
        String string = this.relativePrefix;
        int n3 = this.relativePrefix.lastIndexOf("+");
        if (n3 >= 0) {
            string = Strings.replaceLast(this.relativePrefix, "+", "-");
            l4 = -l4.longValue();
        }
        return Strings.f("%s%d", string, l4);
    }

    private Long getValue(int n2, long l2) {
        Long l3 = n2 == 16 ? Long.valueOf((long)((short)l2) & 0xFFFFL) : (n2 == 32 ? Long.valueOf((long)((int)l2) & 0xFFFFFFFFL) : Long.valueOf(l2));
        return l3;
    }

    @Ser
    public static enum AddressBase {
        LABEL,
        ABSOLUTE_ADDRESS,
        RELATIVE_ADDRESS_H,
        RELATIVE_ADDRESS_D;


        public AddressBase nextBase() {
            switch (this) {
                case LABEL: {
                    return ABSOLUTE_ADDRESS;
                }
                case ABSOLUTE_ADDRESS: {
                    return RELATIVE_ADDRESS_H;
                }
                case RELATIVE_ADDRESS_H: {
                    return RELATIVE_ADDRESS_D;
                }
                case RELATIVE_ADDRESS_D: {
                    return LABEL;
                }
            }
            throw new RuntimeException();
        }
    }
}

