/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor.memory;

import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.IEncodedMemoryArea;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.math.MathUtil;

public class EncodedMemoryAreaUtil {
    public static int signExtendInt(byte[] byArray, IEncodedMemoryArea iEncodedMemoryArea) {
        int n2 = iEncodedMemoryArea.getLength();
        int n3 = EncodedMemoryAreaUtil.zeroExtend(byArray, iEncodedMemoryArea);
        return MathUtil.signExtend32(n3, n2);
    }

    public static long signExtendLong(byte[] byArray, IEncodedMemoryArea iEncodedMemoryArea) {
        int n2 = iEncodedMemoryArea.getLength();
        long l2 = EncodedMemoryAreaUtil.zeroExtendLong(byArray, iEncodedMemoryArea);
        return MathUtil.signExtend(l2, n2);
    }

    public static int zeroExtend(byte[] byArray, IEncodedMemoryArea iEncodedMemoryArea) {
        int n2 = 0;
        if (iEncodedMemoryArea == null) {
            return n2;
        }
        return (int)iEncodedMemoryArea.decode(byArray);
    }

    public static long zeroExtendLong(byte[] byArray, IEncodedMemoryArea ... iEncodedMemoryAreaArray) {
        long l2 = 0L;
        if (iEncodedMemoryAreaArray == null || iEncodedMemoryAreaArray.length == 0) {
            return l2;
        }
        for (IEncodedMemoryArea iEncodedMemoryArea : iEncodedMemoryAreaArray) {
            l2 = l2 << iEncodedMemoryArea.getLength() | iEncodedMemoryArea.decode(byArray);
        }
        return l2;
    }

    public static long zeroExtend(byte[] byArray, int n2, int n3) {
        long l2 = EncodedMemoryAreaUtil.getValue(byArray, n2);
        return MathUtil.zeroExtend(l2, n3);
    }

    private static long getValue(byte[] byArray, int n2) {
        return EncodedMemoryAreaUtil.getValue(byArray) >>> n2;
    }

    private static long getValue(byte[] byArray) {
        if (byArray.length == 2) {
            return EndianUtil.bigEndianBytesToShort(byArray) & 0xFFFFFFFF;
        }
        if (byArray.length == 4) {
            return EndianUtil.bigEndianBytesToInt(byArray) & 0xFFFFFFFF;
        }
        if (byArray.length == 8) {
            return EndianUtil.bigEndianBytesToLong(byArray);
        }
        return 0L;
    }
}

