/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor.memory;

import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.AbstractEncodedMemoryArea;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.DirectEncodedMemoryArea;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.EncodedMemoryAreaUtil;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.IEncodedMemoryArea;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.VirtualEncodedMemoryArea;

public class EncodedMemoryAreaList
extends AbstractEncodedMemoryArea {
    private IEncodedMemoryArea[] memoryAreas;

    public EncodedMemoryAreaList(IEncodedMemoryArea ... iEncodedMemoryAreaArray) {
        this.memoryAreas = iEncodedMemoryAreaArray;
    }

    @Override
    public int getLength() {
        int n2 = 0;
        for (IEncodedMemoryArea iEncodedMemoryArea : this.memoryAreas) {
            n2 += iEncodedMemoryArea.getLength();
        }
        return n2;
    }

    @Override
    public long decode(byte[] byArray) {
        return EncodedMemoryAreaUtil.zeroExtendLong(byArray, this.memoryAreas);
    }

    public static EncodedMemoryAreaList shift(IEncodedMemoryArea iEncodedMemoryArea, int n2) {
        return new EncodedMemoryAreaList(iEncodedMemoryArea, VirtualEncodedMemoryArea.get(0, n2));
    }

    public static EncodedMemoryAreaList fromBits(int ... nArray) {
        IEncodedMemoryArea[] iEncodedMemoryAreaArray = new IEncodedMemoryArea[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            iEncodedMemoryAreaArray[i] = DirectEncodedMemoryArea.get(nArray[i], 1);
        }
        return new EncodedMemoryAreaList(iEncodedMemoryAreaArray);
    }
}

