/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor.memory;

import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.AbstractEncodedMemoryArea;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.EncodedMemoryAreaList;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.EncodedMemoryAreaUtil;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.VirtualEncodedMemoryArea;
import java.util.WeakHashMap;

public class DirectEncodedMemoryArea
extends AbstractEncodedMemoryArea {
    private static WeakHashMap<Integer, DirectEncodedMemoryArea> cache = new WeakHashMap();
    private int index;
    private int length;

    protected DirectEncodedMemoryArea(int n2, int n3) {
        this.index = n2;
        this.length = n3;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public static DirectEncodedMemoryArea get(int n2, int n3) {
        int n4 = n2 + (n3 << 6);
        DirectEncodedMemoryArea directEncodedMemoryArea = cache.get(n4);
        if (directEncodedMemoryArea == null) {
            directEncodedMemoryArea = new DirectEncodedMemoryArea(n2, n3);
            cache.put(n4, directEncodedMemoryArea);
        }
        return directEncodedMemoryArea;
    }

    public static int decodeInt(int n2, int n3, byte[] byArray) {
        return DirectEncodedMemoryArea.get(n2, n3).decodeInt(byArray);
    }

    public static DirectEncodedMemoryArea getThumb2(int n2, int n3, int n4) {
        return DirectEncodedMemoryArea.get(n2 + n3 * 16, n4);
    }

    @Override
    public long decode(byte[] byArray) {
        return EncodedMemoryAreaUtil.zeroExtend(byArray, this.index, this.length);
    }

    public EncodedMemoryAreaList shift(int n2) {
        return new EncodedMemoryAreaList(this, VirtualEncodedMemoryArea.get(0, n2));
    }
}

