/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor.arch;

import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterData;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterBankService;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterType;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankArm;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankArm64;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankMips;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankMips64;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankX64;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterBankX86;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;

public class RegisterUtil {
    public static IRegisterBank getBank(ProcessorType processorType) {
        if (processorType == ProcessorType.X86) {
            return RegisterBankX86.getInstance();
        }
        if (processorType == ProcessorType.X86_64) {
            return RegisterBankX64.getInstance();
        }
        if (processorType == ProcessorType.ARM) {
            return RegisterBankArm.getInstance();
        }
        if (processorType == ProcessorType.ARM64) {
            return RegisterBankArm64.getInstance();
        }
        if (processorType == ProcessorType.MIPS) {
            return RegisterBankMips.getInstance();
        }
        if (processorType == ProcessorType.MIPS64) {
            return RegisterBankMips64.getInstance();
        }
        return RegisterBankService.getInstance().get(processorType);
    }

    public static long createRegisterId(int n2, int n3, int n4) {
        return RegisterUtil.createRegisterId(n2, n3, n4, 0);
    }

    public static long createRegisterId(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n2 > 1048575 || n3 < 0 || n3 > 4095 || n4 < 0 || n4 > 4095 || n5 < 0 || n5 > 4095) {
            throw new IllegalArgumentException();
        }
        long l2 = (long)n5 << 44 | (long)n4 << 32 | (long)n3 << 20 | (long)n2;
        return l2;
    }

    public static long createPureRegisterId(int n2, int n3) {
        return RegisterUtil.createRegisterId(n2, n3, 0, 0);
    }

    public static long createRegisterIdFromPureId(long l2, int n2, int n3) {
        if ((l2 & 0xFFFFFFFF00000000L) != 0L || n2 < 0 || n2 > 4095 || n3 < 0 || n3 > 4095) {
            throw new IllegalArgumentException();
        }
        long l3 = (long)n3 << 44 | (long)n2 << 32 | l2;
        return l3;
    }

    public static boolean isPureId(long l2) {
        return (l2 & 0xFFFFFFFF00000000L) == 0L;
    }

    public static long getPureId(long l2) {
        return l2 & 0xFFFFFFFFL;
    }

    public static int getRegisterIndex(long l2) {
        return (int)l2 & 0xFFFFF;
    }

    public static int getRegisterGroup(long l2) {
        return (int)(l2 >> 20) & 0xFFF;
    }

    public static int getRegisterBitsize(long l2) {
        return (int)(l2 >> 32) & 0xFFF;
    }

    public static int getRegisterBitstart(long l2) {
        return (int)(l2 >> 44) & 0xFFF;
    }

    public static RegisterDescriptionEntry getEntryByType(IRegisterBank iRegisterBank, RegisterType registerType) {
        for (RegisterDescriptionEntry registerDescriptionEntry : iRegisterBank.getDescriptionEntries()) {
            if (registerDescriptionEntry.getType() != registerType) continue;
            return registerDescriptionEntry;
        }
        return null;
    }

    public static RegisterDescriptionEntry getEntryByType(IRegisterData iRegisterData, RegisterType registerType) {
        return RegisterUtil.getEntryByType(iRegisterData.getBank(), registerType);
    }

    public static RegisterDescriptionEntry getEntryByName(IRegisterBank iRegisterBank, String string) {
        for (RegisterDescriptionEntry registerDescriptionEntry : iRegisterBank.getDescriptionEntries()) {
            if (!registerDescriptionEntry.hasName(string)) continue;
            return registerDescriptionEntry;
        }
        return null;
    }

    public static RegisterDescriptionEntry getEntryByName(IRegisterData iRegisterData, String string) {
        return RegisterUtil.getEntryByName(iRegisterData.getBank(), string);
    }

    public static byte[] getValueByName(IRegisterData iRegisterData, String string) {
        RegisterDescriptionEntry registerDescriptionEntry = RegisterUtil.getEntryByName(iRegisterData, string);
        if (registerDescriptionEntry == null) {
            return null;
        }
        return iRegisterData.getValue(registerDescriptionEntry.getNumber());
    }

    public static Long getValueByNameAsLong(IRegisterData iRegisterData, String string) {
        RegisterDescriptionEntry registerDescriptionEntry = RegisterUtil.getEntryByName(iRegisterData, string);
        if (registerDescriptionEntry == null) {
            return null;
        }
        return iRegisterData.getValueAsLong(registerDescriptionEntry.getNumber());
    }

    public static boolean setValueByName(IRegisterData iRegisterData, String string, byte[] byArray) {
        RegisterDescriptionEntry registerDescriptionEntry = RegisterUtil.getEntryByName(iRegisterData, string);
        if (registerDescriptionEntry == null) {
            return false;
        }
        return iRegisterData.setValue(registerDescriptionEntry.getNumber(), byArray);
    }

    public static boolean setValueByNameAsLong(IRegisterData iRegisterData, String string, long l2) {
        RegisterDescriptionEntry registerDescriptionEntry = RegisterUtil.getEntryByName(iRegisterData, string);
        if (registerDescriptionEntry == null) {
            return false;
        }
        return iRegisterData.setValueAsLong(registerDescriptionEntry.getNumber(), l2);
    }

    public static String byteArrayToHex(Endianness endianness, byte[] byArray) {
        return RegisterUtil.byteArrayToHex(endianness, byArray, 0, byArray.length);
    }

    public static String byteArrayToHex(Endianness endianness, byte[] byArray, int n2, int n3) {
        if (byArray == null || n2 < 0 || n3 > byArray.length || n2 > n3) {
            throw new IllegalArgumentException();
        }
        int n4 = n3 - n2;
        switch (n4) {
            case 1: {
                return Strings.ff("0x%02X", byArray[n2]);
            }
            case 2: {
                return Strings.ff("0x%04X", EndianUtil.bytesToShort(byArray, n2, endianness.toByteOrder()));
            }
            case 4: {
                return Strings.ff("0x%08X", EndianUtil.bytesToInt(byArray, n2, endianness.toByteOrder()));
            }
            case 8: {
                return Strings.ff("0x%016X", EndianUtil.bytesToLong(byArray, n2, endianness.toByteOrder()));
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2; i < n3; ++i) {
            Strings.ff(stringBuilder, "%02X", byArray[i]);
        }
        return stringBuilder.toString();
    }
}

