/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor.arch;

import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterType;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.AbstractRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterUtil;
import java.util.Map;
import java.util.TreeMap;

public class RegisterBankArm
extends AbstractRegisterBank {
    public static final int regGrp_GP = 0;
    public static final int regGrp_BANKED = 2;
    public static final int regGrp_COPROC = 4;
    public static final int regGrp_SIMD = 6;
    public static final int regGrp_FP_SYSTEM = 8;
    public static final int regGrp_Flags = 11;
    private static final Map<Integer, RegisterDescriptionEntry> entries;
    private static final String UNPREDICTABLE = "UNPREDICTABLE";
    private static String[] StatusRegisters;
    public static final int APSR_nzcv;
    public static final int APSR;
    public static final int SPSR;
    private static String[] BankedRegisters;
    private static String[] floatingPointSystemRegisters;
    private static RegisterBankArm instance;

    public static synchronized RegisterBankArm getInstance() {
        if (instance == null) {
            instance = new RegisterBankArm();
        }
        return instance;
    }

    private RegisterBankArm() {
    }

    @Override
    public Map<Integer, RegisterDescriptionEntry> getDescriptionEntryMap() {
        return entries;
    }

    public static long getSpId() {
        return RegisterUtil.createPureRegisterId(13, 0);
    }

    static {
        int n2;
        entries = new TreeMap<Integer, RegisterDescriptionEntry>();
        StatusRegisters = new String[]{null, "CPSR_c", "CPSR_x", "CPSR_xc", "APSR_g", "CPSR_sc", "CPSR_sx", "CPSR_sxc", "APSR_nzcvq", "CPSR_fc", "CPSR_fx", "CPSR_fxc", "APSR_nzcvqg", "CPSR_fsc", "CPSR_fsx", "CPSR_fsxc", null, "SPSR_c", "SPSR_x", "SPSR_xc", "SPSR_s", "SPSR_sc", "SPSR_sx", "SPSR_sxc", "SPSR_f", "SPSR_fc", "SPSR_fx", "SPSR_fxc", "SPSR_fs", "SPSR_fsc", "SPSR_fsx", "SPSR_fsxc"};
        APSR_nzcv = StatusRegisters.length;
        APSR = StatusRegisters.length + 1;
        SPSR = StatusRegisters.length + 2;
        BankedRegisters = new String[]{"R8_usr", "R9_usr", "R10_usr", "R11_usr", "R12_usr", "SP_usr", "LR_usr", UNPREDICTABLE, "R8_fiq", "R9_fiq", "R10_fiq", "R11_fiq", "R12_fiq", "SP_fiq", "LR_fiq", UNPREDICTABLE, "LR_irq", "SP_irq", "LR_svc", "SP_svc", "LR_abt", "SP_abt", "LR_und", "SP_und", UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, "LR_mon", "SP_mon", "ELR_hyp", "SP_hyp", UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, "SPSR_fiq", UNPREDICTABLE, "SPSR_irq", UNPREDICTABLE, "SPSR_svc", UNPREDICTABLE, "SPSR_abt", UNPREDICTABLE, "SPSR_und", UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, UNPREDICTABLE, "SPSR_mon", UNPREDICTABLE, "SPSR_hyp", UNPREDICTABLE};
        floatingPointSystemRegisters = new String[]{"FPSID", "FPSCR", "#2", "#3", "#4", "MVFR2", "MVFR1", "MVFR0", "FPEXC", "FPINST", "FPINST2", "#11", "#12", "#13", "#14", "#15"};
        for (n2 = 0; n2 < 13; ++n2) {
            RegisterBankArm.add(entries, 32, "R" + n2).grp(0, n2);
        }
        RegisterBankArm.add(entries, 32, "SP").grp(0, 13).typ(RegisterType.StackPointer);
        RegisterBankArm.add(entries, 32, "LR").grp(0, 14);
        RegisterBankArm.add(entries, 32, "PC").grp(0, 15).typ(RegisterType.ProgramCounter);
        RegisterBankArm.add(entries, 32, "CPSR").grp(11, 0).typ(RegisterType.Flags);
        for (n2 = 0; n2 < 16; ++n2) {
            if (StatusRegisters[n2] == null) continue;
            RegisterBankArm.add(entries, 32, StatusRegisters[n2]).grp(11, n2);
        }
        RegisterBankArm.add(entries, 32, "APSR_nzcv").grp(11, APSR_nzcv);
        RegisterBankArm.add(entries, 32, "APSR").grp(11, APSR);
        RegisterBankArm.add(entries, 32, "SPSR").grp(11, SPSR);
        for (n2 = 16; n2 < StatusRegisters.length; ++n2) {
            if (StatusRegisters[n2] == null) continue;
            RegisterBankArm.add(entries, 32, StatusRegisters[n2]).grp(11, n2);
        }
        for (n2 = 0; n2 < BankedRegisters.length; ++n2) {
            RegisterBankArm.add(entries, 32, BankedRegisters[n2]).grp(2, n2);
        }
        for (n2 = 0; n2 < 16; ++n2) {
            RegisterBankArm.add(entries, 32, "c" + n2).grp(4, n2);
        }
        for (n2 = 0; n2 < floatingPointSystemRegisters.length; ++n2) {
            RegisterBankArm.add(entries, 32, floatingPointSystemRegisters[n2]).grp(8, n2);
        }
        for (n2 = 0; n2 < 16; ++n2) {
            int n3 = n2 * 2;
            RegisterDescriptionEntry registerDescriptionEntry = RegisterBankArm.add(entries, 128, "Q" + n2).sl("D" + n3, 64).sl("D" + (n3 + 1), 64, 128).grp(6, n2);
            if (n2 >= 8) continue;
            int n4 = n2 * 4;
            registerDescriptionEntry.sl("S" + n4, 32).sl("S" + (n4 + 1), 32, 64).sl("S" + (n4 + 2), 64, 96).sl("S" + (n4 + 3), 96, 128);
        }
    }
}

