/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor.arch;

import com.pnfsoftware.jeb.core.units.code.asm.processor.CannotReadRegisterException;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterData;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterType;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.AbstractRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractRegisterData
implements IRegisterData {
    private AbstractRegisterBank layout;
    private Endianness endianness;
    protected Map<Integer, byte[]> values = new HashMap<Integer, byte[]>();
    protected Set<Integer> dirtyRegisters = new TreeSet<Integer>();

    public AbstractRegisterData(AbstractRegisterBank abstractRegisterBank, Endianness endianness) {
        if (abstractRegisterBank == null) {
            throw new NullPointerException("Need a bank register layout");
        }
        if (endianness == null) {
            throw new NullPointerException("Need byte ordering");
        }
        this.layout = abstractRegisterBank;
        this.endianness = endianness;
    }

    @Override
    public AbstractRegisterBank getBank() {
        return this.layout;
    }

    @Override
    public Endianness getEndianness() {
        return this.endianness;
    }

    Collection<RegisterDescriptionEntry> getDescriptionEntries() {
        return this.layout.getDescriptionEntries();
    }

    RegisterDescriptionEntry getDescriptionEntry(int n2) {
        return this.layout.getDescriptionEntry(n2);
    }

    int getCountOfDescriptionEntries() {
        return this.layout.getCountOfDescriptionEntries();
    }

    @Override
    public int size() {
        return this.getCountOfDescriptionEntries();
    }

    @Override
    public String getName(int n2) {
        return this.getDescriptionEntry(n2).getName();
    }

    @Override
    public int getBitsize(int n2) {
        return this.getDescriptionEntry(n2).getBitsize();
    }

    public int getSize(int n2) {
        return this.getDescriptionEntry(n2).getSize();
    }

    @Override
    public byte[] getValue(int n2) {
        return this.values.get(n2);
    }

    @Override
    public Long getValueAsLong(int n2) {
        byte[] byArray = this.values.get(n2);
        if (byArray == null) {
            return null;
        }
        RegisterDescriptionEntry registerDescriptionEntry = this.getDescriptionEntry(n2);
        if (byArray.length != registerDescriptionEntry.getSize()) {
            return null;
        }
        switch (registerDescriptionEntry.getBitsize()) {
            case 8: {
                return (long)byArray[0] & 0xFFL;
            }
            case 16: {
                return (long)EndianUtil.bytesToShort(byArray, 0, this.endianness.toByteOrder()) & 0xFFFFL;
            }
            case 32: {
                return (long)EndianUtil.bytesToInt(byArray, 0, this.endianness.toByteOrder()) & 0xFFFFFFFFL;
            }
            case 64: {
                return EndianUtil.bytesToLong(byArray, 0, this.endianness.toByteOrder());
            }
        }
        return null;
    }

    @Override
    public boolean setValue(int n2, byte[] byArray) {
        if (byArray != null && byArray.length != this.getSize(n2)) {
            return false;
        }
        byte[] byArray2 = this.values.get(n2);
        if (Arrays.equals(byArray2, byArray)) {
            return true;
        }
        this.values.put(n2, byArray);
        this.dirtyRegisters.add(n2);
        return true;
    }

    @Override
    public boolean setValueAsLong(int n2, long l2) {
        byte[] byArray;
        block13: {
            int n3;
            block12: {
                n3 = this.getSize(n2);
                byArray = new byte[n3];
                if (!this.endianness.isBig()) break block12;
                switch (n3) {
                    case 1: {
                        byArray[0] = (byte)l2;
                        break block13;
                    }
                    case 2: {
                        EndianUtil.shortToBEBytes((short)l2, byArray);
                        break block13;
                    }
                    case 4: {
                        EndianUtil.intToBEBytes((int)l2, byArray);
                        break block13;
                    }
                    case 8: {
                        EndianUtil.longToBEBytes(l2, byArray);
                        break block13;
                    }
                    default: {
                        return false;
                    }
                }
            }
            switch (n3) {
                case 1: {
                    byArray[0] = (byte)l2;
                    break;
                }
                case 2: {
                    EndianUtil.shortToLEBytes((short)l2, byArray);
                    break;
                }
                case 4: {
                    EndianUtil.intToLEBytes((int)l2, byArray);
                    break;
                }
                case 8: {
                    EndianUtil.longToLEBytes(l2, byArray);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        this.setValue(n2, byArray);
        return true;
    }

    public Set<Integer> getDirtyRegisters() {
        return this.dirtyRegisters;
    }

    public boolean isDirty(int n2) {
        return this.dirtyRegisters.contains(n2);
    }

    public void setDirty(int n2) {
        this.dirtyRegisters.add(n2);
    }

    public void setAllDirty() {
        this.dirtyRegisters.addAll(this.values.keySet());
    }

    public void clearDirty(int n2) {
        this.dirtyRegisters.remove(n2);
    }

    public void clearAllDirty() {
        this.dirtyRegisters.clear();
    }

    @Override
    public long getProgramCounter() throws CannotReadRegisterException {
        RegisterDescriptionEntry registerDescriptionEntry = this.layout.getDescriptionEntryByType(RegisterType.ProgramCounter);
        if (registerDescriptionEntry == null) {
            throw new CannotReadRegisterException(RegisterType.ProgramCounter);
        }
        Long l2 = this.getValueAsLong(registerDescriptionEntry.getNumber());
        if (l2 == null) {
            throw new CannotReadRegisterException(RegisterType.ProgramCounter);
        }
        return l2;
    }

    @Override
    public long getFlags() throws CannotReadRegisterException {
        RegisterDescriptionEntry registerDescriptionEntry = this.layout.getDescriptionEntryByType(RegisterType.Flags);
        if (registerDescriptionEntry == null) {
            throw new CannotReadRegisterException(RegisterType.Flags);
        }
        Long l2 = this.getValueAsLong(registerDescriptionEntry.getNumber());
        if (l2 == null) {
            throw new CannotReadRegisterException(RegisterType.Flags);
        }
        return l2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (RegisterDescriptionEntry registerDescriptionEntry : this.getDescriptionEntries()) {
            int n3 = registerDescriptionEntry.getNumber();
            byte[] byArray = this.getValue(n3);
            if (byArray == null) continue;
            if (n2 > 0 && n2 % 4 == 0) {
                stringBuilder.append("\n");
            }
            Strings.ff(stringBuilder, "%s:%s ", this.getName(n3), RegisterUtil.byteArrayToHex(this.endianness, byArray));
            ++n2;
        }
        return stringBuilder.toString();
    }
}

