/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor.arch;

import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterEncoding;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterType;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRegisterBank
implements IRegisterBank {
    public static final int REG_GRP_GP = 0;
    public static final int REG_GRP_SPECIAL = 1;
    private volatile Map<String, RegisterDescriptionEntry> namemap;
    private volatile Map<Long, RegisterDescriptionEntry> idmap;

    protected static RegisterDescriptionEntry add(Map<Integer, RegisterDescriptionEntry> map, int n2, String string, String string2, RegisterEncoding registerEncoding, RegisterType registerType) {
        int n3 = map.size();
        RegisterDescriptionEntry registerDescriptionEntry = new RegisterDescriptionEntry(n3, string, n2, null, string2, registerType, -1);
        if (map.put(registerDescriptionEntry.getNumber(), registerDescriptionEntry) != null) {
            throw new RuntimeException("Duplicate RegisterDescriptionEntry for number " + registerDescriptionEntry.getNumber());
        }
        return registerDescriptionEntry;
    }

    protected static RegisterDescriptionEntry add(Map<Integer, RegisterDescriptionEntry> map, int n2, String string, String string2) {
        return AbstractRegisterBank.add(map, n2, string, string2, null, null);
    }

    protected static RegisterDescriptionEntry add(Map<Integer, RegisterDescriptionEntry> map, int n2, String string) {
        return AbstractRegisterBank.add(map, n2, string, null, null, null);
    }

    @Override
    public Collection<RegisterDescriptionEntry> getDescriptionEntries() {
        return Collections.unmodifiableCollection(this.getDescriptionEntryMap().values());
    }

    public abstract Map<Integer, RegisterDescriptionEntry> getDescriptionEntryMap();

    @Override
    public RegisterDescriptionEntry getDescriptionEntry(int n2) {
        return this.getDescriptionEntryMap().get(n2);
    }

    @Override
    public int getCountOfDescriptionEntries() {
        return this.getDescriptionEntries().size();
    }

    @Override
    public Collection<RegisterDescriptionEntry> getAllDescriptionEntries() {
        ArrayList<RegisterDescriptionEntry> arrayList = new ArrayList<RegisterDescriptionEntry>();
        for (RegisterDescriptionEntry registerDescriptionEntry : this.getDescriptionEntries()) {
            arrayList.add(registerDescriptionEntry);
            arrayList.addAll(registerDescriptionEntry.getSlices());
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public RegisterDescriptionEntry getDescriptionEntryByName(String string) {
        return this.getByNameCache().get(string.toLowerCase());
    }

    @Override
    public RegisterDescriptionEntry getDescriptionEntryByName(Collection<String> collection) {
        Map<String, RegisterDescriptionEntry> map = this.getByNameCache();
        for (String string : collection) {
            RegisterDescriptionEntry registerDescriptionEntry = map.get(string.toLowerCase());
            if (registerDescriptionEntry == null) continue;
            return registerDescriptionEntry;
        }
        return null;
    }

    private Map<String, RegisterDescriptionEntry> getByNameCache() {
        if (this.namemap == null) {
            AbstractRegisterBank abstractRegisterBank = this;
            synchronized (abstractRegisterBank) {
                if (this.namemap == null) {
                    HashMap<String, RegisterDescriptionEntry> hashMap = new HashMap<String, RegisterDescriptionEntry>();
                    for (RegisterDescriptionEntry registerDescriptionEntry : this.getDescriptionEntries()) {
                        registerDescriptionEntry.getNames().forEach(string -> hashMap.put(string.toLowerCase(), registerDescriptionEntry));
                        for (RegisterDescriptionEntry registerDescriptionEntry2 : registerDescriptionEntry.getSlices()) {
                            registerDescriptionEntry2.getNames().forEach(string -> hashMap.put(string.toLowerCase(), registerDescriptionEntry2));
                        }
                    }
                    this.namemap = hashMap;
                }
            }
        }
        return this.namemap;
    }

    @Override
    public RegisterDescriptionEntry getDescriptionEntryById(long l2) {
        return this.getByIdCache().get(l2);
    }

    private Map<Long, RegisterDescriptionEntry> getByIdCache() {
        if (this.idmap == null) {
            AbstractRegisterBank abstractRegisterBank = this;
            synchronized (abstractRegisterBank) {
                if (this.idmap == null) {
                    HashMap<Long, RegisterDescriptionEntry> hashMap = new HashMap<Long, RegisterDescriptionEntry>();
                    for (RegisterDescriptionEntry registerDescriptionEntry : this.getDescriptionEntries()) {
                        hashMap.put(registerDescriptionEntry.getId(), registerDescriptionEntry);
                        hashMap.put(registerDescriptionEntry.getPureId(), registerDescriptionEntry);
                        for (RegisterDescriptionEntry registerDescriptionEntry2 : registerDescriptionEntry.getSlices()) {
                            hashMap.put(registerDescriptionEntry2.getId(), registerDescriptionEntry2);
                        }
                    }
                    this.idmap = hashMap;
                }
            }
        }
        return this.idmap;
    }

    @Override
    public RegisterDescriptionEntry getDescriptionEntryByType(RegisterType registerType) {
        for (RegisterDescriptionEntry registerDescriptionEntry : this.getDescriptionEntries()) {
            if (registerDescriptionEntry.getType() != registerType) continue;
            return registerDescriptionEntry;
        }
        return null;
    }

    public String toString() {
        return this.format(0);
    }

    @Override
    public String format(int n2) {
        if (n2 == 1) {
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = 0;
            for (RegisterDescriptionEntry registerDescriptionEntry : this.getDescriptionEntries()) {
                Strings.ff(stringBuilder, "#%d: %s %d-bit", n3, registerDescriptionEntry.getName(), registerDescriptionEntry.getBitsize());
                if (registerDescriptionEntry.getType() != RegisterType.Unspecified) {
                    Strings.ff(stringBuilder, " %s", new Object[]{registerDescriptionEntry.getType()});
                }
                if (registerDescriptionEntry.getEncoding() != RegisterEncoding.unknown) {
                    Strings.ff(stringBuilder, " %s", new Object[]{registerDescriptionEntry.getEncoding()});
                }
                stringBuilder.append("\n");
                for (RegisterDescriptionEntry registerDescriptionEntry2 : registerDescriptionEntry.getSlices()) {
                    Strings.ff(stringBuilder, "  %s [%d:%d[\n", registerDescriptionEntry2.getName(), registerDescriptionEntry2.getBitstart(), registerDescriptionEntry2.getBitend());
                }
                ++n3;
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "layout(%d):", this.getCountOfDescriptionEntries());
        for (RegisterDescriptionEntry registerDescriptionEntry : this.getDescriptionEntries()) {
            Strings.ff(stringBuilder, "%s,", registerDescriptionEntry.getName());
        }
        return stringBuilder.toString();
    }
}

