/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class RegisterLayoutBridge {
    private static final ILogger logger = GlobalLog.getLogger(RegisterLayoutBridge.class);
    private IRegisterBank srcLayout;
    private IRegisterBank dstLayout;
    private Map<Integer, Integer> srcToDst = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> dstToSrc = new HashMap<Integer, Integer>();

    public RegisterLayoutBridge(IRegisterBank iRegisterBank, IRegisterBank iRegisterBank2) {
        this.srcLayout = iRegisterBank;
        this.dstLayout = iRegisterBank2;
        for (RegisterDescriptionEntry registerDescriptionEntry : iRegisterBank.getDescriptionEntries()) {
            RegisterDescriptionEntry registerDescriptionEntry2 = iRegisterBank2.getDescriptionEntryByName(registerDescriptionEntry.getNames());
            if (registerDescriptionEntry2 == null) {
                logger.debug("Register not found: %s", registerDescriptionEntry);
                continue;
            }
            if (registerDescriptionEntry2.isRegisterSlice()) {
                if (registerDescriptionEntry2.getBitstart() != 0) {
                    logger.debug("Forbidding register partial match: %s <> %s (full: %s)", registerDescriptionEntry, registerDescriptionEntry2, registerDescriptionEntry2.getContainer());
                    continue;
                }
                logger.debug("Register partial match: %s <> %s (full: %s)", registerDescriptionEntry, registerDescriptionEntry2, registerDescriptionEntry2.getContainer());
            }
            if (this.srcToDst.containsKey(registerDescriptionEntry.getNumber()) || this.dstToSrc.containsKey(registerDescriptionEntry2.getNumber())) {
                logger.debug("Register already registered: %s <> %s", registerDescriptionEntry, registerDescriptionEntry2);
                continue;
            }
            this.srcToDst.put(registerDescriptionEntry.getNumber(), registerDescriptionEntry2.getNumber());
            this.dstToSrc.put(registerDescriptionEntry2.getNumber(), registerDescriptionEntry.getNumber());
        }
    }

    public Integer convertSource(int n2) {
        return this.srcToDst.get(n2);
    }

    public Integer convertDestination(int n2) {
        return this.dstToSrc.get(n2);
    }

    public byte[] convertSourceValue(int n2, int n3, byte[] byArray) {
        int n4 = this.srcLayout.getDescriptionEntry(n2).getSize();
        Assert.a(n4 == byArray.length);
        int n5 = this.dstLayout.getDescriptionEntry(n3).getSize();
        if (n4 == n5) {
            return byArray;
        }
        if (n4 < n5) {
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            return byArray2;
        }
        return Arrays.copyOf(byArray, n5);
    }

    public byte[] convertDestinationValue(int n2, int n3, byte[] byArray) {
        int n4 = this.dstLayout.getDescriptionEntry(n2).getSize();
        Assert.a(n4 == byArray.length);
        int n5 = this.srcLayout.getDescriptionEntry(n3).getSize();
        if (n4 == n5) {
            return byArray;
        }
        if (n4 < n5) {
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            return byArray2;
        }
        return Arrays.copyOf(byArray, n5);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n2 : this.srcToDst.keySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            int n3 = this.srcToDst.get(n2);
            Strings.ff(stringBuilder, "%d>%d", n2, n3);
        }
        return stringBuilder.toString();
    }
}

