/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterEncoding;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterType;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class RegisterDescriptionEntry {
    private int number;
    private int reg_grp;
    private int reg_idx;
    private long id0;
    private RegisterEncoding encoding;
    private RegisterType type;
    private int offset;
    private List<RegisterDescriptionEntry> slices = new ArrayList<RegisterDescriptionEntry>();
    private List<String> names = new ArrayList<String>();
    private int bitsize;
    private RegisterDescriptionEntry container;
    private int bitstart;

    public RegisterDescriptionEntry sl(String string, int n2, int n3) {
        this.slices.add(new RegisterDescriptionEntry(string, n2, n3, this));
        return this;
    }

    public RegisterDescriptionEntry sl(String string, int n2) {
        return this.sl(string, 0, n2);
    }

    private RegisterDescriptionEntry(String string, int n2, int n3, RegisterDescriptionEntry registerDescriptionEntry) {
        if (registerDescriptionEntry == null || registerDescriptionEntry.container != null || string == null || string.isEmpty() || registerDescriptionEntry.names.contains(string) || n2 < 0 || n3 > registerDescriptionEntry.bitsize || n2 >= n3) {
            throw new IllegalArgumentException();
        }
        this.addName(string);
        this.bitstart = n2;
        this.bitsize = n3 - n2;
        this.container = registerDescriptionEntry;
    }

    public RegisterDescriptionEntry(int n2, String string, int n3, RegisterEncoding registerEncoding, String string2, RegisterType registerType, int n4) {
        if (Strings.isBlank(string)) {
            throw new IllegalArgumentException("Register name cannot be null or empty: " + string);
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("Illegal register bitsize: " + n3);
        }
        this.number = n2;
        this.addName(string);
        this.bitsize = n3;
        this.reg_grp = -1;
        this.reg_idx = -1;
        this.id0 = -1L;
        this.addName(string2);
        this.encoding = registerEncoding == null ? RegisterEncoding.unknown : registerEncoding;
        this.type = registerType == null ? RegisterType.Unspecified : registerType;
        this.offset = n4;
    }

    public boolean isPhysicalRegister() {
        return this.container == null;
    }

    public boolean isRegisterSlice() {
        return this.container != null;
    }

    public void verifyPhysicalRegister() {
        if (!this.isPhysicalRegister()) {
            throw new RuntimeException("Must be called on a physical register");
        }
    }

    public void verifyRegisterSlice() {
        if (!this.isRegisterSlice()) {
            throw new RuntimeException("Must be called on a register slice");
        }
    }

    public RegisterDescriptionEntry getContainer() {
        this.verifyRegisterSlice();
        return this.container;
    }

    public int getNumber() {
        if (this.container != null) {
            return this.container.number;
        }
        return this.number;
    }

    public long getId() {
        if (this.isPhysicalRegister()) {
            if (this.id0 == -1L) {
                return RegisterUtil.createRegisterIdFromPureId(this.getNumber(), this.bitsize, this.bitstart);
            }
            return RegisterUtil.createRegisterIdFromPureId(this.id0, this.bitsize, this.bitstart);
        }
        if (this.container.id0 == -1L) {
            return RegisterUtil.createRegisterIdFromPureId(this.container.getNumber(), this.bitsize, this.bitstart);
        }
        return RegisterUtil.createRegisterIdFromPureId(this.container.id0, this.bitsize, this.bitstart);
    }

    public long getPureId() {
        this.verifyPhysicalRegister();
        if (this.id0 == -1L) {
            return this.getNumber();
        }
        return this.id0;
    }

    public RegisterDescriptionEntry grp(int n2, int n3) {
        this.verifyPhysicalRegister();
        this.reg_grp = n2;
        this.reg_idx = n3;
        this.id0 = RegisterUtil.createPureRegisterId(this.reg_idx, this.reg_grp);
        return this;
    }

    public int getOffset() {
        if (this.container != null) {
            return this.container.offset;
        }
        return this.offset;
    }

    public void setOffset(int n2) {
        this.verifyPhysicalRegister();
        this.offset = n2;
    }

    public String getName() {
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public boolean hasName(String string) {
        return this.hasName(string, false);
    }

    public boolean hasName(String string, boolean bl) {
        if (bl) {
            return this.names.contains(string);
        }
        for (String string2 : this.names) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName(Collection<String> collection) {
        return this.hasName(collection, false);
    }

    public boolean hasName(Collection<String> collection, boolean bl) {
        if (bl) {
            return CollectionUtils.containsAny(this.names, collection);
        }
        for (String string : this.names) {
            for (String string2 : collection) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public RegisterDescriptionEntry addName(String string) {
        if (string != null && !Strings.isBlank(string) && !this.names.contains(string)) {
            this.names.add(string);
        }
        return this;
    }

    public int getBitsize() {
        return this.bitsize;
    }

    public int getBitstart() {
        if (this.container != null) {
            return this.bitstart;
        }
        return 0;
    }

    public int getBitend() {
        if (this.container != null) {
            return this.bitstart + this.bitsize;
        }
        return this.bitsize;
    }

    public List<RegisterDescriptionEntry> getSlices() {
        return this.slices;
    }

    public RegisterDescriptionEntry getSlice(int n2, int n3) {
        for (RegisterDescriptionEntry registerDescriptionEntry : this.slices) {
            if (registerDescriptionEntry.getBitstart() != n2 || registerDescriptionEntry.getBitend() != n3) continue;
            return registerDescriptionEntry;
        }
        return null;
    }

    public int getSize() {
        return (this.bitsize + 7) / 8;
    }

    public RegisterEncoding getEncoding() {
        if (this.container != null) {
            return this.container.encoding;
        }
        return this.encoding;
    }

    public RegisterDescriptionEntry enc(RegisterEncoding registerEncoding) {
        if (this.container != null) {
            throw new RuntimeException();
        }
        this.encoding = registerEncoding;
        return this;
    }

    public RegisterType getType() {
        if (this.container != null) {
            return this.container.type;
        }
        return this.type;
    }

    public RegisterDescriptionEntry typ(RegisterType registerType) {
        this.verifyPhysicalRegister();
        this.type = registerType;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isRegisterSlice()) {
            Strings.ff(stringBuilder, "%d/SLICE:%s[%d-%d[", this.getNumber(), this.getName(), this.getBitstart(), this.getBitend());
        } else {
            Strings.ff(stringBuilder, "%d:%s(%d)", this.getNumber(), this.getName(), this.getBitsize());
        }
        if (this.names.size() >= 2) {
            Strings.ff(stringBuilder, "[%s]", Strings.join(",", this.names.subList(1, this.names.size())));
        }
        if (this.getType() != RegisterType.Unspecified) {
            Strings.ff(stringBuilder, "/%s", new Object[]{this.getType()});
        }
        if (this.getEncoding() != RegisterEncoding.unknown) {
            Strings.ff(stringBuilder, "/%s", new Object[]{this.getEncoding()});
        }
        if (this.getOffset() >= 0) {
            Strings.ff(stringBuilder, "@%Xh", this.getOffset());
        }
        return stringBuilder.toString();
    }
}

