/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class RegisterBankService {
    private static final ILogger logger = GlobalLog.getLogger(RegisterBankService.class);
    private static volatile RegisterBankService instance;
    private Map<ProcessorType, IRegisterBank> map = new LinkedHashMap<ProcessorType, IRegisterBank>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegisterBankService getInstance() {
        if (instance != null) return instance;
        Class<RegisterBankService> clazz = RegisterBankService.class;
        synchronized (RegisterBankService.class) {
            RegisterBankService registerBankService;
            if (instance != null) return instance;
            instance = registerBankService = new RegisterBankService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private RegisterBankService() {
    }

    public IRegisterBank add(ProcessorType processorType, IRegisterBank iRegisterBank) {
        if (processorType == null || iRegisterBank == null) {
            throw new IllegalArgumentException();
        }
        Map<ProcessorType, IRegisterBank> map = this.map;
        synchronized (map) {
            return this.map.put(processorType, iRegisterBank);
        }
    }

    public boolean remove(ProcessorType processorType) {
        Map<ProcessorType, IRegisterBank> map = this.map;
        synchronized (map) {
            return this.map.remove(processorType) != null;
        }
    }

    public IRegisterBank get(ProcessorType processorType) {
        Map<ProcessorType, IRegisterBank> map = this.map;
        synchronized (map) {
            return this.map.get(processorType);
        }
    }

    public Collection<ProcessorType> getSupportedProcessors() {
        Map<ProcessorType, IRegisterBank> map = this.map;
        synchronized (map) {
            return Collections.unmodifiableSet(this.map.keySet());
        }
    }
}

