/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteOrder;
import java.util.Arrays;

@Ser
public class BytesBlock {
    @SerId(value=1)
    private byte[] code;
    @SerId(value=2)
    private boolean isBigEndian;
    @SerId(value=3)
    private int groupSize;

    public BytesBlock(byte[] byArray) {
        this(byArray, Endianness.LITTLE_ENDIAN, 1);
    }

    public BytesBlock(byte[] byArray, Endianness endianness, int n2) {
        if (n2 != 1 && (n2 <= 0 || n2 % 2 != 0)) {
            throw new IllegalArgumentException("Ilegal group size: " + n2);
        }
        if (byArray.length % n2 != 0) {
            throw new IllegalArgumentException("Ilegal block size: " + n2);
        }
        this.code = byArray;
        this.isBigEndian = endianness.isBig();
        this.groupSize = n2;
    }

    public byte[] getCode() {
        return this.code;
    }

    public byte[] getCode(ByteOrder byteOrder) {
        boolean bl;
        if (this.groupSize == 1) {
            return this.code;
        }
        boolean bl2 = bl = byteOrder == ByteOrder.BIG_ENDIAN;
        if (bl == this.isBigEndian) {
            return this.code;
        }
        return this.swap();
    }

    public byte[] getBECode() {
        if (this.groupSize == 1) {
            return this.code;
        }
        if (this.isBigEndian) {
            return this.code;
        }
        return this.swap();
    }

    public byte[] getLECode() {
        if (this.groupSize == 1) {
            return this.code;
        }
        if (!this.isBigEndian) {
            return this.code;
        }
        return this.swap();
    }

    private byte[] swap() {
        byte[] byArray = new byte[this.code.length];
        ArrayUtil.copyBytes(byArray, 0, this.code, 0, this.code.length);
        EndianUtil.swapByGroup(byArray, this.groupSize);
        return byArray;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + Arrays.hashCode(this.code);
        n2 = 31 * n2 + this.groupSize;
        n2 = 31 * n2 + (this.isBigEndian ? 1231 : 1237);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BytesBlock bytesBlock = (BytesBlock)object;
        if (!Arrays.equals(this.code, bytesBlock.code)) {
            return false;
        }
        if (this.groupSize != bytesBlock.groupSize) {
            return false;
        }
        return this.isBigEndian == bytesBlock.isBigEndian;
    }
}

